/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.volume3d;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import net.alomax.geog.DistanceAzimuth;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.Position;
import net.alomax.geog.SphericalTrig;
import net.alomax.graphics3d.Vect3D;
import net.alomax.volume3d.SlownessModel;
import net.alomax.volume3d.Volume3DException;

public class TauPSlownessModel
extends SlownessModel {
    public static String DEFAULT_MODEL = "iasp91.taup";
    public static String DEFAULT_PHASE_LIST = "P,S";
    public static double DEFAULT_RAYLEIGH_VELOCITY = 3.8;
    public static double DEFAULT_LOVE_VELOCITY = 4.25;
    protected TauModel tauModel = null;
    protected TauP_Time timeTool = null;
    protected TauP_Path pathTool = null;
    protected String tauPmodelName = null;
    protected String phaseList = DEFAULT_PHASE_LIST;
    protected double lastDepth = -1.0;
    protected double lastDepthPaths = Double.NEGATIVE_INFINITY;

    public TauPSlownessModel() throws Exception {
        this(DEFAULT_MODEL, DEFAULT_PHASE_LIST);
    }

    public TauPSlownessModel(String string) throws Exception {
        this(null, string);
    }

    public TauPSlownessModel(String string, String string2) throws Exception {
        this(string, string2, true);
    }

    public TauPSlownessModel(String string, String string2, boolean bl) throws Exception {
        super(new Vect3D(-90.0, -180.0, 0.0), new Vect3D(180.0, 360.0, 6371.0), new GeogCoords());
        if (string == null) {
            string = DEFAULT_MODEL;
        }
        this.tauPmodelName = string;
        try {
            this.timeTool = new TauP_Time(string);
        }
        catch (Exception exception) {
            String string3 = "ERROR: Creating TauP_time: " + exception;
            System.out.println(string3);
            throw exception;
        }
        try {
            this.pathTool = new TauP_Path(string);
        }
        catch (Exception exception) {
            String string4 = "ERROR: Creating TauP_Path: " + exception;
            System.out.println(string4);
            throw exception;
        }
        if (bl) {
            System.out.println("INFO: TauP model name: " + string);
        }
        this.timeTool.parsePhaseList(string2);
        this.tauModel = this.timeTool.getTauModel();
    }

    public String toString() {
        String string = this.getClass().getName();
        try {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(this.tauPmodelName);
        stringBuffer.append(this.phaseList);
        stringBuffer.append(ENDLINE);
        return stringBuffer.toString();
    }

    public final double getSlowness(Vect3D vect3D, String string) {
        double d = -1.0;
        char c = string.equalsIgnoreCase("P") ? (char)'P' : 'S';
        try {
            VelocityModel velocityModel = this.tauModel.getVelocityModel();
            d = 1.0 / velocityModel.getVelocityLayerClone(velocityModel.layerNumberBelow(vect3D.z)).evaluateAt(vect3D.z, c);
        }
        catch (Exception exception) {
            d = -1.0;
        }
        return d;
    }

    public final double getQuality(Vect3D vect3D, String string) {
        double d = -1.0;
        char c = string.equalsIgnoreCase("P") ? (char)'P' : 'S';
        try {
            VelocityModel velocityModel = this.tauModel.getVelocityModel();
            d = this.evaluateQuality(velocityModel.getVelocityLayerClone(velocityModel.layerNumberBelow(vect3D.z)), vect3D.z, c);
        }
        catch (Exception exception) {
            d = -1.0;
        }
        return d;
    }

    public final double evaluateQuality(VelocityLayer velocityLayer, double d, char c) throws Volume3DException {
        double d2;
        switch (c) {
            case 'P': 
            case 'p': {
                double d3 = (velocityLayer.botQp - velocityLayer.topQp) / (velocityLayer.botDepth - velocityLayer.topDepth);
                d2 = d3 * (d - velocityLayer.topDepth) + velocityLayer.topQp;
                break;
            }
            case 'S': 
            case 's': {
                double d4 = (velocityLayer.botQs - velocityLayer.topQs) / (velocityLayer.botDepth - velocityLayer.topDepth);
                d2 = d4 * (d - velocityLayer.topDepth) + velocityLayer.topQs;
                break;
            }
            default: {
                String string = "TauPSlownessModel.evaluateQ: Unrecognized wavetype: " + c + "\nUse one of P p S s";
                throw new Volume3DException(string);
            }
        }
        return d2;
    }

    public final double[] getPartialDerivatives(Vect3D vect3D, Vect3D vect3D2, String string) {
        return null;
    }

    public final double getTravelTime(Vect3D vect3D, Vect3D vect3D2, String string) {
        Position position = new Position(vect3D.y, vect3D.x, vect3D.z);
        Position position2 = new Position(vect3D2.y, vect3D2.x, vect3D2.z);
        DistanceAzimuth distanceAzimuth = SphericalTrig.distAz(position, position2);
        return this.getTravelTime(distanceAzimuth.distance, vect3D.z, string);
    }

    public final double getTravelTime(double d, double d2, String string) {
        if (string.equalsIgnoreCase("LR")) {
            return d * 111.11111111111111 / DEFAULT_RAYLEIGH_VELOCITY;
        }
        if (string.equalsIgnoreCase("LQ")) {
            return d * 111.11111111111111 / DEFAULT_LOVE_VELOCITY;
        }
        try {
            if (Math.abs(d2 - this.lastDepth) > (double)1.4E-45f) {
                this.timeTool.depthCorrect(d2);
                this.lastDepth = d2;
            }
            this.timeTool.calculate(d);
            Arrival[] arrivalArray = this.timeTool.getArrivals();
            for (int i = 0; i < arrivalArray.length; ++i) {
                if (!arrivalArray[i].getName().equals(string)) continue;
                return arrivalArray[i].getTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1.0;
        }
        return -1.0;
    }

    public final double getSurfaceReflectionTravelTime(Vect3D vect3D, Vect3D vect3D2, String string, String string2, double d, TauPSlownessModel tauPSlownessModel) {
        Position position = new Position(vect3D.y, vect3D.x, vect3D.z);
        Position position2 = new Position(vect3D2.y, vect3D2.x, vect3D2.z);
        DistanceAzimuth distanceAzimuth = SphericalTrig.distAz(position, position2).toDegrees();
        double d2 = distanceAzimuth.distance;
        double d3 = 0.0;
        double d4 = d2;
        double d5 = d2 / 4.0;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.MAX_VALUE;
        do {
            double d8 = d3;
            do {
                double d9 = this.getTravelTime(d8, vect3D.z, string);
                double d10 = tauPSlownessModel.getTravelTime(d2 - d8, vect3D2.z, string2);
                double d11 = d9 + d10;
                if (d9 < 0.0 && d10 >= 0.0) {
                    d11 = d10;
                }
                if (d9 >= 0.0 && d10 < 0.0) {
                    d11 = d9;
                }
                if (!(d11 >= 0.0) || !(d11 < d6)) continue;
                d6 = d11;
                d7 = d8;
            } while ((d8 += d5) < d4 + d5 / 2.0);
            d3 = d7 - d5;
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (!((d4 = d7 + d5) > d2)) continue;
            d4 = d2;
        } while ((d5 = (d4 - d3) / 4.0) > d);
        return d6;
    }

    public final Arrival getArrival(double d, double d2, String string) {
        try {
            if (Math.abs(d2 - this.lastDepth) > (double)1.4E-45f) {
                this.timeTool.depthCorrect(d2);
                this.lastDepth = d2;
            }
            this.timeTool.calculate(d);
            Arrival[] arrivalArray = this.timeTool.getArrivals();
            for (int i = 0; i < arrivalArray.length; ++i) {
                if (!arrivalArray[i].getName().equals(string)) continue;
                return arrivalArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public final Arrival getArrivalPath(double d, double d2, String string) {
        Arrival arrival = null;
        double d3 = Double.MAX_VALUE;
        try {
            if (Math.abs(d2 - this.lastDepthPaths) > (double)1.4E-45f) {
                this.pathTool.setSourceDepth(d2);
                this.lastDepthPaths = d2;
            }
            this.pathTool.clearPhaseNames();
            this.pathTool.appendPhaseName(string);
            this.pathTool.calculate(d);
            Arrival[] arrivalArray = this.pathTool.getArrivals();
            for (int i = 0; i < arrivalArray.length; ++i) {
                if (!arrivalArray[i].getName().equals(string) || !(arrivalArray[i].getTime() < d3)) continue;
                arrival = arrivalArray[i];
                d3 = arrival.getTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return arrival;
        }
        return arrival;
    }

    public static void main(String[] stringArray) {
    }
}

