/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class Smoothing
extends TimeDomainProcess {
    public static final int TYPE_BOXCAR = 0;
    public static final int TYPE_TRIANGLE = 1;
    public static final int TYPE_COSINE = 2;
    public static final int TYPE_MEDIAN = 3;
    private static final int NUM_TYPES = 4;
    public int type = 0;
    public static final String NAME_BOXCAR = "BOXCAR";
    public static final String NAME_TRIANGLE = "TRIANGLE";
    public static final String NAME_COSINE = "COSINE";
    public static final String NAME_MEDIAN = "MEDIAN";
    public int windowHalfWidth = 50;
    public String errorMessage = " ";
    private static final int WINDOW_MIN = 1;
    private static final int WINDOW_MAX = Integer.MAX_VALUE;

    public Smoothing(String string, int n, int n2) {
        this.type = n;
        this.windowHalfWidth = n2;
        TimeDomainText.setLocale(string);
    }

    public Smoothing(Smoothing smoothing) {
        this.type = smoothing.type;
        this.windowHalfWidth = smoothing.windowHalfWidth;
        this.useMemory = smoothing.useMemory;
        if (smoothing.memory != null) {
            this.memory = new TimeDomainMemory(smoothing.memory);
        }
    }

    public void setWindowHalfWidth(int n) throws TimeDomainException {
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_half_width_value + ": " + n);
        }
        this.windowHalfWidth = n;
    }

    public void setWindowHalfWidth(String string) throws TimeDomainException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_half_width_value + ": " + string);
        }
        this.setWindowHalfWidth(n);
    }

    public void setType(String string) throws TimeDomainException {
        if (NAME_BOXCAR.startsWith(string.toUpperCase())) {
            this.type = 0;
        } else if (NAME_TRIANGLE.startsWith(string.toUpperCase())) {
            this.type = 1;
        } else if (NAME_COSINE.startsWith(string.toUpperCase())) {
            this.type = 2;
        } else if (NAME_MEDIAN.startsWith(string.toUpperCase())) {
            this.type = 3;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_type + ": " + string);
        }
    }

    public void setType(int n) throws TimeDomainException {
        if (n < 0 || n >= 4) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_type + ": " + n);
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean supportsMemory() {
        return true;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        this.setWindowHalfWidth(this.windowHalfWidth);
        this.setType(this.type);
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        float[] fArray2 = fArray;
        if (this.useMemory && this.memory == null) {
            this.memory = new TimeDomainMemory(0, 0.0f, this.windowHalfWidth, 0.0f);
        }
        if (this.type == 0) {
            fArray2 = this.applyBoxcar(d, fArray);
        }
        if (this.type == 1) {
            fArray2 = this.applyTriangle(d, fArray);
        }
        if (this.useMemory) {
            for (int i = 0; i < this.windowHalfWidth; ++i) {
                this.memory.output[i] = fArray[fArray.length - (this.windowHalfWidth - i)];
            }
        }
        return fArray2;
    }

    public final float[] applyBoxcar(double d, float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            int n;
            int n2 = i - this.windowHalfWidth;
            if (!this.useMemory && n2 < 0) {
                n2 = 0;
            }
            if (!this.useMemory) {
                n = i + this.windowHalfWidth;
                if (n > fArray.length) {
                    n = fArray.length;
                }
            } else {
                n = i;
            }
            double d2 = 0.0;
            int n3 = 0;
            float f = 0.0f;
            for (int j = n2; j < n; ++j) {
                f = this.useMemory && j < 0 ? this.memory.output[this.windowHalfWidth + j] : fArray[j];
                d2 += (double)f;
                ++n3;
            }
            fArray2[i] = n3 > 0 ? (float)(d2 / (double)n3) : 0.0f;
        }
        return fArray2;
    }

    public final float[] applyTriangle(double d, float[] fArray) {
        int n;
        float[] fArray2 = new float[fArray.length];
        double[] dArray = new double[2 * this.windowHalfWidth + 1];
        for (n = 0; n < this.windowHalfWidth; ++n) {
            double d2 = 1.0 - (double)(this.windowHalfWidth - n) / (double)this.windowHalfWidth;
            dArray[2 * this.windowHalfWidth - n] = d2;
            dArray[n] = d2;
        }
        dArray[this.windowHalfWidth] = 1.0;
        for (n = 0; n < fArray.length; ++n) {
            int n2;
            int n3 = n - this.windowHalfWidth;
            if (!this.useMemory && n3 < 0) {
                n3 = 0;
            }
            if (!this.useMemory) {
                n2 = n + this.windowHalfWidth;
                if (n2 > fArray.length) {
                    n2 = fArray.length;
                }
            } else {
                n2 = n;
            }
            int n4 = n3 - n + this.windowHalfWidth;
            double d3 = 0.0;
            double d4 = 0.0;
            float f = 0.0f;
            for (int i = n3; i < n2; ++i) {
                f = this.useMemory && i < 0 ? this.memory.output[this.windowHalfWidth + i] : fArray[i];
                d3 += (double)f * dArray[n4];
                d4 += dArray[n4];
                ++n4;
            }
            fArray2[n] = d4 > 0.0 ? (float)(d3 / d4) : 0.0f;
        }
        return fArray2;
    }

    public void updateFields(TimeSeries timeSeries) {
    }

    public boolean amplititudeModified() {
        return true;
    }
}

