/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.alomax.net.GeneralURLConnection;
import net.alomax.swing.AJLJComboBox;
import net.alomax.swing.BusyIndicator;
import net.alomax.swing.JPolygonButton;
import net.alomax.swing.SimpleBrowserListener;
import net.alomax.swing.SwingExt;
import net.alomax.swing.SwingText;

public class SimpleBrowser
extends JFrame
implements ActionListener {
    protected static final String emptyPageHTML = "<html> </html>";
    protected URL documentBase = null;
    protected AJLJComboBox urlComboBox = null;
    protected JEditorPane webPane = null;
    protected JTextField messageBox = null;
    protected BusyIndicator busyIndicator = null;
    protected SimpleBrowserListener simpleBrowserListener = null;
    protected JPanel upperJPanel = null;
    protected JPolygonButton previousPageButton;
    protected JPolygonButton nextPageButton;
    protected JPolygonButton reloadButton;
    protected JPanel infoPanel = null;
    protected String previousPage = null;
    protected String currentPage = null;
    protected String nextPage = null;
    int icount = 0;

    public SimpleBrowser(JFrame jFrame, String string, boolean bl, URL uRL) {
        this(jFrame, string, bl, uRL, null);
    }

    public SimpleBrowser(JFrame jFrame, String string, boolean bl, URL uRL, AJLJComboBox aJLJComboBox) {
        super(string);
        this.documentBase = uRL;
        this.urlComboBox = aJLJComboBox;
        this.setDefaultCloseOperation(2);
        Image image = jFrame.getIconImage();
        if (image != null) {
            this.setIconImage(jFrame.getIconImage());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (SimpleBrowser.this.busyIndicator != null) {
                    try {
                        SimpleBrowser.this.busyIndicator.finalize();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                SimpleBrowser.this.busyIndicator = null;
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.previousPageButton = new JPolygonButton(JPolygonButton.LEFT_ARROW, this, null, false);
        this.previousPageButton.setPolygonFillColor(Color.GREEN);
        this.nextPageButton = new JPolygonButton(JPolygonButton.RIGHT_ARROW, this, null, false);
        this.nextPageButton.setPolygonFillColor(Color.GREEN);
        this.reloadButton = new JPolygonButton(JPolygonButton.CIRCLE, this, null, false);
        this.reloadButton.setPolygonFillColor(Color.GREEN);
        jPanel.add(this.previousPageButton);
        jPanel.add(this.nextPageButton);
        jPanel.add(new JLabel(SwingText.ADDRESS + ": "));
        if (this.urlComboBox == null) {
            this.urlComboBox = new AJLJComboBox();
            this.urlComboBox.setEditable(true);
            this.urlComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AJLJComboBox aJLJComboBox = (AJLJComboBox)actionEvent.getSource();
                    SimpleBrowser.this.load(aJLJComboBox.getSelectedItem().toString());
                }
            });
        }
        this.upperJPanel = new JPanel(new BorderLayout());
        this.upperJPanel.add((Component)jPanel, "West");
        this.upperJPanel.add((Component)this.urlComboBox, "Center");
        this.webPane = new JEditorPane("text/html", "");
        this.webPane.setText(emptyPageHTML);
        this.webPane.setEditable(false);
        this.webPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SimpleBrowserListener simpleBrowserListener = SimpleBrowser.this.getSimpleBrowserListener();
                    if (simpleBrowserListener != null) {
                        SimpleBrowser.this.startBusyIndicator(SwingText.LOADING + ": " + hyperlinkEvent.getURL());
                        if (!simpleBrowserListener.hyperlinkActivated(hyperlinkEvent.getURL())) {
                            SimpleBrowser.this.stopBusyIndicator();
                            return;
                        }
                        SimpleBrowser.this.stopBusyIndicator();
                    }
                    try {
                        SimpleBrowser.this.urlComboBox.insertItem(hyperlinkEvent.getURL().toString());
                    }
                    catch (Exception exception) {}
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    try {
                        SimpleBrowser.this.writeMessage("$" + hyperlinkEvent.getURL().toString());
                    }
                    catch (Exception exception) {}
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    try {
                        SimpleBrowser.this.writeMessage("$");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.webPane);
        this.messageBox = new JTextField();
        this.messageBox.setEditable(false);
        this.infoPanel = new JPanel(new BorderLayout());
        this.addBusyIndicator();
        this.infoPanel.add((Component)this.messageBox, "Center");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", this.upperJPanel);
        container.add("Center", jScrollPane);
        container.add("South", this.infoPanel);
        SwingExt.setProportionalSize((Component)this, jFrame, 0.95, 0.95);
        SwingExt.setLocationToCenterOfScreen(this);
        this.setVisible(true);
    }

    public AJLJComboBox getUrlComboBox() {
        return this.urlComboBox;
    }

    public void setUrlComboBox(AJLJComboBox aJLJComboBox) {
        this.urlComboBox = aJLJComboBox;
    }

    public SimpleBrowserListener getSimpleBrowserListener() {
        return this.simpleBrowserListener;
    }

    public void setSimpleBrowserListener(SimpleBrowserListener simpleBrowserListener) {
        this.simpleBrowserListener = simpleBrowserListener;
    }

    public void writeMessage(String string, boolean bl) {
        if (bl) {
            System.err.println(string);
        }
        if (this.messageBox == null) {
            return;
        }
        if (string.startsWith("ERROR")) {
            this.busyIndicator.showError();
        } else if (string.startsWith("WARNING")) {
            this.busyIndicator.showWarning();
        } else if (string.startsWith("INFO")) {
            this.busyIndicator.showInformation();
        } else if (string.startsWith("RELOAD")) {
            this.busyIndicator.showReload();
        } else if (string.startsWith("$")) {
            string = string.substring(1);
            this.busyIndicator.showNothing();
        } else {
            System.err.println("!PROGRAMMING NOTE: message without ERROR/WARNING/INFO/$: " + string);
        }
        this.messageBox.setText(" " + string);
        Graphics graphics = this.messageBox.getGraphics();
        this.messageBox.paint(graphics);
        graphics.dispose();
    }

    public void writeMessage(String string) {
        this.writeMessage(string, false);
    }

    public boolean load(String string) {
        if (string == null) {
            return false;
        }
        this.startBusyIndicator(SwingText.LOADING + ": " + string);
        String string2 = string;
        try {
            this.webPane.setPage(string2);
        }
        catch (Exception exception) {
            try {
                string2 = "http://" + string;
                this.webPane.setPage(string2);
            }
            catch (Exception exception2) {
                try {
                    string2 = "file://" + string;
                    this.webPane.setPage(string2);
                }
                catch (Exception exception3) {
                    try {
                        string2 = GeneralURLConnection.createURL(this.documentBase, string).toString();
                        this.webPane.setPage(string2);
                    }
                    catch (Exception exception4) {
                        this.stopBusyIndicator();
                        String string3 = "ERROR: " + exception4 + ": " + SwingText.LOADING + ": " + string;
                        this.writeMessage(string3);
                        System.out.println();
                        return false;
                    }
                }
            }
        }
        this.stopBusyIndicator();
        return true;
    }

    public void load(int n) {
        if (n < 0 || n >= this.urlComboBox.getItemCount()) {
            return;
        }
        this.urlComboBox.setSelectedItem(this.urlComboBox.getItemAt(n));
    }

    public void loadRelatve(int n) {
        int n2 = this.urlComboBox.getSelectedIndex() + n;
        this.load(n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource().equals(this.previousPageButton)) {
            this.loadRelatve(1);
        } else if (actionEvent.getSource().equals(this.nextPageButton)) {
            this.loadRelatve(-1);
        } else if (actionEvent.getSource().equals(this.reloadButton)) {
            this.load(this.urlComboBox.getSelectedItem().toString());
            this.webPane.validate();
        }
    }

    public void startBusyIndicator(String string) {
        if (this.busyIndicator == null) {
            this.addBusyIndicator();
        }
        this.busyIndicator.start(string);
    }

    public void stopBusyIndicator() {
        if (this.busyIndicator == null) {
            this.addBusyIndicator();
        }
        this.busyIndicator.stop();
    }

    protected void addBusyIndicator() {
        this.busyIndicator = new BusyIndicator(this.messageBox);
        this.infoPanel.add("West", this.busyIndicator);
    }
}

