/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TestPicker2;
import net.alomax.timedom.TimeDomainException;

public class TestPicker2ToolManager
extends JToolManager {
    protected String[] typeNames = new String[]{"FORWARD", "BACKWARD"};
    protected String[] resultNames = new String[]{"PICKS", "CHAR_FUNC", "TRIGGERS"};
    protected SeisGram2KFrame seisFrame = null;
    protected TestPicker2 testPicker2;
    protected String defaultResultType = null;
    protected AJLJButton buttonApplyTestPicker;
    protected AJLJButton buttonReset;
    protected JTextField textFieldLongTermWindow;
    protected JTextField textFieldThreshold1;
    protected JTextField textFieldThreshold2;
    protected JTextField textFieldTUpEvent;
    protected JTextField textFieldMeanWindow;
    protected JComboBox choiceDirection;
    protected JComboBox choiceResults;
    protected JToolBar menuOptions = null;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public TestPicker2ToolManager(SeisGram2KFrame seisGram2KFrame, String string) {
        this.seisFrame = seisGram2KFrame;
        this.defaultResultType = string;
        this.updateLabel();
        this.commandNames = new String[]{"recurpick"};
        this.commandNamesShort = new String[]{"recp"};
        this.init();
    }

    public void init() {
        String string;
        long l;
        long l2;
        double d = 20.0;
        double d2 = 15.0;
        double d3 = 10.0;
        double d4 = 1.0;
        double d5 = 2.0;
        double d6 = 0.05;
        try {
            d6 = this.seisFrame.getActiveGatherSampleInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        d = 1000.0 * d6;
        long l3 = Math.round(d * 1000.0);
        if (l3 > 1L) {
            d = (double)l3 / 1000.0;
        }
        if ((l2 = Math.round((d4 = 25.0 * d6) * 1000.0)) > 1L) {
            d4 = (double)l2 / 1000.0;
        }
        if ((l = Math.round((d5 = 100.0 * d6) * 1000.0)) > 1L) {
            d5 = (double)l / 1000.0;
        }
        this.testPicker2 = new TestPicker2(SeisGramText.getLocaleString(), d, d2, d3, d4, d5, 1);
        try {
            this.testPicker2.setResultsType(this.defaultResultType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.meanw");
            if (string != null) {
                this.testPicker2.setMeanWindow(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.ltw");
            if (string != null) {
                this.testPicker2.setLongTermWindow(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.thres1");
            if (string != null) {
                this.testPicker2.setThreshold1(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.thres2");
            if (string != null) {
                this.testPicker2.setThreshold2(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.tupevt");
            if (string != null) {
                this.testPicker2.setTUpEvent(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = this.seisFrame.getParameter("timedom.recurpick.dir");
            if (string != null) {
                this.testPicker2.setDirection(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
    }

    public void updateLabel() {
        this.label = SeisGramText.TEST_PICKER2;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        this.menuOptions = jToolBar;
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyTestPicker = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyTestPicker);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RECURSION_WINDOW + ":", 4));
        this.textFieldMeanWindow = SwingExt.newJTextField(this, this, String.valueOf(this.testPicker2.recursionWindow), 5);
        jToolBar.add(this.textFieldMeanWindow);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.LONG_TERM_WINDOW + ":", 4));
        this.textFieldLongTermWindow = SwingExt.newJTextField(this, this, String.valueOf(this.testPicker2.longTermWindow), 5);
        jToolBar.add(this.textFieldLongTermWindow);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.THRESHOLD1 + ":", 4));
        this.textFieldThreshold1 = SwingExt.newJTextField(this, this, String.valueOf(this.testPicker2.threshold1), 5);
        jToolBar.add(this.textFieldThreshold1);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.THRESHOLD2 + ":", 4));
        this.textFieldThreshold2 = SwingExt.newJTextField(this, this, String.valueOf(this.testPicker2.threshold2), 5);
        jToolBar.add(this.textFieldThreshold2);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TUPEVENT + ":", 4));
        this.textFieldTUpEvent = SwingExt.newJTextField(this, this, String.valueOf(this.testPicker2.tUpEvent), 5);
        jToolBar.add(this.textFieldTUpEvent);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.DIRECTION + ":", 4));
        this.choiceDirection = SwingExt.newChoice(this, this.typeNames);
        this.choiceDirection.setSelectedItem(this.testPicker2.getDirectionString());
        jToolBar.add(this.choiceDirection);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RESULT + ":", 4));
        this.choiceResults = SwingExt.newChoice(this, this.resultNames);
        this.choiceResults.setSelectedItem(this.testPicker2.getResultsTypeString());
        jToolBar.add(this.choiceResults);
        jToolBar.addSeparator();
        this.buttonReset = new AJLJButton(this, this, SeisGramText.DEFAULTS);
        jToolBar.add(this.buttonReset);
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyTestPicker)) {
            boolean bl = false;
            try {
                this.testPicker2.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.testPicker2.longTermWindow));
            try {
                this.testPicker2.setThreshold1(this.textFieldThreshold1.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThreshold1.setText(String.valueOf(this.testPicker2.threshold1));
            try {
                this.testPicker2.setThreshold2(this.textFieldThreshold2.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThreshold2.setText(String.valueOf(this.testPicker2.threshold2));
            try {
                this.testPicker2.setTUpEvent(this.textFieldTUpEvent.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldTUpEvent.setText(String.valueOf(this.testPicker2.tUpEvent));
            try {
                this.testPicker2.setMeanWindow(this.textFieldMeanWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldMeanWindow.setText(String.valueOf(this.testPicker2.recursionWindow));
            try {
                this.testPicker2.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            try {
                this.testPicker2.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            if (bl) {
                return;
            }
            try {
                this.testPicker2.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldLongTermWindow)) {
            try {
                this.testPicker2.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.testPicker2.longTermWindow));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThreshold1)) {
            try {
                this.testPicker2.setThreshold1(this.textFieldThreshold1.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThreshold1.setText(String.valueOf(this.testPicker2.threshold1));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThreshold2)) {
            try {
                this.testPicker2.setThreshold2(this.textFieldThreshold2.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThreshold2.setText(String.valueOf(this.testPicker2.threshold2));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTUpEvent)) {
            try {
                this.testPicker2.setTUpEvent(this.textFieldTUpEvent.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldTUpEvent.setText(String.valueOf(this.testPicker2.tUpEvent));
            return;
        }
        if (actionEvent.getSource().equals(this.choiceDirection)) {
            try {
                this.testPicker2.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.choiceResults)) {
            try {
                this.testPicker2.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.buttonReset)) {
            if (this.menuOptions != null) {
                this.init();
                this.seisFrame.initializeInteractionPanel(this);
            }
            return;
        }
    }

    protected void setPickTestPicker() {
        Vector vector = this.testPicker2.getPickData();
        String string = this.testPicker2.getDirection() > 0 ? "P" : "Pb";
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            String string2 = string + i;
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string2);
        }
        this.seisFrame.writePicks();
    }

    protected void apply() throws TimeDomainException {
        this.testPicker2.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.testPicker2, this.getCommandString());
        if (this.testPicker2.getResultsType() == 0) {
            this.setPickTestPicker();
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        this.init();
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("meanw")) {
                        this.testPicker2.setMeanWindow(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ltw")) {
                        this.testPicker2.setLongTermWindow(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("thres1")) {
                        this.testPicker2.setThreshold1(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("thres2")) {
                        this.testPicker2.setThreshold2(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("tupevt")) {
                        this.testPicker2.setTUpEvent(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("dir")) {
                        this.testPicker2.setDirection(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("res")) {
                        this.testPicker2.setResultsType(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " meanw " + this.testPicker2.recursionWindow;
        string = string + " ltw " + this.testPicker2.longTermWindow;
        string = string + " thres1 " + this.testPicker2.threshold1;
        string = string + " thres2 " + this.testPicker2.threshold2;
        string = string + " tupevt " + this.testPicker2.tUpEvent;
        string = string + " dir " + this.testPicker2.getDirectionString();
        string = string + " res " + this.testPicker2.getResultsTypeString();
        return string;
    }
}

