/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.alomax.seisgram2k.ParticleMotionFrame;

class Panel3D
extends JPanel {
    private ParticleMotionFrame component;
    private int prevx;
    private int prevy;
    private int mouseDownx;
    private int mouseDowny;

    Panel3D(ParticleMotionFrame particleMotionFrame) {
        this.component = particleMotionFrame;
        this.enableEvents(48L);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.mouseDownx = this.prevx = n;
            this.mouseDowny = this.prevy = n2;
            this.component.mouseIsDown = true;
            return;
        }
        if (mouseEvent.getID() == 502) {
            this.component.mouseIsDown = false;
            if (n == this.mouseDownx && n2 == this.mouseDowny) {
                this.component.newWorldCenter(n, n2);
            }
            if (this.component.painted) {
                this.component.repaint();
            }
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 506) {
            this.component.tmpMat.unit();
            double d = 0.5f * (float)(this.prevy - n2) * (360.0f / (float)this.getSize().width);
            double d2 = 0.5f * (float)(n - this.prevx) * (360.0f / (float)this.getSize().height);
            this.component.tmpMat.xrot(-d);
            this.component.tmpMat.yrot(-d2);
            this.component.rotMat.mult(this.component.tmpMat);
            if (this.component.painted) {
                this.component.repaint();
            }
            this.prevx = n;
            this.prevy = n2;
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void paint(Graphics graphics) {
        this.component.paint(graphics, this.getSize(), false);
    }
}

