/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import ageco.misc.AgecPipedInputStream;
import ageco.misc.UrlToPipe;
import ageco.titan.TitanToBin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.Vector;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.net.GeneralURLConnection;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.seis.TitanDataSamples;

public class SeisDataTitan
extends SeisData {
    byte[][] titanInfos;
    public short NumberOfPoints;
    public boolean[] Trigger;
    public int FrameTime;
    public short FrameMilli;
    public int FrameRxTime;
    public short FrameRxMilli;
    public int CorrectedTime;
    public short CorrectedMilli;
    public byte SamplingFrequency;
    public short StepMilli;
    public int MilliCorrection;
    public int[][] Data;
    public byte Channel;
    public float TpgAdc;
    public float GpsLatitude;
    public float GpsLongitude;
    public float Gpsheight;
    public byte NumberOfChannels;
    public float FloatSamplingPeriod;
    public float FloatSamplingFrequency;
    public long TempsMilliDebut;
    public long TempsMilliFin;
    String titanfilename;

    public SeisDataTitan(TitanToBin titanToBin, int n, float[] fArray, GregorianCalendar gregorianCalendar) throws Exception {
        this.setHeaderFields(titanToBin, n, fArray, gregorianCalendar);
    }

    protected void setHeaderFields(TitanToBin titanToBin, int n, float[] fArray, GregorianCalendar gregorianCalendar) throws Exception {
        int n2;
        SeisDataTitan seisDataTitan = this;
        this.channel.network = titanToBin.getOwner();
        this.channel.staName = titanToBin.GetStationName();
        String string = "counts";
        float f = titanToBin.AFloatSamplingPeriod[n];
        this.timeSeries = new TimeSeriesFloat(fArray, f, 0.0, string, "sec");
        this.timeMin = 0.0;
        if (n == 0) {
            this.channel.inclination = 0.0;
            this.channel.azimuth = 0.0;
        } else if (n == 1) {
            this.channel.inclination = 90.0;
            this.channel.azimuth = 0.0;
        } else if (n == 2) {
            this.channel.inclination = 90.0;
            this.channel.azimuth = 90.0;
        }
        this.iyear = gregorianCalendar.get(1);
        this.ijday = gregorianCalendar.get(6);
        this.ihour = gregorianCalendar.get(11);
        this.imin = gregorianCalendar.get(12);
        this.sec = (double)gregorianCalendar.get(13) + (double)gregorianCalendar.get(14) / 1000.0;
        this.titanInfos = new byte[titanToBin.Infos.length][];
        for (n2 = 0; n2 < titanToBin.Infos.length; ++n2) {
            this.titanInfos[n2] = new byte[titanToBin.Infos[n2].length];
            for (int i = 0; i < titanToBin.Infos[n2].length; ++i) {
                this.titanInfos[n2][i] = titanToBin.Infos[n2][i];
            }
        }
        this.NumberOfPoints = titanToBin.NumberOfPoints;
        this.Trigger = new boolean[titanToBin.Trigger.length];
        for (n2 = 0; n2 < this.Trigger.length; ++n2) {
            this.Trigger[n2] = titanToBin.Trigger[n2];
        }
        this.FrameTime = titanToBin.FrameTime;
        this.FrameMilli = titanToBin.FrameMilli;
        this.FrameRxTime = titanToBin.FrameRxTime;
        this.FrameRxMilli = titanToBin.FrameRxMilli;
        this.CorrectedTime = titanToBin.CorrectedTime;
        this.CorrectedMilli = titanToBin.CorrectedMilli;
        this.SamplingFrequency = titanToBin.SamplingFrequency;
        this.StepMilli = titanToBin.StepMilli;
        this.MilliCorrection = titanToBin.MilliCorrection;
        this.Channel = titanToBin.Channel;
        this.TpgAdc = titanToBin.TpgAdc;
        this.GpsLatitude = titanToBin.GpsLatitude;
        this.GpsLongitude = titanToBin.GpsLongitude;
        this.Gpsheight = titanToBin.Gpsheight;
        this.NumberOfChannels = titanToBin.NumberOfChannels;
        this.FloatSamplingPeriod = titanToBin.AFloatSamplingPeriod[n];
        this.FloatSamplingFrequency = titanToBin.AFloatSamplingFrequency[n];
        this.TempsMilliDebut = titanToBin.TempsMilliDebut;
        this.TempsMilliFin = titanToBin.TempsMilliFin;
    }

    public void setSeismogramFields() {
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public static UrlToPipe openTitan_UrlToPipe(AgecPipedInputStream agecPipedInputStream, URL uRL, String string) throws MalformedURLException {
        URL uRL2 = GeneralURLConnection.createURL(uRL, string);
        UrlToPipe urlToPipe = new UrlToPipe(uRL2.toString(), agecPipedInputStream);
        return urlToPipe;
    }

    public static TitanToBin openTitan_TitanToBin(AgecPipedInputStream agecPipedInputStream) {
        TitanToBin titanToBin = new TitanToBin(agecPipedInputStream, true);
        titanToBin.freeRun = false;
        return titanToBin;
    }

    public static TitanDataSamples fillSamples(TitanToBin titanToBin, boolean bl) {
        int n;
        float[] fArray;
        int n2;
        int n3;
        int n4;
        Vector[] vectorArray = new Vector[32];
        int[] nArray = new int[32];
        for (n4 = 0; n4 < 32; ++n4) {
            vectorArray[n4] = new Vector();
            nArray[n4] = 0;
        }
        n4 = 0;
        if (bl) {
            // empty if block
        }
        boolean bl2 = false;
        while (!titanToBin.NoMoreData()) {
            int n5;
            n3 = titanToBin.GetData();
            if (bl2) {
                System.out.println("TitanToBin.GetData() returned : " + (n3 != 0));
            }
            if (bl2) {
                System.out.println("INFO: Titan: num points read : ");
                for (n5 = 0; n5 < 32; ++n5) {
                    System.out.print(" " + titanToBin.ANumberOfPoints[n5]);
                }
                System.out.println("");
            }
            n5 = 0;
            n2 = 0;
            while ((n2 = titanToBin.ANumberOfPoints[n5]) > 0) {
                n4 = n5 + 1 > n4 ? n5 + 1 : n4;
                fArray = new float[n2];
                for (n = 0; n < n2; ++n) {
                    fArray[n] = titanToBin.AData[n5][n];
                }
                int n6 = n5;
                nArray[n6] = nArray[n6] + n2;
                vectorArray[n5].addElement(fArray);
                ++n5;
            }
            if (!bl2) continue;
            System.out.println("INFO: Titan: titanToBin.NoMoreData(): " + titanToBin.NoMoreData() + " titanToBin.NoMoreDataInFile: " + titanToBin.NoMoreDataInFile);
            System.out.println("");
        }
        if (bl) {
            System.out.println("INFO: Titan: numChannelsRead : " + n4);
        }
        if (bl) {
            System.out.println("INFO: Titan: num channels read : " + n4 + " : total num points read : ");
            for (n3 = 0; n3 < 32; ++n3) {
                System.out.print(" " + nArray[n3]);
            }
            System.out.println("");
            System.out.println("");
        }
        float[][] fArrayArray = new float[n4][];
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            fArrayArray[n2] = new float[nArray[n2]];
            n = 0;
            for (int i = 0; i < vectorArray[n2].size(); ++i) {
                fArray = (float[])vectorArray[n2].elementAt(i);
                System.arraycopy(fArray, 0, fArrayArray[n2], n, fArray.length);
                n += fArray.length;
            }
            if (bl) {
                System.out.println("INFO: Titan: Channel : " + n2);
                System.out.print("INFO: Titan: Start Time : ");
            }
            gregorianCalendarArray[n2] = SeisDataTitan.getTimeStamp(titanToBin.TempsMilliFin, nArray[n2], titanToBin.AFloatSamplingPeriod[n2], bl);
            if (!bl || nArray[n2] <= 0) continue;
            System.out.print("INFO: Titan: End Time   : ");
            SeisDataTitan.getTimeStamp(titanToBin.TempsMilliFin, 0, titanToBin.AFloatSamplingPeriod[n2], bl);
            System.out.print("INFO: Titan: Corr Time  : ");
            SeisDataTitan.getTimeStamp(1000L * (long)titanToBin.CorrectedTime + (long)titanToBin.CorrectedMilli, 0, titanToBin.AFloatSamplingPeriod[n2], bl);
            System.out.println("INFO: Titan: AFloatSamplingPeriod : " + titanToBin.AFloatSamplingPeriod[n2]);
            System.out.println("");
        }
        TitanDataSamples titanDataSamples = new TitanDataSamples();
        titanDataSamples.dataSamples = fArrayArray;
        titanDataSamples.startTimeCalendar = gregorianCalendarArray;
        return titanDataSamples;
    }

    public static GregorianCalendar getTimeStamp(long l, int n, float f, boolean bl) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setTimeInMillis(l - (long)(1000.0 * (double)n * (double)f));
        if (bl) {
            System.out.println("" + gregorianCalendar.get(1) + "/" + gregorianCalendar.get(6) + "  " + gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12) + ":" + ((double)gregorianCalendar.get(13) + (double)gregorianCalendar.get(14) / 1000.0));
        }
        return gregorianCalendar;
    }

    public String getHeaderFieldsAsString() {
        int n;
        String string = System.getProperty("line.separator");
        String string2 = "# [Titan Data Format]" + string;
        string2 = string2 + "NumberOfPoints = " + this.NumberOfPoints + string;
        byte[] byArray = new byte[this.Trigger.length];
        for (n = 0; n < this.Trigger.length; ++n) {
            byArray[n] = this.Trigger[n] ? 49 : 48;
        }
        string2 = string2 + "Trigger = " + new String(byArray) + string;
        string2 = string2 + "FrameTime = " + this.FrameTime + string;
        string2 = string2 + "FrameMilli = " + this.FrameMilli + string;
        string2 = string2 + "FrameRxTime = " + this.FrameRxTime + string;
        string2 = string2 + "FrameRxMilli = " + this.FrameRxMilli + string;
        string2 = string2 + "CorrectedTime = " + this.CorrectedTime + string;
        string2 = string2 + "CorrectedMilli = " + this.CorrectedMilli + string;
        string2 = string2 + "SamplingFrequency = " + this.SamplingFrequency + string;
        string2 = string2 + "StepMilli = " + this.StepMilli + string;
        string2 = string2 + "MilliCorrection = " + this.MilliCorrection + string;
        string2 = string2 + "Channel = " + this.Channel + string;
        string2 = string2 + "TpgAdc = " + this.TpgAdc + string;
        string2 = string2 + "GpsLatitude = " + this.GpsLatitude + string;
        string2 = string2 + "GpsLongitude = " + this.GpsLongitude + string;
        string2 = string2 + "Gpsheight = " + this.Gpsheight + string;
        string2 = string2 + "NumberOfChannels = " + this.NumberOfChannels + string;
        string2 = string2 + "FloatSamplingPeriod = " + this.FloatSamplingPeriod + string;
        string2 = string2 + "FloatSamplingFrequency = " + this.FloatSamplingFrequency + string;
        string2 = string2 + "TempsMilliDebut = " + this.TempsMilliDebut + string;
        string2 = string2 + "TempsMilliFin = " + this.TempsMilliFin + string;
        for (n = 0; n < this.titanInfos.length; ++n) {
            string2 = string2 + "Info " + n + " = " + this.getInfoEntryAsString(n) + string;
        }
        return string2;
    }

    public String getInfoEntryAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.titanInfos[n].length);
        stringBuffer.setLength(0);
        for (int i = 0; i < this.titanInfos[n].length && this.titanInfos[n][i] != 0; ++i) {
            stringBuffer.append((char)this.titanInfos[n][i]);
        }
        return stringBuffer.toString();
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        return 0;
    }
}

