/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[n];
        this.pos = n;
    }

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.buf.length - this.pos;
        if (n3 > 0) {
            if (n2 < n3) {
                n3 = n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos += n3;
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            if ((n2 = super.read(byArray, n, n2)) == -1) {
                return n3 == 0 ? -1 : n3;
            }
            return n3 + n2;
        }
        return n3;
    }

    public void unread(int n) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)n;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n2 > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= n2;
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.buf.length - this.pos + super.available();
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.buf.length - this.pos;
        if (l2 > 0L) {
            if (l < l2) {
                l2 = l;
            }
            this.pos = (int)((long)this.pos + l2);
            l -= l2;
        }
        if (l > 0L) {
            l2 += super.skip(l);
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

