/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import net.alomax.geog.Constants;
import net.alomax.geog.DistanceAzimuth;
import net.alomax.geog.Position;

public class SphericalTrig
extends Constants {
    private SphericalTrig() {
    }

    public static final DistanceAzimuth distAz(Position position, Position position2) {
        double d = position.longitude * (Math.PI / 180);
        double d2 = position.latitude * (Math.PI / 180);
        double d3 = position2.longitude * (Math.PI / 180);
        double d4 = position2.latitude * (Math.PI / 180);
        if (d3 - d > 4.71238898038469) {
            d3 -= Math.PI * 2;
        } else if (d3 - d < -4.71238898038469) {
            d3 += Math.PI * 2;
        }
        double d5 = d4 - d2;
        double d6 = (d3 - d) * Math.cos((d2 + d4) / 2.0);
        double d7 = d6 * d6 + d5 * d5;
        double d8 = 0.0;
        if (d7 > 0.0) {
            d8 = Math.sqrt(d7);
        }
        if (d8 > 1.7453292519943296E-4) {
            return SphericalTrig.distAzGlobal(position, position2);
        }
        d8 /= Math.PI / 180;
        double d9 = Math.atan2(d6, d5);
        if ((d9 /= Math.PI / 180) < 0.0) {
            d9 += 360.0;
        }
        return new DistanceAzimuth(d8, 2, d9);
    }

    public static final DistanceAzimuth distAzGlobal(Position position, Position position2) {
        double d = position.longitude * (Math.PI / 180);
        double d2 = position.latitude * (Math.PI / 180);
        double d3 = position2.longitude * (Math.PI / 180);
        double d4 = position2.latitude * (Math.PI / 180);
        double d5 = Math.acos(Math.sin(d2) * Math.sin(d4) + Math.cos(d2) * Math.cos(d4) * Math.cos(d3 - d));
        double d6 = (Math.cos(d2) * Math.sin(d4) - Math.sin(d2) * Math.cos(d4) * Math.cos(d3 - d)) / Math.sin(d5);
        double d7 = Math.cos(d4) * Math.sin(d3 - d) / Math.sin(d5);
        double d8 = Math.atan2(d7, d6) / (Math.PI / 180);
        if (d8 < 0.0) {
            d8 += 360.0;
        }
        return new DistanceAzimuth(d5 /= Math.PI / 180, 2, d8);
    }

    public static void main(String[] stringArray) {
        Position position = new Position(0.0, 0.0, 0.0, 0.0);
        Position position2 = new Position(0.0, 0.0, 0.0, 0.0);
        System.out.print("Lat: " + position.latitude + " Lon:" + position.longitude + " -> ");
        System.out.println("Lat: " + position2.latitude + " Lon:" + position2.longitude);
        System.out.print("km:\n" + SphericalTrig.distAz(position, position2).toKilometers());
        System.out.println("degrees:\n" + SphericalTrig.distAz(position, position2).toDegrees());
        position = new Position(0.0, 0.0, 0.0, 0.0);
        position2 = new Position(0.0, 90.0, 0.0, 0.0);
        System.out.print("Lat: " + position.latitude + " Lon:" + position.longitude + " -> ");
        System.out.println("Lat: " + position2.latitude + " Lon:" + position2.longitude);
        System.out.print("km:\n" + SphericalTrig.distAz(position, position2).toKilometers());
        System.out.println("degrees:\n" + SphericalTrig.distAz(position, position2).toDegrees());
    }

    public static final Position positionAtDistAz(Position position, DistanceAzimuth distanceAzimuth) {
        if (distanceAzimuth.distanceUnits != 2) {
            distanceAzimuth = distanceAzimuth.toDegrees();
        }
        double d = position.longitude * (Math.PI / 180);
        double d2 = position.latitude * (Math.PI / 180);
        double d3 = distanceAzimuth.distance * (Math.PI / 180);
        double d4 = distanceAzimuth.azimuth * (Math.PI / 180);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        double d7 = Math.cos(d4);
        double d8 = Math.sin(d4);
        double d9 = Math.sin(d3);
        double d10 = Math.cos(d3);
        return new Position(57.29577951308232 * Math.asin(d6 * d10 + d5 * d9 * d7), 57.29577951308232 * (Math.atan2(d9 * d8, d5 * d10 - d6 * d9 * d7) + d));
    }
}

