/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import net.alomax.awt.AJLButton;
import net.alomax.awt.AJLColor;
import net.alomax.io.GeneralInputStream;

public class HelpFrame
extends Frame
implements ActionListener,
KeyListener {
    protected ResourceBundle resourceBundle;
    protected Vector nameVector = new Vector();
    protected Vector textVector = new Vector();
    protected Vector buttonVector = new Vector();
    protected TextArea textArea;
    protected Panel contentsPanel = new Panel();
    protected Label messagePanel = new Label();
    protected Label contentsLabel = new Label();
    protected AJLButton activeButton = null;

    public HelpFrame(String string, int n, int n2, Class clazz, URL uRL, String string2, Locale locale, Image image) {
        super(string);
        if (image != null) {
            // empty if block
        }
        this.setIconImage(image);
        String string3 = "";
        if (locale != null && (string3 = locale.toString()).endsWith("_ ")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        String string4 = string2 + "_" + string3 + ".properties";
        String string5 = "";
        InputStream inputStream = clazz.getResourceAsStream(string4);
        if (inputStream == null) {
            try {
                inputStream = GeneralInputStream.openStream(uRL, string4, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4 + "\n";
            string4 = string2 + "_" + locale.getDefault().toString() + ".properties";
            inputStream = clazz.getResourceAsStream(string4);
            if (inputStream == null) {
                try {
                    inputStream = GeneralInputStream.openStream(uRL, string4, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4 + "\n";
            string4 = string2 + ".properties";
            inputStream = clazz.getResourceAsStream(string4);
            if (inputStream == null) {
                try {
                    inputStream = GeneralInputStream.openStream(uRL, string4, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4;
            System.out.println(string5);
            this.dispose();
            return;
        }
        try {
            this.resourceBundle = new PropertyResourceBundle(inputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            string5 = "ERROR: creating help text resource bunde : " + string2;
            System.out.println(string5);
            this.dispose();
            return;
        }
        this.setContentsPanel(this.contentsPanel);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.add("North", this.messagePanel);
        this.textArea = new TextArea(" ", 0, 0, 1);
        this.textArea.setEditable(false);
        panel.add("Center", this.textArea);
        this.setLayout(new BorderLayout(0, 0));
        this.add("West", this.contentsPanel);
        this.add("Center", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpFrame.this.dispose();
            }
        });
        if (this.textVector.size() > 0) {
            this.writeMessage((String)this.nameVector.elementAt(0) + ":");
            this.textArea.setText((String)this.textVector.elementAt(0));
            this.selectButton((AJLButton)this.buttonVector.elementAt(0));
        } else {
            this.writeMessage("ERROR: No help documentation found.");
        }
        this.setSize(n, n2);
    }

    private void setContentsPanel(Panel panel) {
        panel.setLayout(new GridLayout(0, 1, 0, 0));
        try {
            this.contentsLabel.setText(" " + this.resourceBundle.getString("text.contents") + ":");
        }
        catch (MissingResourceException missingResourceException) {
            this.contentsLabel.setText("Contents:");
        }
        panel.add(this.contentsLabel);
        int n = 0;
        while (true) {
            String string;
            String string2;
            try {
                string2 = this.resourceBundle.getString("name." + n);
            }
            catch (MissingResourceException missingResourceException) {
                break;
            }
            try {
                string = this.resourceBundle.getString("text." + n);
            }
            catch (MissingResourceException missingResourceException) {
                string = "???";
            }
            this.nameVector.addElement(string2);
            this.textVector.addElement(string);
            AJLButton aJLButton = new AJLButton(this, this, string2);
            panel.add(aJLButton);
            this.buttonVector.addElement(aJLButton);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Font font;
        if (this.contentsLabel != null) {
            font = graphics.getFont();
            this.contentsLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        if (this.messagePanel != null) {
            font = graphics.getFont();
            this.messagePanel.setFont(new Font(font.getName(), 1, 4 * font.getSize() / 3));
        }
    }

    protected void selectButton(AJLButton aJLButton) {
        if (this.activeButton != null) {
            this.activeButton.setForeground(AJLColor.textText);
            this.activeButton.setBackground(AJLColor.control);
        }
        aJLButton.setForeground(AJLColor.textHighlightText);
        aJLButton.setBackground(AJLColor.controlLtHighlight);
        this.activeButton = aJLButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.buttonVector.size(); ++i) {
            if (!actionEvent.getSource().equals((AJLButton)this.buttonVector.elementAt(i))) continue;
            this.selectButton((AJLButton)this.buttonVector.elementAt(i));
            this.writeMessage((String)this.nameVector.elementAt(i) + ":");
            this.textArea.setText((String)this.textVector.elementAt(i));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void writeMessageToConsole(String string) {
        System.out.println(string);
    }

    void writeMessage(String string) {
        this.messagePanel.setText(string);
    }
}

