/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.StringTokenizer;
import net.alomax.swing.ApplicationJComp;

public class AJLColor {
    public static Color control = SystemColor.control;
    public static Color controlText = SystemColor.controlText;
    public static Color controlHighlight = SystemColor.controlHighlight;
    public static Color controlLtHighlight = SystemColor.controlLtHighlight;
    public static Color controlShadow = SystemColor.controlShadow;
    public static Color menu = SystemColor.menu;
    public static Color menuText = SystemColor.menuText;
    public static Color text = SystemColor.text;
    public static Color textHighlight = SystemColor.textHighlight;
    public static Color textText = SystemColor.textText;
    public static Color textHighlightText = SystemColor.textHighlightText;
    protected static boolean invertGreyScaleOnly = false;

    public static Color lighter(Color color) {
        int n;
        int n2;
        int n3 = 64;
        int n4 = color.getRed() + n3;
        if (n4 > 255) {
            n4 = 255;
        }
        if ((n2 = color.getGreen() + n3) > 255) {
            n2 = 255;
        }
        if ((n = color.getBlue() + n3) > 255) {
            n = 255;
        }
        return new Color(n4, n2, n);
    }

    public static void setInvertGreyScaleOnly(boolean bl) {
        invertGreyScaleOnly = bl;
    }

    public static Color invert(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (invertGreyScaleOnly && (n != n2 || n2 != n3)) {
            return new Color(n, n2, n3);
        }
        return new Color(255 - n, 255 - n2, 255 - n3);
    }

    public static Color greyscale(Color color) {
        int n = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        return new Color(n, n, n);
    }

    public static Color createColor(ApplicationJComp applicationJComp, String string, Color color) {
        try {
            String string2 = null;
            string2 = applicationJComp.getParameter(string);
            if (string2 != null) {
                return AJLColor.createColor(string2);
            }
        }
        catch (Exception exception) {
            applicationJComp.writeMessage(exception.getMessage() + ": " + string);
        }
        return color;
    }

    public static Color createColor(String string) throws Exception {
        Color color = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.valueOf(stringTokenizer.nextToken());
            int n2 = Integer.valueOf(stringTokenizer.nextToken());
            int n3 = Integer.valueOf(stringTokenizer.nextToken());
            if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
                throw new Exception("AJLColor: ERROR: invalid color values in: " + string);
            }
            color = new Color(n, n2, n3);
        }
        catch (Exception exception) {
            try {
                color = AJLColor.createColorFromName(string);
            }
            catch (Exception exception2) {
                throw new Exception("AJLColor: ERROR: parsing color: " + string + ": " + exception + ": " + exception2);
            }
        }
        return color;
    }

    public static Color createColorFromName(String string) throws Exception {
        if (string.equalsIgnoreCase("WHITE")) {
            return Color.WHITE;
        }
        if (string.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (string.equalsIgnoreCase("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (string.equalsIgnoreCase("BLACK")) {
            return Color.BLACK;
        }
        if (string.equalsIgnoreCase("BLUE")) {
            return Color.BLUE;
        }
        if (string.equalsIgnoreCase("CYAN")) {
            return Color.CYAN;
        }
        if (string.equalsIgnoreCase("GREEN")) {
            return Color.GREEN;
        }
        if (string.equalsIgnoreCase("MAGENTA")) {
            return Color.MAGENTA;
        }
        if (string.equalsIgnoreCase("ORANGE")) {
            return Color.ORANGE;
        }
        if (string.equalsIgnoreCase("PINK")) {
            return Color.PINK;
        }
        if (string.equalsIgnoreCase("RED")) {
            return Color.RED;
        }
        if (string.equalsIgnoreCase("YELLOW")) {
            return Color.YELLOW;
        }
        throw new Exception("Unrecognized color name: " + string);
    }

    public static void createLinearColorScale(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, Color color, Color color2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color2.getRed() - n3;
        int n7 = color2.getGreen() - n4;
        int n8 = color2.getBlue() - n5;
        int n9 = n2 - n;
        for (int i = n; i < n2 + 1; ++i) {
            int n10 = i - n;
            if (i < 0) continue;
            if (i < nArray.length) {
                nArray[i] = n3 + n6 * n10 / n9;
            }
            if (i < nArray2.length) {
                nArray2[i] = n4 + n7 * n10 / n9;
            }
            if (i >= nArray3.length) continue;
            nArray3[i] = n5 + n8 * n10 / n9;
        }
    }

    public static void createLinearColorScale(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, Color color, Color color2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color2.getRed() - n3;
        int n7 = color2.getGreen() - n4;
        int n8 = color2.getBlue() - n5;
        int n9 = n2 - n;
        for (int i = n; i < n2 + 1; ++i) {
            int n10 = i - n;
            if (i < 0) continue;
            if (i < byArray.length) {
                byArray[i] = (byte)(n3 + n6 * n10 / n9);
            }
            if (i < byArray2.length) {
                byArray2[i] = (byte)(n4 + n7 * n10 / n9);
            }
            if (i >= byArray3.length) continue;
            byArray3[i] = (byte)(n5 + n8 * n10 / n9);
        }
    }
}

