/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.codec.Steim1;
import edu.iris.Fissures.codec.Steim2;
import edu.iris.Fissures.codec.SteimFrameBlock;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedInputException;

public class Waveform
extends SeedObject {
    private byte[] waveData = null;
    private int numSamples = 0;
    private String encoding = "none";
    private boolean swapBytes = false;

    public Waveform(byte[] byArray, int n, int n2, String string, boolean bl) {
        this.waveData = new byte[byArray.length - n];
        System.arraycopy(byArray, n, this.waveData, 0, this.waveData.length);
        this.numSamples = n2;
        this.swapBytes = bl;
        this.encoding = string;
    }

    public Waveform(int[] nArray, int n, String string, int n2) throws Exception {
        this.encodeWaveform(nArray, n, string, n2);
    }

    public Waveform(int[] nArray, int n, String string) throws Exception {
        this.encodeWaveform(nArray, n, string);
    }

    public Waveform(float[] fArray, int n, String string, float f) throws Exception {
        this.encodeWaveform(fArray, n, string, f);
    }

    public Waveform(float[] fArray, int n, String string) throws Exception {
        this.encodeWaveform(fArray, n, string);
    }

    public int getType() {
        return 20000;
    }

    public int getLookupId() {
        return 0;
    }

    public int[] getDecodedIntegers(int n) throws Exception {
        if (this.waveData.length == 0 || this.numSamples < 1) {
            throw new SeedException("attempting read on empty data stream");
        }
        if (this.encoding.equals("Steim1")) {
            return Steim1.decode(this.waveData, this.numSamples, this.swapBytes, n);
        }
        if (this.encoding.equals("Steim2")) {
            return Steim2.decode(this.waveData, this.numSamples, this.swapBytes, n);
        }
        throw new SeedException("format " + this.encoding + " unavailable for integer decoding");
    }

    public int[] getDecodedIntegers() throws Exception {
        return this.getDecodedIntegers(0);
    }

    public float[] getDecodedFloats(float f) throws Exception {
        int[] nArray = null;
        if (this.encoding.equals("Steim1")) {
            nArray = Steim1.decode(this.waveData, this.numSamples, this.swapBytes, (int)f);
        } else if (this.encoding.equals("Steim2")) {
            nArray = Steim2.decode(this.waveData, this.numSamples, this.swapBytes, (int)f);
        } else {
            throw new SeedException("format " + this.encoding + " unavailable for float decoding");
        }
        if (nArray != null) {
            float[] fArray = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fArray[i] = nArray[i];
            }
            return fArray;
        }
        return null;
    }

    public float[] getDecodedFloats() throws Exception {
        return this.getDecodedFloats(0.0f);
    }

    public byte[] getEncodedBytes() throws Exception {
        return this.waveData;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public boolean getSwapBytes() {
        return this.swapBytes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    public void setSwapBytes(boolean bl) {
        this.swapBytes = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String toString() {
        return "Waveform data with " + this.numSamples + " samples in " + this.waveData.length + " bytes with " + this.encoding + " encoding and byte swap is " + this.swapBytes + ".";
    }

    private void encodeWaveform(int[] nArray, int n, String string, int n2) throws Exception {
        if (nArray.length == 0) {
            throw new SeedInputException("data length is zero");
        }
        if (!string.equals("Steim1")) {
            throw new SeedException("format " + string + " unavailable for integer encoding");
        }
        int n3 = 64;
        int n4 = n / n3;
        SteimFrameBlock steimFrameBlock = Steim1.encode(nArray, n4, n2);
        this.waveData = steimFrameBlock.getEncodedData();
        this.numSamples = steimFrameBlock.getNumSamples();
        this.encoding = "Steim1";
        this.swapBytes = false;
    }

    private void encodeWaveform(int[] nArray, int n, String string) throws Exception {
        this.encodeWaveform(nArray, n, string, 0);
    }

    private void encodeWaveform(float[] fArray, int n, String string, float f) throws Exception {
        if (fArray.length == 0) {
            throw new SeedInputException("data length is zero");
        }
        if (string.equals("someEncoding")) {
            return;
        }
        throw new SeedException("format " + string + " unavailable for float encoding");
    }

    private void encodeWaveform(float[] fArray, int n, String string) throws Exception {
        this.encodeWaveform(fArray, n, string, 0.0f);
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int[] nArray = new int[4096];
            int n2 = 45623;
            for (int i = 0; i < 4096; ++i) {
                nArray[i] = n2;
                if ((n2 += 9731) <= 54622465) continue;
                n2 -= 91;
            }
            Waveform waveform = new Waveform(nArray, 3968, "Steim1");
            if (waveform == null) {
                throw new SeedException("NULL myWaveform returned");
            }
            int n3 = waveform.getNumSamples();
            System.out.println("I have " + waveform.getEncoding() + " encoded " + n3 + " samples out of " + nArray.length + " samples entered.");
            int[] nArray2 = waveform.getDecodedIntegers();
            StringBuffer stringBuffer = new StringBuffer();
            for (n = n3 - 100; n < n3; ++n) {
                if (n < 0) {
                    n = 0;
                }
                stringBuffer.append(nArray2[n]);
                stringBuffer.append(",");
            }
            System.out.println("Decoding those values gives me this: " + stringBuffer.toString());
            stringBuffer = new StringBuffer();
            for (n = n3 - 100; n < n3; ++n) {
                if (n < 0) {
                    n = 0;
                }
                stringBuffer.append(nArray[n]);
                stringBuffer.append(",");
            }
            System.out.println("The original values consisted of   : " + stringBuffer.toString());
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
            exception.printStackTrace();
        }
    }
}

