/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedFormatException;
import edu.iris.Fissures.seed.util.Utility;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class BlocketteFactory {
    private static final int[] blocketteTypes = new int[]{5, 8, 10, 11, 12, 30, 31, 32, 33, 34, 35, 41, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 999, 100, 200, 201, 300, 310, 320, 390, 395, 400, 405, 500, 1000, 1001};
    private static final int numberOfBlocketteTypes = blocketteTypes.length;
    private static boolean optimized = false;
    private static char[][] arrayFieldType = new char[numberOfBlocketteTypes][];
    private static String[][] arrayFieldLength = new String[numberOfBlocketteTypes][];
    private static String[][] arrayFieldMask = new String[numberOfBlocketteTypes][];
    private static int[][] arrayFieldRepeat = new int[numberOfBlocketteTypes][];
    private static final byte[] tildeArray = new byte[]{126};

    public static Blockette createBlockette(byte[] byArray, boolean bl, boolean bl2, float f) throws SeedException {
        return new Blockette(byArray, bl, bl2, f);
    }

    public static Blockette createBlockette(byte[] byArray, boolean bl, boolean bl2) throws SeedException {
        return new Blockette(byArray, bl, bl2);
    }

    public static Blockette createBlockette(String string, String string2, String string3, float f) throws SeedException {
        return new Blockette(string, string2, string3, f);
    }

    public static Blockette createBlockette(String string, String string2, String string3) throws SeedException {
        return new Blockette(string, string2, string3);
    }

    public static Blockette createBlockette(String string) throws SeedException {
        return new Blockette(string);
    }

    public static Blockette createBlockette(String string, float f) throws SeedException {
        return new Blockette(string, f);
    }

    public static Blockette createBlockette(int n) throws SeedException {
        int n2 = BlocketteFactory.getNumFields(n, Blockette.getDefaultVersion());
        String string = "|";
        String string2 = "^";
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
        for (int i = 1; i < n2; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        return new Blockette(stringBuffer.toString(), string, string2);
    }

    public static String getName(int n) throws SeedException {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(BlocketteFactory.getBlocketteDefinition(n), "\t\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get name description for blockette " + n);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static String getCategory(int n) throws SeedException {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(BlocketteFactory.getBlocketteDefinition(n), "\t\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get category description for blockette " + n);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static float getVersion(int n) throws SeedException {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(BlocketteFactory.getBlocketteDefinition(n), "\t\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get version description for blockette " + n);
        }
        string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=");
        String string2 = "";
        if (!stringTokenizer2.hasMoreTokens()) {
            throw new SeedFormatException("unable to parse NumFields description for blockette " + n);
        }
        string2 = stringTokenizer2.nextToken();
        return Float.parseFloat(string2);
    }

    public static int getNumFields(int n, float f) throws SeedException {
        int n2 = 0;
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(BlocketteFactory.getBlocketteDefinition(n), "\t\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get NumFields description for blockette " + n);
        }
        string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=,");
        float f2 = 0.0f;
        while (stringTokenizer2.hasMoreTokens()) {
            f2 = Float.parseFloat(stringTokenizer2.nextToken());
            int n3 = 0;
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new SeedFormatException("unable to get number of fields for version " + f2 + " of blockette " + n);
            }
            n3 = Integer.parseInt(stringTokenizer2.nextToken());
            if (f < f2) break;
            n2 = n3;
        }
        if (n2 == 0) {
            throw new SeedException("unable to get number of fields for blockette " + n + ", version " + f2);
        }
        return n2;
    }

    public static String getFieldName(int n, int n2) throws SeedException {
        String string = "";
        String string2 = BlocketteFactory.getField(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get field name for blockette " + n + ", field " + n2);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static String getFieldType(int n, int n2) throws SeedException {
        if (optimized) {
            for (int i = 0; i < numberOfBlocketteTypes; ++i) {
                if (blocketteTypes[i] != n) continue;
                return String.valueOf(arrayFieldType[i][n2 - 1]);
            }
        }
        String string = "";
        String string2 = BlocketteFactory.getField(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get field type for blockette " + n + ", field " + n2);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static String getFieldLength(int n, int n2) throws SeedException {
        if (optimized) {
            for (int i = 0; i < numberOfBlocketteTypes; ++i) {
                if (blocketteTypes[i] != n) continue;
                return String.valueOf(arrayFieldLength[i][n2 - 1]);
            }
        }
        String string = "";
        String string2 = BlocketteFactory.getField(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get field length for blockette " + n + ", field " + n2);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static String getFieldMask(int n, int n2) throws SeedException {
        if (optimized) {
            for (int i = 0; i < numberOfBlocketteTypes; ++i) {
                if (blocketteTypes[i] != n) continue;
                return String.valueOf(arrayFieldMask[i][n2 - 1]);
            }
        }
        String string = "";
        String string2 = BlocketteFactory.getField(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get field mask for blockette " + n + ", field " + n2);
        }
        string = stringTokenizer.nextToken();
        return string;
    }

    public static int getFieldRepeat(int n, int n2) throws SeedException {
        if (optimized) {
            for (int i = 0; i < numberOfBlocketteTypes; ++i) {
                if (blocketteTypes[i] != n) continue;
                return arrayFieldRepeat[i][n2 - 1];
            }
        }
        String string = "";
        String string2 = BlocketteFactory.getField(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SeedFormatException("unable to get field repeat for blockette " + n + ", field " + n2);
        }
        string = stringTokenizer.nextToken();
        return Integer.parseInt(string);
    }

    public static String formatDecimal(int n, int n2, Object object) throws SeedException {
        String string = BlocketteFactory.getFieldMask(n, n2);
        if (string.charAt(0) == '\"') {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            String string3 = stringTokenizer.nextToken();
            DecimalFormat decimalFormat = new DecimalFormat(string3);
            String string4 = BlocketteFactory.getFieldLength(n, n2);
            int n3 = Integer.parseInt(string4);
            if (string3.length() < n3) {
                decimalFormat.setPositivePrefix("+");
            }
            if ((string2 = decimalFormat.format(object)).length() > n3) {
                return string2.substring(1);
            }
            return string2;
        }
        return object.toString();
    }

    public static String formatDecimal(int n, int n2, String string) throws SeedException {
        String string2 = BlocketteFactory.getFieldMask(n, n2);
        if (string2.charAt(0) == '\"') {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\"");
            String string3 = stringTokenizer.nextToken();
            DecimalFormat decimalFormat = new DecimalFormat(string3);
            String string4 = BlocketteFactory.getFieldLength(n, n2);
            int n3 = Integer.parseInt(string4);
            if (string3.length() < n3) {
                decimalFormat.setPositivePrefix("+");
            }
            String string5 = "";
            string5 = string3.indexOf(46) > 0 ? decimalFormat.format(Double.parseDouble(string)) : decimalFormat.format(Long.parseLong(string));
            if (string5.length() > n3) {
                return string5.substring(1);
            }
            return string5;
        }
        return string;
    }

    public static byte[] getBytes(int n, int n2, String string) throws SeedException {
        String string2 = BlocketteFactory.getFieldType(n, n2);
        String string3 = BlocketteFactory.getFieldLength(n, n2);
        if (string2.equals("L")) {
            Object object;
            if (string.length() == 0) {
                return new byte[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[], ");
            String string4 = BlocketteFactory.getFieldMask(n, n2);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "/");
            String string5 = "\"" + stringTokenizer2.nextToken() + "\"";
            DecimalFormat decimalFormat = new DecimalFormat(string5);
            int n3 = Integer.parseInt(string3);
            Vector<Object> vector = new Vector<Object>(8, 8);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                object = decimalFormat.format(Long.parseLong(string6));
                vector.add(object);
            }
            int n4 = vector.size();
            object = new byte[n4 * n3];
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(((String)vector.get(i)).getBytes(), 0, object, i * n3, n3);
            }
            return object;
        }
        if (string2.equals("D") || string2.equals("F")) {
            if (string.length() == 0) {
                return new byte[0];
            }
            int n5 = Integer.parseInt(string3);
            String string7 = BlocketteFactory.formatDecimal(n, n2, string);
            byte[] byArray = string7.getBytes();
            int n6 = byArray.length;
            byte[] byArray2 = new byte[n5];
            if (n5 < n6) {
                n6 = n5;
            }
            System.arraycopy(byArray, 0, byArray2, 0, n6);
            for (int i = n6; i < n5; ++i) {
                byArray2[i] = 32;
            }
            return byArray2;
        }
        if (string2.equals("A")) {
            if (string.length() == 0) {
                return new byte[0];
            }
            byte[] byArray = string.getBytes();
            int n7 = byArray.length;
            int n8 = Integer.parseInt(string3);
            byte[] byArray3 = new byte[n8];
            if (n8 < n7) {
                n7 = n8;
            }
            System.arraycopy(byArray, 0, byArray3, 0, n7);
            for (int i = n7; i < n8; ++i) {
                byArray3[i] = 32;
            }
            return byArray3;
        }
        if (string2.equals("V")) {
            if (string.length() == 0) {
                return tildeArray;
            }
            byte[] byArray = string.getBytes();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
            stringTokenizer.nextToken();
            int n9 = Integer.parseInt(stringTokenizer.nextToken());
            int n10 = byArray.length;
            if (n10 > n9) {
                n10 = n9;
            }
            byte[] byArray4 = new byte[n10 + 1];
            System.arraycopy(byArray, 0, byArray4, 0, n10);
            byArray4[n10] = 126;
            return byArray4;
        }
        if (string2.equals("B")) {
            if (string.length() == 0) {
                return new byte[0];
            }
            String string8 = BlocketteFactory.getFieldMask(n, n2);
            int n11 = Integer.parseInt(string3);
            if (string8.equals("BTIME")) {
                Btime btime = new Btime(string);
                return btime.getByteTime();
            }
            if (string8.equals("UBYTE") || string8.equals("BYTE")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                byte[] byArray = new byte[n11];
                byte[] byArray5 = new byte[2];
                for (int i = 0; stringTokenizer.hasMoreTokens() && i < n11; ++i) {
                    int n12 = Integer.parseInt(stringTokenizer.nextToken());
                    byArray5 = Utility.intToShortBytes(n12);
                    byArray[i] = byArray5[1];
                }
                return byArray;
            }
            if (string8.equals("FLOAT")) {
                float f = Float.parseFloat(string);
                int n13 = Float.floatToIntBits(f);
                return Utility.longToIntBytes(n13);
            }
            if (string8.equals("UWORD") || string8.equals("WORD")) {
                int n14 = Integer.parseInt(string);
                return Utility.intToShortBytes(n14);
            }
            if (string8.equals("ULONG") || string8.equals("LONG")) {
                long l = Long.parseLong(string);
                return Utility.longToIntBytes(l);
            }
            throw new SeedFormatException("unrecognized binary field type: " + string8);
        }
        throw new SeedFormatException("unrecognized field type: " + string2);
    }

    public static String getBlocketteDefinition(int n) throws SeedException {
        switch (n) {
            case 5: {
                return "005\tField Volume Identifier Blockette\tVolume Index\t2.0=5\n1\tBlockette type - 005\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tBeginning of volume\t\tV\t1-22\tTIME\t\t\t0\n";
            }
            case 8: {
                return "008\tTelemetry Volume Identifier Blockette\tVolume Index\t2.1=11\n1\tBlockette type - 008\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n6\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n7\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n8\tBeginning of volume\t\tV\t1-22\tTIME\t\t\t0\n9\tEnd of volume\t\t\tV\t1-22\tTIME\t\t\t0\n10\tStation info effective date\tV\t1-22\tTIME\t\t\t0\n11\tChannel info effective date\tV\t1-22\tTIME\t\t\t0\n12\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 10: {
                return "010\tVolume Identifier Blockette\t\tVolume Index\t2.0=6,2.3=9\n1\tBlockette type - 010\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tBeginning time\t\t\tV\t1-22\tTIME\t\t\t0\n6\tEnd time\t\t\tV\t1-22\tTIME\t\t\t0\n7\tVolume Time\t\t\tV\t1-22\tTIME\t\t\t0\n8\tOriginating Organization\tV\t1-80\t[]\t\t\t0\n9\tLabel\t\t\t\tV\t1-80\t[]\t\t\t0\n";
            }
            case 11: {
                return "011\tVolume Station Header Index Blockette\tVolume Index\t2.0=5\n1\tBlockette type - 011\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of stations\t\tD\t3\t\"000\"\t\t\t0\n4\tStation identifier code\t\tA\t5\t[]\t\t\t3\n5\tSequence no. of station header\tD\t6\t\"000000\"\t\t3\n";
            }
            case 12: {
                return "012\tVolume Time Span Index Blockette\tVolume Index\t2.0=6\n1\tBlockette type - 012\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of spans in table\tD\t4\t\"0000\"\t\t0\n4\tBeginning of span\t\tV\t1-22\tTIME\t\t\t3\n5\tEnd of span\t\t\tV\t1-22\tTIME\t\t\t3\n6\tSequence no. of time span hdr.\tD\t6\t\"000000\"\t\t3\n";
            }
            case 30: {
                return "030\tData Format Dictionary Blockette\tAbbreviation Dictionary\t\t2.0=7\n1\tBlockette type - 030\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tShort descriptive name\t\tV\t1-50\t[UNLPS]\t\t\t0\n4\tData format identifier code\tD\t4\t\"0000\"\t\t0\n5\tData family type\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of decoder keys\t\tD\t2\t\"00\"\t\t\t0\n7\tDecoder keys\t\t\tV\t1-9999\t[UNLPS]\t\t\t6\n";
            }
            case 31: {
                return "031\tComment Description Blockette\t\tAbbreviation Dictionary\t\t2.0=6\n1\tBlockette type - 031\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tComment code key\t\tD\t4\t\"0000\"\t\t0\n4\tComment class code\t\tA\t1\t[U]\t\t\t0\n5\tDescription of comment\t\tV\t1-70\t[UNLPS]\t\t\t0\n6\tUnits of comment level\t\tD\t3\t\"000\"\t\t\t0\n";
            }
            case 32: {
                return "032\tCited Source Dictionary Blockette\tAbbreviation Dictionary\t\t2.0=6\n1\tBlockette type - 032\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tSource lookup code\t\tD\t2\t\"00\"\t\t\t0\n4\tName of publication/author\tV\t1-70\t[UNLPS]\t\t\t0\n5\tDate published/catalog\t\tV\t1-70\t[UNLPS]\t\t\t0\n6\tPublisher name\t\t\tV\t1-50\t[UNLPS]\t\t\t0\n";
            }
            case 33: {
                return "033\tGeneric Abbreviation Blockette\t\tAbbreviation Dictionary\t\t2.0=4\n1\tBlockette type - 033\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tAbbreviation lookup code\tD\t3\t\"000\"\t\t\t0\n4\tAbbreviation description\tV\t1-50\t[UNLPS]\t\t\t0\n";
            }
            case 34: {
                return "034\tUnits Abbreviations Blockette\t\tAbbreviation Dictionary\t\t2.0=5\n1\tBlockette type - 034\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tUnit lookup code\t\tD\t3\t\"000\"\t\t\t0\n4\tUnit name\t\t\tV\t1-20\t[UNP]\t\t\t0\n5\tUnit description\t\tV\t0-50\t[UNLPS]\t\t\t0\n";
            }
            case 35: {
                return "035\tBeam Configuration Blockette\t\tAbbreviation Dictionary\t\t2.0=9\n1\tBlockette type - 035\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tUnit lookup code\t\tD\t3\t\"000\"\t\t\t0\n4\tNumber of components\t\tD\t4\t\"0000\"\t\t0\n5\tStation identifier\t\tA\t5\t[UN]\t\t\t4\n6\tLocation identifier\t\tA\t2\t[UNS]\t\t\t4\n7\tChannel identifier\t\tA\t3\t[UN]\t\t\t4\n8\tSub-channel identifier\t\tD\t4\t\"0000\"\t\t4\n9\tComponent weight\t\tD\t5\t\"0.000\"\t\t4\n";
            }
            case 41: {
                return "041\tFIR Dictionary Blockette\t\tAbbreviation Dictionary\t\t2.2=9\n1\tBlockette type - 041\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse Lookup Key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse Name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSymmetry Code\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal In Units\t\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal Out Units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of Factors\t\tD\t4\t\"0000\"\t\t0\n9\tFIR Coefficient\t\t\tF\t14\t\"0.0000000E00\"\t8\n";
            }
            case 43: {
                return "043\tResponse (Poles & Zeros) Dictionary Blockette\tAbbreviation Dictionary\t2.1=19\n1\tBlockette type - 043\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n6\tStage signal input units\tD\t3\t\"000\"\t\t\t0\n7\tStage signal output units\tD\t3\t\"000\"\t\t\t0\n8\tAO normalization factor\t\tF\t12\t\"0.00000E00\"\t\t0\n9\tNormalization frequency (Hz)\tF\t12\t\"0.00000E00\"\t\t0\n10\tNumber of complex zeros\t\tD\t3\t\"000\"\t\t\t0\n11\tReal zero\t\t\tF\t12\t\"0.00000E00\"\t\t10\n12\tImaginary zero\t\t\tF\t12\t\"0.00000E00\"\t\t10\n13\tReal zero error\t\t\tF\t12\t\"0.00000E00\"\t\t10\n14\tImaginary zero error\t\tF\t12\t\"0.00000E00\"\t\t10\n15\tNumber of complex poles\t\tD\t3\t\"000\"\t\t\t0\n16\tReal pole\t\t\tF\t12\t\"0.00000E00\"\t\t15\n17\tImaginary pole\t\t\tF\t12\t\"0.00000E00\"\t\t15\n18\tReal pole error\t\t\tF\t12\t\"0.00000E00\"\t\t15\n19\tImaginary pole error\t\tF\t12\t\"0.00000E00\"\t\t15\n";
            }
            case 44: {
                return "044\tResponse (Coefficients) Dictionary Blockette\tAbbreviation Dictionary\t2.1=13\n1\tBlockette type - 044\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UN_]\t\t\t0\n5\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of numerators\t\tD\t4\t\"0000\"\t\t0\n9\tNumerator coefficient\t\tF\t12\t\"0.00000E00\"\t\t8\n10\tNumerator error\t\t\tF\t12\t\"0.00000E00\"\t\t8\n11\tNumber of denominators\t\tD\t4\t\"0000\"\t\t0\n12\tDenominator coefficient\t\tF\t12\t\"0.00000E00\"\t\t11\n13\tDenominator error\t\tF\t12\t\"0.00000E00\"\t\t11\n";
            }
            case 45: {
                return "045\tResponse List Dictionary Blockette\tAbbreviation Dictionary\t\t2.1=12\n1\tBlockette type - 045\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of responses listed\tD\t4\t\"0000\"\t\t0\n8\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tAmplitude\t\t\tF\t12\t\"0.00000E00\"\t\t7\n10\tAmplitude error\t\t\tF\t12\t\"0.00000E00\"\t\t7\n11\tPhase angle (degrees)\t\tF\t12\t\"0.00000E00\"\t\t7\n12\tPhase error (degrees)\t\tF\t12\t\"0.00000E00\"\t\t7\n";
            }
            case 46: {
                return "046\tGeneric Response Dictionary Blockette\tAbbreviation Dictionary\t\t2.1=9\n1\tBlockette type - 046\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of corners listed\tD\t4\t\"0000\"\t\t0\n8\tCorner frequency (Hz)\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tCorner slope (db/decade)\tF\t12\t\"0.00000E00\"\t\t7\n";
            }
            case 47: {
                return "047\tDecimation Dictionary Blockette\t\tAbbreviation Dictionary\t\t2.1=9\n1\tBlockette type - 047\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tInput sample rate\t\tF\t10\t\"0.0000E00\"\t\t0\n6\tDecimation factor\t\tD\t5\t\"00000\"\t\t0\n7\tDecimation offset\t\tD\t5\t\"00000\"ERROR: reading SEED volume\t\t0\n8\tEstimated delay (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n9\tCorrection applied (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n";
            }
            case 48: {
                return "048\tChannel Sensitivity/Gain Dictionary Blockette\tAbbreviation Dictionary\t2.1=10\n1\tBlockette type - 048\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSensitivity/gain\t\tF\t12\t\"0.00000E00\"\t\t0\n6\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t0\n7\tNumber of history values\tD\t2\t\"00\"\t\t\t0\n8\tSensitivity for calibration\tF\t12\t\"0.00000E00\"\t\t7\n9\tFreq. of calib. sensitivity\tF\t12\t\"0.00000E00\"\t\t7\n10\tTime of above calibration\tV\t1-22\tTIME\t\t\t7\n";
            }
            case 50: {
                return "050\tStation Identifier Blockette\t\tStation\t\t2.0=15,2.3=16\n1\tBlockette type - 050\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation call letters\t\tA\t5\t[UN]\t\t\t0\n4\tLatitude (degrees)\t\tD\t10\t\"00.000000\"\t\t0\n5\tLongitude (degrees)\t\tD\t11\t\"000.000000\"\t\t0\n6\tElevation (m)\t\t\tD\t7\t\"0000.0\"\t\t0\n7\tNumber of channels\t\tD\t4\t\"0000\"\t\t0\n8\tNumber of station comments\tD\t3\t\"000\"\t\t\t0\n9\tSite name\t\t\tV\t1-60\t[UNLPS]\t\t\t0\n10\tNetwork identifier code\t\tD\t3\t\"000\"\t\t\t0\n11\t32 bit word order\t\tD\t4\t\"0000\"\t\t0\n12\t16 bit word order\t\tD\t2\t\"00\"\t\t\t0\n13\tStart effective date\t\tV\t1-22\tTIME\t\t\t0\n14\tEnd effective date\t\tV\t0-22\tTIME\t\t\t0\n15\tUpdate flag\t\t\tA\t1\t[]\t\t\t0\n16\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 51: {
                return "051\tStation Comment Blockette\t\tStation\t\t2.0=6\n1\tBlockette type - 051\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tBeginning effective time\tV\t1-22\tTIME\t\t\t0\n4\tEnd effective time\t\tV\t1-22\tTIME\t\t\t0\n5\tComment code key\t\tD\t4\t\"0000\"\t\t0\n6\tComment level\t\t\tD\t6\t\"000000\"\t\t0\n";
            }
            case 52: {
                return "052\tChannel Identifier Blockette\t\tStation\t\t2.0=24\n1\tBlockette type - 052\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n4\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n5\tSubchannel identifier\t\tD\t4\t\"0000\"\t\t0\n6\tInstrument identifier\t\tD\t3\t\"000\"\t\t\t0\n7\tOptional comment\t\tV\t0-30\t[UNLPS]\t\t\t0\n8\tUnits of signal response\tD\t3\t\"000\"\t\t\t0\n9\tUnits of calibration input\tD\t3\t\"000\"\t\t\t0\n10\tLatitude (degrees)\t\tD\t10\t\"00.000000\"\t\t0\n11\tLongitude (degrees)\t\tD\t11\t\"000.000000\"\t\t0\n12\tElevation (m)\t\t\tD\t7\t\"0000.0\"\t\t0\n13\tLocal depth (m)\t\t\tD\t5\t\"000.0\"\t\t0\n14\tAzimuth (degrees)\t\tD\t5\t\"000.0\"\t\t0\n15\tDip (degrees)\t\t\tD\t5\t\"00.0\"\t\t0\n16\tData format identifier code\tD\t4\t\"0000\"\t\t0\n17\tData record length\t\tD\t2\t\"00\"\t\t\t0\n18\tSample rate (Hz)\t\tF\t10\t\"0.0000E00\"\t\t0\n19\tMax clock drift (seconds)\tF\t10\t\"0.0000E00\"\t\t0\n20\tNumber of comments\t\tD\t4\t\"0000\"\t\t0\n21\tChannel flags\t\t\tV\t0-26\t[U]\t\t\t0\n22\tStart date\t\t\tV\t1-22\tTIME\t\t\t0\n23\tEnd date\t\t\tV\t0-22\tTIME\t\t\t0\n24\tUpdate flag\t\t\tA\t1\t[]\t\t\t0\n";
            }
            case 53: {
                return "053\tResponse (Poles & Zeros) Blockette\tStation\t\t2.0=18\n1\tBlockette type - 053\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tTransfer function type\t\tA\t1\t[U]\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n5\tStage signal input units\tD\t3\t\"000\"\t\t\t0\n6\tStage signal output units\tD\t3\t\"000\"\t\t\t0\n7\tAO normalization factor\t\tF\t12\t\"0.00000E00\"\t\t0\n8\tNormalization freq. f(n) (Hz)\tF\t12\t\"0.00000E00\"\t\t0\n9\tNumber of complex zeros\t\tD\t3\t\"000\"\t\t\t0\n10\tReal zero\t\t\tF\t12\t\"0.00000E00\"\t\t9\n11\tImaginary zero\t\t\tF\t12\t\"0.00000E00\"\t\t9\n12\tReal zero error\t\t\tF\t12\t\"0.00000E00\"\t\t9\n13\tImaginary zero error\t\tF\t12\t\"0.00000E00\"\t\t9\n14\tNumber of complex poles\t\tD\t3\t\"000\"\t\t\t0\n15\tReal pole\t\t\tF\t12\t\"0.00000E00\"\t\t14\n16\tImaginary pole\t\t\tF\t12\t\"0.00000E00\"\t\t14\n17\tReal pole error\t\t\tF\t12\t\"0.00000E00\"\t\t14\n18\tImaginary pole error\t\tF\t12\t\"0.00000E00\"\t\t14\n";
            }
            case 54: {
                return "054\tResponse (Coefficients) Blockette\tStation\t\t2.0=12\n1\tBlockette type - 054\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of numerators\t\tD\t4\t\"0000\"\t\t0\n8\tNumerator coefficient\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tNumerator error\t\t\tF\t12\t\"0.00000E00\"\t\t7\n10\tNumber of denominators\t\tD\t4\t\"0000\"\t\t0\n11\tDenominator coefficient\t\tF\t12\t\"0.00000E00\"\t\t10\n12\tDenominator error\t\tF\t12\t\"0.00000E00\"\t\t10\n";
            }
            case 55: {
                return "055\tResponse List Blockette\t\t\tStation\t\t2.0=11\n1\tBlockette type - 055\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n5\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of responses listed\tD\t4\t\"0000\"\t\t0\n7\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t6\n8\tAmplitude\t\t\tF\t12\t\"0.00000E00\"\t\t6\n9\tAmplitude error\t\t\tF\t12\t\"0.00000E00\"\t\t6\n10\tPhase angle (degrees)\t\tF\t12\t\"0.00000E00\"\t\t6\n11\tPhase error (degrees)\t\tF\t12\t\"0.00000E00\"\t\t6\n";
            }
            case 56: {
                return "056\tGeneric Response Blockette\t\tStation\t\t2.0=8\n1\tBlockette type - 056\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n5\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of corners listed\tD\t4\t\"0000\"\t\t0\n7\tCorner frequency (Hz)\t\tF\t12\t\"0.00000E00\"\t\t6\n8\tCorner slope (db/decade)\tF\t12\t\"0.00000E00\"\t\t6\n";
            }
            case 57: {
                return "057\tDecimation Blockette\t\t\tStation\t\t2.1=8\n1\tBlockette type - 057\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tInput sample rate (Hz)\t\tF\t10\t\"0.0000E00\"\t\t0\n5\tDecimation factor\t\tD\t5\t\"00000\"\t\t0\n6\tDecimation offset\t\tD\t5\t\"00000\"\t\t0\n7\tEstimated delay (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n8\tCorrection applied (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n";
            }
            case 58: {
                return "058\tChannel Sensitivity/Gain Blockette\tStation\t\t2.0=9\n1\tBlockette type - 058\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSensitivity/gain S(d)\t\tF\t12\t\"0.00000E00\"\t\t0\n5\tFrequency (Hz) f(s)\t\tF\t12\t\"0.00000E00\"\t\t0\n6\tNumber of history values\tD\t2\t\"00\"\t\t\t0\n7\tSensitivity for calibration\tF\t12\t\"0.00000E00\"\t\t6\n8\tFrequency of calibration (Hz)\tF\t12\t\"0.00000E00\"\t\t6\n9\tTime of above calibration\tV\t1-22\tTIME\t\t\t6\n";
            }
            case 59: {
                return "059\tChannel Comment Blockette\t\tStation\t\t2.0=6\n1\tBlockette type - 059\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tBeginning effective time\tV\t1-22\tTIME\t\t\t0\n4\tEnd effective time\t\tV\t0-22\tTIME\t\t\t0\n5\tComment code key\t\tD\t4\t\"0000\"\t\t0\n6\tComment level\t\t\tD\t6\t\"000000\"\t\t0\n";
            }
            case 60: {
                return "060\tResponse Reference Blockette\t\tStation\t\t2.1=6\n1\tBlockette type - 060\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of stages\t\tD\t2\t\"00\"\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t3\n5\tNumber of responses\t\tD\t2\t\"00\"\t\t\t3\n6\tResponse lookup key\t\tL\t4\t/0000/\t\t\t5\n";
            }
            case 61: {
                return "061\tFIR Response Blockette\t\t\tStation\t\t2.2=9\n1\tBlockette type - 061\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tResponse Name\t\t\tV\t1-25\t[ULN_]\t\t\t0\n5\tSymmetry Code\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal In Units\t\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal Out Units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of Coefficients\t\tD\t4\t\"0000\"\t\t0\n9\tFIR Coefficient\t\t\tF\t14\t\"0.0000000E00\"\t8\n";
            }
            case 70: {
                return "070\tTime Span Identifier Blockette\t\tTime Span\t2.0=5\n1\tBlockette type - 070\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tTime span flag\t\t\tA\t1\t[U]\t\t\t0\n4\tBeginning time of data span\tV\t1-22\tTIME\t\t\t0\n5\tEnd time of data span\t\tV\t1-22\tTIME\t\t\t0\n";
            }
            case 71: {
                return "071\tHypocenter Information Blockette\tTime Span\t2.0=11,2.3=14\n1\tBlockette type - 071\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tOrigin time of event\t\tV\t1-22\tTIME\t\t\t0\n4\tHypocenter source identifier\tD\t2\t\"00\"\t\t\t0\n5\tLatitude of event (degrees)\tD\t10\t\"00.000000\"\t\t0\n6\tLongitude of event (degrees)\tD\t11\t\"000.000000\"\t\t0\n7\tDepth (Km)\t\t\tD\t7\t\"0000.00\"\t\t0\n8\tNumber of magnitudes\t\tD\t2\t\"00\"\t\t\t0\n9\tMagnitude\t\t\tD\t5\t\"00.00\"\t\t8\n10\tMagnitude type\t\t\tV\t1-10\t[UNLPS]\t\t\t8\n11\tMagnitude source\t\tD\t2\t\"00\"\t\t\t8\n12\tSeismic region\t\t\tD\t3\t\"000\"\t\t\t0\n13\tSeismic Location\t\tD\t4\t\"0000\"\t\t0\n14\tRegion Name\t\t\tV\t1-40\t[UNLPS]\t\t\t0\n";
            }
            case 72: {
                return "072\tEvent Phases Blockette\t\t\tTime Span\t2.0=10,2.3=12\n1\tBlockette type - 072\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n4\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n5\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n6\tArrival time of phase\t\tV\t1-22\tTIME\t\t\t0\n7\tAmplitude of signal\t\tF\t10\t\"0.0000E00\"\t\t0\n8\tPeriod of signal (seconds)\tF\t10\t\"0.0000E00\"\t\t0\n9\tSignal-to-noise ratio\t\tF\t10\t\"0.0000E00\"\t\t0\n10\tName of phase\t\t\tV\t1-20\t[UNLP]\t\t\t0\n11\tSource\t\t\t\tD\t2\t\"00\"\t\t\t0\n12\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 73: {
                return "073\tTime Span Data Start Index Blockette\tTime Span\t2.0=9\n1\tBlockette type - 073\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of data pieces\t\tD\t4\t\"0000\"\t\t0\n4\tStation identifier\t\tA\t5\t[UN]\t\t\t3\n5\tLocation identifier\t\tA\t2\t[UNS]\t\t\t3\n6\tChannel identifier\t\tA\t3\t[UN]\t\t\t3\n7\tTime of record\t\t\tV\t1-22\tTIME\t\t\t3\n8\tSequence number of first record\tD\t6\t\"000000\"\t\t3\n9\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t3\n";
            }
            case 74: {
                return "074\tTime Series Index Blockette\t\tTime Span\t2.1=15,2.3=16\n1\tBlockette type - 074\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n4\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n5\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n6\tSeries start time\t\tV\t1-22\tTIME\t\t\t0\n7\tSequence number of first data\tD\t6\t\"000000\"\t\t0\n8\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t0\n9\tSeries end time\t\t\tV\t1-22\tTIME\t\t\t0\n10\tSequence number of last record\tD\t6\t\"000000\"\t\t0\n11\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t0\n12\tNumber of accelerator repeats\tD\t3\t\"000\"\t\t\t0\n13\tRecord start time\t\tV\t1-22\tTIME\t\t\t12\n14\tSequence number of record\tD\t6\t\"000000\"\t\t12\n15\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t12\n16\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 999: {
                return "999\tFixed Section of Data Header\tData Record\t2.0=18\n1\tBlockette type - 999\t\tD\t2\tUWORD\t\t\t0\n2\tData Quality Flags\t\tA\t8\t[UNS]\t\t\t0\n3\tData Arrival Time Stamp\t\tB\t10\tBTIME\t\t\t0\n4\tStation identifier code\t\tA\t5\t[]\t\t\t0\n5\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n6\tChannel identifier\t\tA\t3\t[]\t\t\t0\n7\tNetwork Code\t\t\tA\t2\t[]\t\t\t0\n8\tRecord start time\t\tB\t10\tBTIME\t\t\t0\n9\tNumber of samples\t\tB\t2\tUWORD\t\t\t0\n10\tSample rate factor\t\tB\t2\tWORD\t\t\t0\n11\tSample rate multiplier\t\tB\t2\tWORD\t\t\t0\n12\tActivity flags\t\t\tB\t1\tUBYTE\t\t\t0\n13\tI/O and clock flags\t\tB\t1\tUBYTE\t\t\t0\n14\tData quality flags\t\tB\t1\tUBYTE\t\t\t0\n15\tNo. of blockettes that follow\tB\t1\tUBYTE\t\t\t0\n16\tTime correction\t\t\tB\t4\tLONG\t\t\t0\n17\tBeginning of data\t\tB\t2\tUWORD\t\t\t0\n18\tFirst blockette\t\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 100: {
                return "100\tSample Rate Blockette\t\t\tData Record\t2.3=5\n1\tBlockette type - 100\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tActual Sample Rate\t\tB\t4\tFLOAT\t\t\t0\n4\tFlags (to be defined)\t\tB\t1\tBYTE\t\t\t0\n5\tReserved byte\t\t\tB\t3\tUBYTE\t\t\t0\n";
            }
            case 200: {
                return "200\tGeneric Event Detection Blockette\tData Record\t2.0=9\n1\tBlockette type - 200\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tSignal amplitude\t\tB\t4\tFLOAT\t\t\t0\n4\tSignal period\t\t\tB\t4\tFLOAT\t\t\t0\n5\tBackground estimate\t\tB\t4\tFLOAT\t\t\t0\n6\tEvent detection flags\t\tB\t1\tUBYTE\t\t\t0\n7\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n8\tSignal onset time\t\tB\t10\tBTIME\t\t\t0\n9\tDetector Name\t\t\tA\t24\t[]\t\t\t0\n";
            }
            case 201: {
                return "201\tMurdock Event Detection Blockette\tData Record\t2.0=12\n1\tBlockette type - 201\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tSignal amplitude\t\tB\t4\tFLOAT\t\t\t0\n4\tSignal period\t\t\tB\t4\tFLOAT\t\t\t0\n5\tBackground estimate\t\tB\t4\tFLOAT\t\t\t0\n6\tEvent detection flags\t\tB\t1\tUBYTE\t\t\t0\n7\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n8\tSignal onset time\t\tB\t10\tBTIME\t\t\t0\n9\tSignal-to-noise ratio values\tB\t6\tUBYTE\t\t\t0\n10\tLookback value\t\t\tB\t1\tUBYTE\t\t\t0\n11\tPick algorithm\t\t\tB\t1\tUBYTE\t\t\t0\n12\tDetector name\t\t\tA\t24\t[]\t\t\t0\n";
            }
            case 300: {
                return "300\tStep Calibration Blockette\t\tData Record\t2.0=13\n1\tBlockette type - 300\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tNumber of step calibrations\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tStep duration\t\t\tB\t4\tULONG\t\t\t0\n7\tInterval duration\t\tB\t4\tULONG\t\t\t0\n8\tCalibration signal amplitude\tB\t4\tFLOAT\t\t\t0\n9\tChannel with calibration input\tA\t3\t[]\t\t\t0\n10\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n11\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n12\tCoupling\t\t\tA\t12\t[]\t\t\t0\n13\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n";
            }
            case 310: {
                return "310\tSine Calibration Blockette\t\tData Record\t2.0=13\n1\tBlockette type - 310\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tPeriod of signal (seconds)\tB\t4\tFLOAT\t\t\t0\n8\tAmplitude of signal\t\tB\t4\tFLOAT\t\t\t0\n9\tChannel with calibration input\tA\t3\t[]\t\t\t0\n10\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n11\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n12\tCoupling\t\t\tA\t12\t[]\t\t\t0\n13\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n";
            }
            case 320: {
                return "320\tPseudo-random Calibration Blockette\tData Record\t2.0=13\n1\tBlockette type - 320\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tPeak-to-peak amplitude of steps\tB\t4\tFLOAT\t\t\t0\n8\tChannel with calibration output\tA\t3\t[]\t\t\t0\n9\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n10\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n11\tCoupling\t\t\tA\t12\t[]\t\t\t0\n12\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n13\tNoise type\t\t\tA\t8\t[]\t\t\t0\n";
            }
            case 390: {
                return "390\tGeneric Calibration Blockette\t\tData Record\t2.0=9\n1\tBlockette type - 390\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tCalibration signal amplitude\tB\t4\tFLOAT\t\t\t0\n8\tChannel with calibration input\tA\t3\t[]\t\t\t0\n9\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
            case 395: {
                return "395\tCalibration Abort Blockette\t\tData Record\t2.0=4\n1\tBlockette type - 395\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tEnd of calibration time\t\tB\t10\tBTIME\t\t\t0\n4\tReserved bytes\t\t\tB\t2\tUBYTE\t\t\t0\n";
            }
            case 400: {
                return "400\tBeam Blockette\t\t\t\tData Record\t2.0=6\n1\tBlockette type - 400\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeam azimuth (degrees)\t\tB\t4\tFLOAT\t\t\t0\n4\tBeam slowness (sec/degree)\tB\t4\tFLOAT\t\t\t0\n5\tBeam configuration\t\tB\t2\tUWORD\t\t\t0\n6\tReserved bytes\t\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 405: {
                return "405\tBeam Delay Blockette\t\t\tData Record\t2.0=3\n1\tBlockette type - 405\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tArray of delay values\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 500: {
                return "500\tTiming Blockette\t\t\tData Record\t2.0=10\n1\tBlockette type - 500\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tVCO correction\t\t\tB\t4\tFLOAT\t\t\t0\n4\tTime of exception\t\tB\t10\tBTIME\t\t\t0\n5\tMicroseconds\t\t\tB\t1\tUBYTE\t\t\t0\n6\tReception Quality\t\tB\t1\tUBYTE\t\t\t0\n7\tException count\t\t\tB\t4\tULONG\t\t\t0\n8\tException type\t\t\tA\t16\t[]\t\t\t0\n9\tClock model\t\t\tA\t32\t[]\t\t\t0\n10\tClock status\t\t\tA\t128\t[]\t\t\t0\n";
            }
            case 1000: {
                return "1000\tData Only SEED Blockette\t\tData Record\t2.3=6\n1\tBlockette type - 1000\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tEncoding format\t\t\tB\t1\tBYTE\t\t\t0\n4\tWord order\t\t\tB\t1\tUBYTE\t\t\t0\n5\tData Record Length\t\tB\t1\tUBYTE\t\t\t0\n6\tReserved\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
            case 1001: {
                return "1001\tData Extension Blockette\t\tData Record\t2.0=6\n1\tBlockette type - 1001\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tTiming quality\t\t\tB\t1\tUBYTE\t\t\t0\n4\tMicroseconds\t\t\tB\t1\tUBYTE\t\t\t0\n5\tReserved\t\t\tB\t1\tUBYTE\t\t\t0\n6\tFrame Count\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
        }
        throw new SeedException("Blockette type " + n + " not defined");
    }

    public static String getTranslation(int n, int n2, Object object) {
        switch (n) {
            case 30: {
                if (n2 != 5) break;
                int n3 = Integer.parseInt(object.toString());
                if (n3 == 0) {
                    return "Integer format fixed interval data";
                }
                if (n3 == 1) {
                    return "Gain ranged fixed interval data";
                }
                if (n3 == 50) {
                    return "Integer differences compression";
                }
                if (n3 == 80) {
                    return "ASCII text with line control (for console logs)";
                }
                if (n3 != 81) break;
                return "Non-ASCII text (for other language character sets)";
            }
            case 41: {
                String string;
                if (n2 == 5) {
                    string = object.toString();
                    if (string.equals("A")) {
                        return "No Symmetry - all Coefficients are specified";
                    }
                    if (string.equals("B")) {
                        return "Odd number Coefficients with symmetry";
                    }
                    if (string.equals("C")) {
                        return "Even number Coefficients with symmetry";
                    }
                }
                if (n2 != 8) break;
                string = object.toString();
                if (string.equals("A")) {
                    return "No Symmetry - All Coefficients specified";
                }
                if (string.equals("B")) {
                    return "Odd - First half of all coefficients and center coefficient specified";
                }
                if (!string.equals("C")) break;
                return "Even - First half of all coefficients specified";
            }
            case 43: {
                if (n2 != 5) break;
                String string = object.toString();
                if (string.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (string.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (string.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!string.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 44: {
                if (n2 != 5) break;
                String string = object.toString();
                if (string.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (string.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (string.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!string.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 50: {
                int n4;
                if (n2 == 11) {
                    n4 = Integer.parseInt(object.toString());
                    if (n4 == 123) {
                        return "VAX, 8086 series";
                    }
                    if (n4 == 3210) {
                        return "68000 series";
                    }
                }
                if (n2 == 12) {
                    n4 = Integer.parseInt(object.toString());
                    if (n4 == 1) {
                        return "VAX, 8086 series";
                    }
                    if (n4 == 10) {
                        return "68000 series";
                    }
                }
                if (n2 != 15) break;
                String string = object.toString();
                if (string.equals("N") || string.equals("n")) {
                    return "Effective dates pertain to these data";
                }
                if (!string.equals("U") && !string.equals("u")) break;
                return "Control header updates information previously sent";
            }
            case 52: {
                if (n2 != 21) break;
                String string = object.toString();
                StringBuffer stringBuffer = new StringBuffer();
                if (string.indexOf("T") >= 0) {
                    stringBuffer.append("Channel is triggered\n");
                }
                if (string.indexOf("C") >= 0) {
                    stringBuffer.append("Channel is recorded continuously\n");
                }
                if (string.indexOf("H") >= 0) {
                    stringBuffer.append("State of health data\n");
                }
                if (string.indexOf("G") >= 0) {
                    stringBuffer.append("Geophysical data\n");
                }
                if (string.indexOf("W") >= 0) {
                    stringBuffer.append("Weather or environmental data\n");
                }
                if (string.indexOf("F") >= 0) {
                    stringBuffer.append("Flag information (nominal, not ordinal)\n");
                }
                if (string.indexOf("S") >= 0) {
                    stringBuffer.append("Synthesized data\n");
                }
                if (string.indexOf("I") >= 0) {
                    stringBuffer.append("Channel is a calibration input\n");
                }
                if (string.indexOf("E") >= 0) {
                    stringBuffer.append("Channel is experimental or temporary\n");
                }
                if (string.indexOf("M") >= 0) {
                    stringBuffer.append("Maintenance tests are underway on channel; possible abnormal data\n");
                }
                if (string.indexOf("B") >= 0) {
                    stringBuffer.append("Data are a beam synthesis\n");
                }
                return stringBuffer.toString();
            }
            case 53: {
                if (n2 != 3) break;
                String string = object.toString();
                if (string.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (string.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (string.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!string.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 61: {
                String string;
                if (n2 == 5) {
                    string = object.toString();
                    if (string.equals("A")) {
                        return "No Symmetry - all Coefficients are specified";
                    }
                    if (string.equals("B")) {
                        return "Odd number Coefficients with symmetry";
                    }
                    if (string.equals("C")) {
                        return "Even number Coefficients with symmetry";
                    }
                }
                if (n2 != 8) break;
                string = object.toString();
                if (string.equals("A")) {
                    return "No Symmetry - All Coefficients specified";
                }
                if (string.equals("B")) {
                    return "Odd - First half of all coefficients and center coefficient specified";
                }
                if (!string.equals("C")) break;
                return "Even - First half of all coefficients specified";
            }
            case 70: {
                if (n2 != 3) break;
                String string = object.toString();
                if (string.equals("E")) {
                    return "Data are event oriented";
                }
                if (!string.equals("P")) break;
                return "Data are for a given period";
            }
            case 999: {
                if (n2 == 2) {
                    String string = object.toString();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (string.indexOf("D") >= 0) {
                        stringBuffer.append("Default data (might be QC'd, might not be)\n");
                    }
                    if (string.indexOf("R") >= 0) {
                        stringBuffer.append("Real-time data (un-QC'd)\n");
                    }
                    if (string.indexOf("Q") >= 0) {
                        stringBuffer.append("Quality controlled data (QC'd)\n");
                    }
                    if (string.indexOf("P") >= 0) {
                        stringBuffer.append("Primary data source\n");
                    }
                    if (string.indexOf("S") >= 0) {
                        stringBuffer.append("Secondary data source\n");
                    }
                    return stringBuffer.toString();
                }
                if (n2 == 12) {
                    int n5 = Integer.parseInt(object.toString());
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n5 > 127) {
                        stringBuffer.append("Bit 7 set (undefined)\n");
                        n5 -= 128;
                    }
                    if (n5 > 63) {
                        stringBuffer.append("Event in progress\n");
                        n5 -= 64;
                    }
                    if (n5 > 31) {
                        stringBuffer.append("A negative leap second happened during this record (A 59 second minute)\n");
                        n5 -= 32;
                    }
                    if (n5 > 15) {
                        stringBuffer.append("A positive leap second happened during this record (A 61 second minute)\n");
                        n5 -= 16;
                    }
                    if (n5 > 7) {
                        stringBuffer.append("End of the event, station detriggers\n");
                        n5 -= 8;
                    }
                    if (n5 > 3) {
                        stringBuffer.append("Beginning of an event, station trigger\n");
                        n5 -= 4;
                    }
                    if (n5 > 1) {
                        stringBuffer.append("Time correction in field 16 applied to field 8\n");
                        n5 -= 2;
                    }
                    if (n5 > 0) {
                        stringBuffer.append("Calibration signals present\n");
                    }
                    return stringBuffer.toString();
                }
                if (n2 == 13) {
                    int n6 = Integer.parseInt(object.toString());
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n6 > 127) {
                        stringBuffer.append("Bit 7 set (undefined)\n");
                        n6 -= 128;
                    }
                    if (n6 > 63) {
                        stringBuffer.append("Bit 6 set (undefined)\n");
                        n6 -= 64;
                    }
                    if (n6 > 31) {
                        stringBuffer.append("Clock locked\n");
                        n6 -= 32;
                    }
                    if (n6 > 15) {
                        stringBuffer.append("End of time series\n");
                        n6 -= 16;
                    }
                    if (n6 > 7) {
                        stringBuffer.append("Start of time series\n");
                        n6 -= 8;
                    }
                    if (n6 > 3) {
                        stringBuffer.append("Short record read (record padded)\n");
                        n6 -= 4;
                    }
                    if (n6 > 1) {
                        stringBuffer.append("Long record read (possibly no problem)\n");
                        n6 -= 2;
                    }
                    if (n6 > 0) {
                        stringBuffer.append("Station volume parity error possibly present\n");
                    }
                    return stringBuffer.toString();
                }
                if (n2 != 14) break;
                int n7 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n7 > 127) {
                    stringBuffer.append("Time tag is questionable\n");
                    n7 -= 128;
                }
                if (n7 > 63) {
                    stringBuffer.append("A digital filter may be charging\n");
                    n7 -= 64;
                }
                if (n7 > 31) {
                    stringBuffer.append("Telemetry synchronization error\n");
                    n7 -= 32;
                }
                if (n7 > 15) {
                    stringBuffer.append("Missing/padded data present\n");
                    n7 -= 16;
                }
                if (n7 > 7) {
                    stringBuffer.append("Glitches detected\n");
                    n7 -= 8;
                }
                if (n7 > 3) {
                    stringBuffer.append("Spikes detected\n");
                    n7 -= 4;
                }
                if (n7 > 1) {
                    stringBuffer.append("Digitizer clipping detected\n");
                    n7 -= 2;
                }
                if (n7 > 0) {
                    stringBuffer.append("Amplifier saturation detected (station dependent)\n");
                }
                return stringBuffer.toString();
            }
            case 200: {
                if (n2 != 6) break;
                int n8 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n8 > 127) {
                    stringBuffer.append("Bit 7 set (undefined)\n");
                    n8 -= 128;
                }
                if (n8 > 63) {
                    stringBuffer.append("Bit 6 set (undefined)\n");
                    n8 -= 64;
                }
                if (n8 > 31) {
                    stringBuffer.append("Bit 5 set (undefined)\n");
                    n8 -= 32;
                }
                if (n8 > 15) {
                    stringBuffer.append("Bit 4 set (undefined)\n");
                    n8 -= 16;
                }
                if (n8 > 7) {
                    stringBuffer.append("Bit 3 set (undefined)\n");
                    n8 -= 8;
                }
                if (n8 > 3) {
                    stringBuffer.append("bit 0 is undetermined\n");
                    n8 -= 4;
                }
                if (n8 > 1) {
                    stringBuffer.append("units above are after deconvolution\n");
                    n8 -= 2;
                } else {
                    stringBuffer.append("digital counts\n");
                }
                if (n8 > 0) {
                    stringBuffer.append("dilatation wave\n");
                } else {
                    stringBuffer.append("compression\n");
                }
                return stringBuffer.toString();
            }
            case 201: {
                if (n2 != 6) break;
                int n9 = Integer.parseInt(object.toString());
                if (n9 > 0) {
                    return "dilatation wave";
                }
                return "compression";
            }
            case 300: {
                if (n2 != 5) break;
                int n10 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n10 > 127) {
                    stringBuffer.append("Bit 7 set (undefined)\n");
                    n10 -= 128;
                }
                if (n10 > 63) {
                    stringBuffer.append("Bit 6 set (undefined)\n");
                    n10 -= 64;
                }
                if (n10 > 31) {
                    stringBuffer.append("Bit 5 set (undefined)\n");
                    n10 -= 32;
                }
                if (n10 > 15) {
                    stringBuffer.append("Bit 4 set (undefined)\n");
                    n10 -= 16;
                }
                if (n10 > 7) {
                    stringBuffer.append("calibration continued from previous record(s)\n");
                    n10 -= 8;
                }
                if (n10 > 3) {
                    stringBuffer.append("calibration was automatic\n");
                    n10 -= 4;
                } else {
                    stringBuffer.append("calibration was manual\n");
                }
                if (n10 > 1) {
                    stringBuffer.append("calibration's alternate sign\n");
                    n10 -= 2;
                }
                if (n10 > 0) {
                    stringBuffer.append("first pulse is positive\n");
                }
                return stringBuffer.toString();
            }
            case 310: {
                if (n2 != 5) break;
                int n11 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n11 > 127) {
                    stringBuffer.append("Bit 7 set (undefined)\n");
                    n11 -= 128;
                }
                if (n11 > 63) {
                    stringBuffer.append("RMS amplitude\n");
                    n11 -= 64;
                }
                if (n11 > 31) {
                    stringBuffer.append("zero-to-peak amplitude\n");
                    n11 -= 32;
                }
                if (n11 > 15) {
                    stringBuffer.append("peak-to-peak amplitude\n");
                    n11 -= 16;
                }
                if (n11 > 7) {
                    stringBuffer.append("calibration continued from previous record(s)\n");
                    n11 -= 8;
                }
                if (n11 > 3) {
                    stringBuffer.append("calibration was automatic\n");
                    n11 -= 4;
                } else {
                    stringBuffer.append("calibration was manual\n");
                }
                if (n11 > 1) {
                    stringBuffer.append("Bit 1 set (undefined)\n");
                    n11 -= 2;
                }
                if (n11 > 0) {
                    stringBuffer.append("Bit 0 set (undefined)\n");
                }
                return stringBuffer.toString();
            }
            case 320: {
                if (n2 != 5) break;
                int n12 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n12 > 127) {
                    stringBuffer.append("Bit 7 set (undefined)\n");
                    n12 -= 128;
                }
                if (n12 > 63) {
                    stringBuffer.append("Bit 6 set (undefined)\n");
                    n12 -= 64;
                }
                if (n12 > 31) {
                    stringBuffer.append("Bit 5 set (undefined)\n");
                    n12 -= 32;
                }
                if (n12 > 15) {
                    stringBuffer.append("random amplitudes\n");
                    n12 -= 16;
                }
                if (n12 > 7) {
                    stringBuffer.append("calibration continued from previous record(s)\n");
                    n12 -= 8;
                }
                if (n12 > 3) {
                    stringBuffer.append("calibration was automatic\n");
                    n12 -= 4;
                } else {
                    stringBuffer.append("calibration was manual\n");
                }
                if (n12 > 1) {
                    stringBuffer.append("Bit 1 set (undefined)\n");
                    n12 -= 2;
                }
                if (n12 > 0) {
                    stringBuffer.append("Bit 0 set (undefined)\n");
                }
                return stringBuffer.toString();
            }
            case 390: {
                if (n2 != 5) break;
                int n13 = Integer.parseInt(object.toString());
                StringBuffer stringBuffer = new StringBuffer();
                if (n13 > 127) {
                    stringBuffer.append("Bit 7 set (undefined)\n");
                    n13 -= 128;
                }
                if (n13 > 63) {
                    stringBuffer.append("Bit 6 set (undefined)\n");
                    n13 -= 64;
                }
                if (n13 > 31) {
                    stringBuffer.append("Bit 5 set (undefined)\n");
                    n13 -= 32;
                }
                if (n13 > 15) {
                    stringBuffer.append("Bit 4 set (undefined)\n");
                    n13 -= 16;
                }
                if (n13 > 7) {
                    stringBuffer.append("calibration continued from previous record(s)\n");
                    n13 -= 8;
                }
                if (n13 > 3) {
                    stringBuffer.append("calibration was automatic\n");
                    n13 -= 4;
                } else {
                    stringBuffer.append("calibration was manual\n");
                }
                if (n13 > 1) {
                    stringBuffer.append("Bit 1 set (undefined)\n");
                    n13 -= 2;
                }
                if (n13 > 0) {
                    stringBuffer.append("Bit 0 set (undefined)\n");
                }
                return stringBuffer.toString();
            }
            case 1000: {
                if (n2 == 3) {
                    int n14 = Integer.parseInt(object.toString());
                    switch (n14) {
                        case 0: {
                            return "ASCII text, byte order as specified in field 4";
                        }
                        case 1: {
                            return "16 bit integers";
                        }
                        case 2: {
                            return "24 bit integers";
                        }
                        case 3: {
                            return "32 bit integers";
                        }
                        case 4: {
                            return "IEEE floating point";
                        }
                        case 5: {
                            return "IEEE double precision floating point";
                        }
                        case 10: {
                            return "STEIM (1) Compression";
                        }
                        case 11: {
                            return "STEIM (2) Compression";
                        }
                        case 12: {
                            return "GEOSCOPE Multiplexed Format 24 bit integer";
                        }
                        case 13: {
                            return "GEOSCOPE Multiplexed Format 16 bit gain ranged, 3 bit exponent";
                        }
                        case 14: {
                            return "GEOSCOPE Multiplexed Format 16 bit gain ranged, 4 bit exponent";
                        }
                        case 15: {
                            return "US National Network compression";
                        }
                        case 16: {
                            return "CDSN 16 bit gain ranged";
                        }
                        case 17: {
                            return "Graefenberg 16 bit gain ranged";
                        }
                        case 18: {
                            return "IPG - Strasbourg 16 bit gain ranged";
                        }
                        case 19: {
                            return "STEIM (3) Compression";
                        }
                        case 30: {
                            return "SRO Format";
                        }
                        case 31: {
                            return "HGLP Format";
                        }
                        case 32: {
                            return "DWWSSN Gain Ranged Format";
                        }
                        case 33: {
                            return "RSTN 16 bit gain ranged";
                        }
                    }
                    return "Undefined encoding format";
                }
                if (n2 != 4) break;
                int n15 = Integer.parseInt(object.toString());
                if (n15 > 0) {
                    return "68000/SPARC word order";
                }
                return "VAX/8086 word order";
            }
            default: {
                return "Value Undefined";
            }
        }
        return "Value Undefined";
    }

    private static String getField(int n, int n2) throws SeedException {
        StringTokenizer stringTokenizer = new StringTokenizer(BlocketteFactory.getBlocketteDefinition(n), "\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t");
            if (stringTokenizer2.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer2.nextToken());
            }
            if (n3 != n2) continue;
            return string;
        }
        throw new SeedException("field number " + n2 + "not defined for blockette " + n);
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2 = 10;
            String string = "010009502.3121992,001,00:00:00.0000~1992,002,00:00:00.0000~1993,029~IRIS_DMC~Data for 1992,001~";
            byte[] byArray = string.getBytes();
            Blockette blockette = BlocketteFactory.createBlockette(byArray, false, false);
            System.out.println("I am blockette type " + blockette.getType());
            System.out.println("In field 4, the logical record length exponent is " + blockette.getFieldVal(4).toString());
            System.out.println("In field 6, the end time is " + blockette.getFieldVal(6).toString());
            System.out.println("In field 9, the label is " + blockette.getFieldVal(9).toString());
            n2 = 50;
            string = "0500098ANMO +34.946200-106.456700+1740.00006001Albuquerque, New Mexico, USA~0013210101989,241~~NIU";
            byArray = string.getBytes();
            blockette = BlocketteFactory.createBlockette(byArray, false, false);
            System.out.println("I am blockette type " + blockette.getType());
            System.out.println("The station name is " + blockette.getFieldVal(3).toString());
            System.out.println("The longitude is " + blockette.getFieldVal(5).toString());
            System.out.println("The elevation is " + blockette.getFieldVal(6).toString());
            System.out.println("The start effective date is " + blockette.getFieldVal(13).toString());
            System.out.println("The update flag is " + blockette.getFieldVal(15).toString());
            System.out.println("Which translates to " + blockette.translate(15));
            n2 = 52;
            string = "0520119  BHE0000004~001002+34.946200-106.456700+1740.0100.0090.0+00.0000112 2.000E+01 2.000E-030000CG~1991,042,20:48~~N";
            byArray = string.getBytes();
            Blockette blockette2 = BlocketteFactory.createBlockette(byArray, false, false);
            int n3 = blockette.addChildBlockette(blockette2);
            System.out.println("Added a child blockette.  myBlockette contains " + blockette.numberofChildBlockettes() + " blockettes.");
            Blockette blockette3 = blockette.getChildBlockette(n3);
            System.out.println("I am blockette type " + blockette3.getType());
            System.out.println("My definition is as follows:\n" + blockette3.getDefinition());
            System.out.println("The channel name is " + blockette3.getFieldVal(4).toString());
            System.out.println("using the shorter toString() call, the value is " + blockette3.toString(4));
            System.out.println("The " + blockette3.getFieldName(8) + " is " + blockette3.getFieldVal(8).toString());
            System.out.println("using the shorter toString() call, the value is " + blockette3.toString(8));
            System.out.println("The " + blockette3.getFieldName(18) + " is " + blockette3.getFieldVal(18).toString());
            System.out.println("using the shorter toString() call, the value is " + blockette3.toString(18));
            System.out.println("The " + blockette3.getFieldName(19) + " is " + blockette3.getFieldVal(19).toString());
            System.out.println("using the shorter toString() call, the value is " + blockette3.toString(19));
            System.out.println("The " + blockette3.getFieldName(21) + " is " + blockette3.toString(21));
            System.out.println("which translated means: " + blockette3.translate(21));
            n2 = 53;
            string = "0530382B 1007008 7.87395E+00 5.00000E-02  3 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00-1.27000E+01 0.00000E+00 0.00000E+00 0.00000E+00  4-1.96418E-03 1.96418E-03 0.00000E+00 0.00000E+00-1.96418E-03-1.96418E-03 0.00000E+00 0.00000E+00-6.23500E+00 7.81823E+00 0.00000E+00 0.00000E+00-6.23500E+00-7.81823E+00 0.00000E+00 0.00000E+00";
            byArray = string.getBytes();
            blockette2 = BlocketteFactory.createBlockette(byArray, false, false);
            n3 = blockette.addChildBlockette(blockette2);
            System.out.println("Added a child blockette.  myBlockette contains " + blockette.numberofChildBlockettes() + " blockettes.");
            blockette3 = blockette.getChildBlockette(n3);
            System.out.println("I am blockette type " + blockette3.getType());
            System.out.println("The " + blockette3.getFieldName(14) + " is " + blockette3.getFieldVal(14).toString());
            System.out.println("The " + blockette3.getFieldName(15) + " at index 2 is " + blockette3.getFieldVal(15, 2).toString());
            System.out.println("which I can also print with the toString() method as " + blockette3.toString(15, 2));
            System.out.println("The " + blockette3.getFieldName(16) + " at index 0 is " + blockette3.getFieldVal(16, 0).toString());
            System.out.println("which I can also print with the toString() method as " + blockette3.toString(16, 0));
            System.out.println("Now I want to add an additional coefficient set to the complex zeros...");
            Vector<Float> vector = new Vector<Float>(4);
            vector.add(new Float(0.01732));
            vector.add(new Float(-0.01732));
            vector.add(new Float(0.0f));
            vector.add(new Float(0.0f));
            blockette3.addFieldGrp(10, vector);
            System.out.println("...and then I want to read back all of the values");
            System.out.println("there are " + blockette3.toString(9) + " field groups here");
            int n4 = Integer.parseInt(blockette3.toString(9));
            for (int i = 0; i < n4; ++i) {
                Vector vector2 = blockette3.getFieldGrp(10, i);
                System.out.print("" + i + ": ");
                for (n = 0; n < vector2.size(); ++n) {
                    System.out.print("" + BlocketteFactory.formatDecimal(n2, 10 + n, vector2.get(n).toString()) + ",");
                }
                System.out.println("");
            }
            string = "999|D|1900|ANMO|  |BHZ|IU|1998,001|3849|20|1|68|12|144|0|2829|256|0";
            Blockette blockette4 = BlocketteFactory.createBlockette(string);
            System.out.println("\n\nI am blockette type " + blockette4.getType());
            System.out.println("which means I am called a " + blockette4.getName());
            for (int i = 2; i < 19; ++i) {
                System.out.println("The " + blockette4.getFieldName(i) + " is " + blockette4.toString(i));
                System.out.println("which translates to: " + blockette4.translate(i));
            }
            string = "06000650402030098007600430301003404040033004400550066050200030002";
            byArray = string.getBytes();
            Blockette blockette5 = BlocketteFactory.createBlockette(byArray, false, false);
            System.out.println("\n\nI am blockette type " + blockette5.getType());
            System.out.println("which means I am called a " + blockette5.getName());
            for (n = 2; n <= blockette5.getNumFields(); ++n) {
                System.out.println("The " + blockette5.getFieldName(n) + " is " + blockette5.toString(n));
                System.out.println("which translates to: " + blockette5.translate(n));
                if (n != 3) continue;
                int n5 = Integer.parseInt(blockette5.toString(n));
                for (int i = 0; i < n5; ++i) {
                    Vector vector3 = blockette5.getFieldGrp(4, i);
                    System.out.print("Stage " + i + ": ");
                    for (int j = 0; j < vector3.size(); ++j) {
                        System.out.print("" + BlocketteFactory.formatDecimal(60, 4 + j, vector3.get(j).toString()) + ",");
                    }
                    System.out.println("");
                }
                break;
            }
        }
        catch (SeedException seedException) {
            System.out.println("Caught exception: " + seedException);
        }
    }

    static {
        try {
            for (int i = 0; i < numberOfBlocketteTypes; ++i) {
                int n = blocketteTypes[i];
                int n2 = BlocketteFactory.getNumFields(n, 99.9f);
                BlocketteFactory.arrayFieldType[i] = new char[n2];
                BlocketteFactory.arrayFieldLength[i] = new String[n2];
                BlocketteFactory.arrayFieldMask[i] = new String[n2];
                BlocketteFactory.arrayFieldRepeat[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    BlocketteFactory.arrayFieldType[i][j] = BlocketteFactory.getFieldType(n, j + 1).charAt(0);
                    BlocketteFactory.arrayFieldLength[i][j] = BlocketteFactory.getFieldLength(n, j + 1);
                    BlocketteFactory.arrayFieldMask[i][j] = BlocketteFactory.getFieldMask(n, j + 1);
                    BlocketteFactory.arrayFieldRepeat[i][j] = BlocketteFactory.getFieldRepeat(n, j + 1);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
        optimized = true;
    }
}

