# CMRMAP generated from cmrmapPlot.py

#   Returns a colour map CMAP (varying black -
#   purple - red - yellow - white) that is monochrome-
#   compatible, i.e. it produces a monotonic greyscale
#   colour map.
#
#   The map is a slight modification to that suggested in
#   [1].
#
#   Reference:
#
#   [1] Rappaport, C. 2002: "A Color Map for Effective
#   Black-and-White Rendering of Color Scale Images", IEEE
#   Antenna's and Propagation Magazine, Vol.44, No.3,
#   pp.94-96 (June).
#
# http://stackoverflow.com/questions/7251872/is-there-a-better-color-scale-than-the-rainbow-colormap
# http://matplotlib.org/users/colormaps.html
# http://www.mathworks.com/matlabcentral/fileexchange/39552-modified-cmrmap

import json
import numpy

JSON_CMAP = """
[
    [
        0.0021804798510769176,
        0.0021804798510769133,
        0.002180479851076917
    ],
    [
        0.003087188286726274,
        0.006955171701011791,
        0.008284688607875967
    ],
    [
        0.0041566868983689,
        0.011592087289586628,
        0.014863182110308133
    ],
    [
        0.005386845223313601,
        0.01609411795902518,
        0.021899027862313996
    ],
    [
        0.006775532798869182,
        0.020464155051551216,
        0.029375293367834145
    ],
    [
        0.008320619162344446,
        0.024705089909388512,
        0.037275046130809175
    ],
    [
        0.010019973851048204,
        0.028819813874760812,
        0.04558135365517964
    ],
    [
        0.011871466402289256,
        0.0328112182898919,
        0.05427728344488616
    ],
    [
        0.013872966353376407,
        0.03668219449700553,
        0.06334590300386929
    ],
    [
        0.016022343241618466,
        0.04043563383832546,
        0.07277027983606965
    ],
    [
        0.018317466604324234,
        0.04407442765607548,
        0.08253348144542781
    ],
    [
        0.02075620597880251,
        0.04760146729247931,
        0.09261857533588436
    ],
    [
        0.023336430902362117,
        0.051019644089760764,
        0.10300862901137985
    ],
    [
        0.02605601091231185,
        0.05433184939014358,
        0.11368670997585491
    ],
    [
        0.028912815545960507,
        0.05754097453585152,
        0.1246358857332501
    ],
    [
        0.031904714340616896,
        0.060649910869108356,
        0.135839223787506
    ],
    [
        0.03502957683358984,
        0.06366154973213785,
        0.14727979164256325
    ],
    [
        0.038285272562188125,
        0.06657878246716381,
        0.15894065680236238
    ],
    [
        0.041669671063720555,
        0.06940450041640991,
        0.17080488677084402
    ],
    [
        0.04518064187549595,
        0.07214159492209996,
        0.18285554905194865
    ],
    [
        0.0488160545348231,
        0.07479295732645774,
        0.19507571114961697
    ],
    [
        0.05257377857901082,
        0.07736147897170703,
        0.20744844056778952
    ],
    [
        0.0564516835453679,
        0.07985005120007153,
        0.21995680481040686
    ],
    [
        0.060447638971203164,
        0.08226156535377506,
        0.23258387138140965
    ],
    [
        0.06455951439382543,
        0.08459891277504138,
        0.24531270778473846
    ],
    [
        0.06878517935054344,
        0.0868649848060942,
        0.2581263815243338
    ],
    [
        0.07312250337866606,
        0.08906267278915736,
        0.27100796010413625
    ],
    [
        0.07756935601550208,
        0.09119486806645458,
        0.2839405110280866
    ],
    [
        0.0821236067983603,
        0.09326446198020961,
        0.29690710180012514
    ],
    [
        0.08678312526454954,
        0.0952743458726463,
        0.3098907999241927
    ],
    [
        0.09154578095137858,
        0.0972274110859883,
        0.32287467290422966
    ],
    [
        0.09640944339615623,
        0.09912654896245945,
        0.33584178824417676
    ],
    [
        0.1013719821361913,
        0.10097465084428348,
        0.34877521344797463
    ],
    [
        0.10643126670879259,
        0.10277460807368417,
        0.36165801601956354
    ],
    [
        0.11158516665126898,
        0.10452931199288532,
        0.3744732634628845
    ],
    [
        0.11683155150092914,
        0.1062416539441106,
        0.3872040232818778
    ],
    [
        0.12216829079508196,
        0.10791452526958387,
        0.3998333629804841
    ],
    [
        0.1275932540710362,
        0.10955081731152883,
        0.4123443500626441
    ],
    [
        0.13310431086610072,
        0.11115342141216929,
        0.42472005203229823
    ],
    [
        0.13869933071758433,
        0.11272522891372898,
        0.4369435363933871
    ],
    [
        0.14437618316279574,
        0.11426913115843168,
        0.4489978706498514
    ],
    [
        0.15013273773904384,
        0.11578801948850118,
        0.46086612230563145
    ],
    [
        0.1559668639836374,
        0.11728478524616118,
        0.47253135886466824
    ],
    [
        0.16187643143388528,
        0.1187623197736355,
        0.48397664783090216
    ],
    [
        0.1678593096270962,
        0.12022351441314788,
        0.4951850567082737
    ],
    [
        0.17391336810057903,
        0.1216712605069221,
        0.5061396530007234
    ],
    [
        0.18003647639164255,
        0.12310844939718192,
        0.5168235042121921
    ],
    [
        0.1862265040375956,
        0.12453797242615111,
        0.5272196778466204
    ],
    [
        0.19248132057574688,
        0.1259627209360534,
        0.5373112414079485
    ],
    [
        0.1987987955434053,
        0.12738558626911256,
        0.5470812624001173
    ],
    [
        0.20517679847787965,
        0.12880945976755243,
        0.5565128083270673
    ],
    [
        0.2116131989164787,
        0.1302372327735967,
        0.5655889466927392
    ],
    [
        0.21810586639651128,
        0.13167179662946915,
        0.5742927450010733
    ],
    [
        0.22465267045528617,
        0.13311604267739355,
        0.5826072707560104
    ],
    [
        0.23125148063011225,
        0.13457286225959367,
        0.5905155914614911
    ],
    [
        0.23790016645829826,
        0.13604514671829326,
        0.5980007746214562
    ],
    [
        0.24459659747715295,
        0.1375357873957161,
        0.6050458877398458
    ],
    [
        0.25133864322398525,
        0.13904767563408593,
        0.6116339983206005
    ],
    [
        0.25812417323610387,
        0.1405837027756265,
        0.6177481738676612
    ],
    [
        0.2649510570508177,
        0.1421467601625617,
        0.6233714818849685
    ],
    [
        0.2718171642054354,
        0.1437397391371151,
        0.6284869898764629
    ],
    [
        0.2787203642372658,
        0.14536553104151062,
        0.6330777653460847
    ],
    [
        0.285658526683618,
        0.14702702721797198,
        0.6371268757977749
    ],
    [
        0.29262952108180057,
        0.1487271190087229,
        0.640617388735474
    ],
    [
        0.29963125025760157,
        0.15046867635625036,
        0.6435324460134901
    ],
    [
        0.3066656449428355,
        0.1522519798348819,
        0.6458641858806342
    ],
    [
        0.3137424586620101,
        0.1540722810807847,
        0.6476222189221458
    ],
    [
        0.3208723437285814,
        0.1559242539372307,
        0.6488181631831959
    ],
    [
        0.32806595245600545,
        0.1578025722474919,
        0.6494636367089542
    ],
    [
        0.3353339371577381,
        0.15970190985484037,
        0.649570257544592
    ],
    [
        0.34268695014723555,
        0.16161694060254805,
        0.649149643735279
    ],
    [
        0.35013564373795353,
        0.16354233833388698,
        0.6482134133261855
    ],
    [
        0.3576906702433481,
        0.16547277689212922,
        0.6467731843624825
    ],
    [
        0.3653626819768753,
        0.16740293012054672,
        0.6448405748893399
    ],
    [
        0.373162331251991,
        0.1693274718624115,
        0.6424272029519283
    ],
    [
        0.3811002703821514,
        0.1712410759609957,
        0.6395446865954181
    ],
    [
        0.389187151680812,
        0.17313841625957113,
        0.6362046438649794
    ],
    [
        0.3974336274614293,
        0.17501416660140992,
        0.6324186928057832
    ],
    [
        0.405850350037459,
        0.17686300082978407,
        0.628198451462999
    ],
    [
        0.41444797172235703,
        0.17867959278796555,
        0.6235555378817982
    ],
    [
        0.4232371448295796,
        0.1804586163192264,
        0.6185015701073505
    ],
    [
        0.4322285216725825,
        0.18219474526683868,
        0.6130481661848265
    ],
    [
        0.44143275456482167,
        0.1838826534740743,
        0.6072069441593967
    ],
    [
        0.4508604958197533,
        0.18551701478420546,
        0.600989522076231
    ],
    [
        0.4605223977508332,
        0.18709250304050393,
        0.5944075179805005
    ],
    [
        0.47042911267151727,
        0.18860379208624187,
        0.5874725499173751
    ],
    [
        0.4805912928952618,
        0.1900455557646913,
        0.5801962359320253
    ],
    [
        0.4910195907355224,
        0.1914124679191241,
        0.5725901940696215
    ],
    [
        0.5017246585057551,
        0.19269920239281244,
        0.5646660423753342
    ],
    [
        0.5127171485194162,
        0.19390043302902824,
        0.5564353988943337
    ],
    [
        0.5240077130899612,
        0.19501083367104358,
        0.5479098816717904
    ],
    [
        0.5356070045308466,
        0.1960250781621304,
        0.5391011087528745
    ],
    [
        0.5475256751555279,
        0.19693784034556078,
        0.5300206981827568
    ],
    [
        0.5597743772774613,
        0.19774379406460668,
        0.5206802680066074
    ],
    [
        0.5723637632101028,
        0.19843761316254013,
        0.5110914362695966
    ],
    [
        0.5853044852669084,
        0.19901397148263314,
        0.5012658210168952
    ],
    [
        0.5986067463668598,
        0.19946775151559207,
        0.4912150798008796
    ],
    [
        0.6122603935236948,
        0.19980328670812972,
        0.4809526597040586
    ],
    [
        0.6262270284762521,
        0.20003802438459023,
        0.47049449091003
    ],
    [
        0.6404661724333995,
        0.2001903778296618,
        0.4598566865061258
    ],
    [
        0.6549373466040039,
        0.20027876032803252,
        0.44905535957967846
    ],
    [
        0.6696000721969323,
        0.2003215851643906,
        0.4381066232180197
    ],
    [
        0.6844138704210532,
        0.20033726562342435,
        0.42702659050848163
    ],
    [
        0.6993382624852325,
        0.2003442149898218,
        0.41583137453839636
    ],
    [
        0.714332769598338,
        0.2003608465482712,
        0.40453708839509583
    ],
    [
        0.7293569129692374,
        0.20040557358346078,
        0.39315984516591224
    ],
    [
        0.7443702138067976,
        0.2004968093800786,
        0.38171575793817736
    ],
    [
        0.7593321933198859,
        0.20065296722281295,
        0.37022093979922305
    ],
    [
        0.7742023727173698,
        0.20089246039635206,
        0.35869150383638204
    ],
    [
        0.7889402732081164,
        0.20123370218538397,
        0.34714356313698586
    ],
    [
        0.8035054160009932,
        0.20169510587459696,
        0.33559323078836634
    ],
    [
        0.8178573223048673,
        0.2022950847486792,
        0.32405661987785606
    ],
    [
        0.831955513328606,
        0.20305205209231886,
        0.31254984349278686
    ],
    [
        0.8457595102810765,
        0.20398442119020413,
        0.3010890147204905
    ],
    [
        0.8592288343711464,
        0.20511060532702316,
        0.2896902466482995
    ],
    [
        0.872323006807683,
        0.20644901778746422,
        0.2783696523635453
    ],
    [
        0.8850015487995532,
        0.20801807185621543,
        0.26714334495356046
    ],
    [
        0.8972239815556247,
        0.20983618081796498,
        0.25602743750567664
    ],
    [
        0.9089498262847647,
        0.21192175795740112,
        0.24503804310722604
    ],
    [
        0.9201386041958404,
        0.2142932165592119,
        0.2341912748455408
    ],
    [
        0.9307498364977189,
        0.21696896990808562,
        0.22350324580795278
    ],
    [
        0.9407430443992679,
        0.21996743128871044,
        0.2129900690817941
    ],
    [
        0.9500777491093543,
        0.22330701398577446,
        0.20266785775439675
    ],
    [
        0.9587134718368461,
        0.22700613128396605,
        0.19255272491309267
    ],
    [
        0.9666097337906099,
        0.23108319646797323,
        0.18266078364521401
    ],
    [
        0.9737260561795129,
        0.23555662282248419,
        0.17300814703809286
    ],
    [
        0.9800219602124233,
        0.2404448236321873,
        0.1636109281790611
    ],
    [
        0.9854569670982074,
        0.2457662121817705,
        0.1544852401554509
    ],
    [
        0.9899923100246812,
        0.25153834576644796,
        0.14564679732445457
    ],
    [
        0.9936285976954705,
        0.2577590939235285,
        0.13710214325005218
    ],
    [
        0.9964058143300125,
        0.2644066384324156,
        0.12884865070301157
    ],
    [
        0.9983656561266913,
        0.27145830508303864,
        0.12088329372396098
    ],
    [
        0.9995498192838925,
        0.2788914196653273,
        0.11320304635352846
    ],
    [
        1.0,
        0.286683307969211,
        0.10580488263234204
    ],
    [
        0.9997578944733992,
        0.29481129578461873,
        0.09868577660103028
    ],
    [
        0.9988651989024747,
        0.3032527089014804,
        0.09184270230022115
    ],
    [
        0.9973636094856113,
        0.311984873109725,
        0.08527263377054278
    ],
    [
        0.9952948224211938,
        0.32098511419928233,
        0.07897254505262338
    ],
    [
        0.9927005339076072,
        0.3302307579600816,
        0.07293941018709109
    ],
    [
        0.9896224401432362,
        0.33969913018205244,
        0.06717020321457408
    ],
    [
        0.9861022373264656,
        0.34936755665512426,
        0.06166189817570034
    ],
    [
        0.9821816216556805,
        0.3592133631692262,
        0.05641146911109838
    ],
    [
        0.9779022893292652,
        0.3692138755142878,
        0.05141589006139621
    ],
    [
        0.9733059365456049,
        0.37934641948023856,
        0.04667213506722196
    ],
    [
        0.9684342595030841,
        0.38958832085700784,
        0.04217717816920384
    ],
    [
        0.9633289544000878,
        0.39991690543452535,
        0.03792799340796998
    ],
    [
        0.9580317174350009,
        0.4103094990027201,
        0.03392155482414855
    ],
    [
        0.9525842448062082,
        0.42074342735152165,
        0.030154836458367723
    ],
    [
        0.9470282327120944,
        0.4311960162708595,
        0.02662481235125566
    ],
    [
        0.9414053773510441,
        0.44164459155066327,
        0.023328456543440464
    ],
    [
        0.9357573749214428,
        0.45206647898086205,
        0.02026274307555045
    ],
    [
        0.9301259216216746,
        0.4624390043513853,
        0.017424645988213697
    ],
    [
        0.9245527136501247,
        0.4727394934521624,
        0.014811139322058376
    ],
    [
        0.9190794472051779,
        0.4829452720731231,
        0.01241919711771266
    ],
    [
        0.9137478184852187,
        0.4930336660041964,
        0.010245793415804689
    ],
    [
        0.9085995236886323,
        0.5029820010353121,
        0.008287902256962654
    ],
    [
        0.9036762590138031,
        0.5127676029563998,
        0.00654249768181466
    ],
    [
        0.8990197206591166,
        0.5223677975573883,
        0.005006553730988977
    ],
    [
        0.8946716048229572,
        0.5317599106282073,
        0.0036770444451137176
    ],
    [
        0.8906736077037095,
        0.540921267958786,
        0.002550943864817048
    ],
    [
        0.8870650477512192,
        0.5498304585179659,
        0.0016255575437446235
    ],
    [
        0.8838529631011627,
        0.5584832201914898,
        0.000902691656267632
    ],
    [
        0.881021127997508,
        0.5668876498075714,
        0.00038739590012043903
    ],
    [
        0.8785528030905384,
        0.575052117041069,
        8.479157984917574e-05
    ],
    [
        0.8764312490305373,
        0.5829849915668405,
        0.0
    ],
    [
        0.8746397264677881,
        0.5906946430597446,
        0.00013814246511904946
    ],
    [
        0.8731614960525744,
        0.5981894411946391,
        0.0005043402797524613
    ],
    [
        0.87197981843518,
        0.6054777556463827,
        0.0011037147484463797
    ],
    [
        0.8710779542658882,
        0.6125679560898335,
        0.0019413871757469419
    ],
    [
        0.8704391641949819,
        0.6194684121998495,
        0.0030224788662002863
    ],
    [
        0.8700467088727454,
        0.6261874936512895,
        0.004352111124352565
    ],
    [
        0.8698838489494617,
        0.6327335701190114,
        0.0059354052547499125
    ],
    [
        0.8699338450754144,
        0.6391150112778735,
        0.007777482561938525
    ],
    [
        0.8701799579008866,
        0.6453401868027343,
        0.009883464350464452
    ],
    [
        0.8706054480761624,
        0.6514174663684515,
        0.012258471924873861
    ],
    [
        0.8711935762515247,
        0.6573552196498841,
        0.014907626589712918
    ],
    [
        0.8719276030772574,
        0.6631618163218899,
        0.017836049649527747
    ],
    [
        0.8727907892036437,
        0.6688456260593272,
        0.021048862408864503
    ],
    [
        0.8737663952809674,
        0.6744150185370544,
        0.024551186172269316
    ],
    [
        0.8748376819595115,
        0.6798783634299298,
        0.028348142244288332
    ],
    [
        0.8759879098895597,
        0.6852440304128113,
        0.032444851929467694
    ],
    [
        0.8772003397213956,
        0.6905203891605579,
        0.03684643653235367
    ],
    [
        0.8784582321053026,
        0.6957158093480271,
        0.041558017357492164
    ],
    [
        0.8797448476915639,
        0.7008386606500775,
        0.046584715709429424
    ],
    [
        0.8810434471304631,
        0.7058973127415673,
        0.05193165289271157
    ],
    [
        0.8823372910722841,
        0.710900135297355,
        0.057603950211884816
    ],
    [
        0.8836096401673096,
        0.7158554979922984,
        0.06360672897149522
    ],
    [
        0.8848437550658237,
        0.7207717705012562,
        0.06994511047608896
    ],
    [
        0.8860228964181096,
        0.7256573224990865,
        0.0766242160302124
    ],
    [
        0.8871303248744509,
        0.7305205236606477,
        0.08364916693841126
    ],
    [
        0.8881493010851308,
        0.7353697436607975,
        0.09102508450523188
    ],
    [
        0.889063085700433,
        0.7402133521743948,
        0.0987570900352204
    ],
    [
        0.8898566085501157,
        0.7450590126849818,
        0.1068493591291674
    ],
    [
        0.8905293275075115,
        0.749908242196126,
        0.11529783626258355
    ],
    [
        0.8910881808428583,
        0.7547593929280898,
        0.12409422775711196
    ],
    [
        0.8915401686478558,
        0.7596107909459019,
        0.1332302049083307
    ],
    [
        0.8918922910142033,
        0.7644607623145903,
        0.14269743901181797
    ],
    [
        0.8921515480336012,
        0.7693076330991839,
        0.15248760136315206
    ],
    [
        0.8923249397977483,
        0.7741497293647103,
        0.16259236325791054
    ],
    [
        0.8924194663983445,
        0.778985377176198,
        0.1730033959916719
    ],
    [
        0.8924421279270895,
        0.7838129025986758,
        0.183712370860014
    ],
    [
        0.8923999244756828,
        0.7886306316971714,
        0.19471095915851513
    ],
    [
        0.8922998561358246,
        0.793436890536714,
        0.20599083218275333
    ],
    [
        0.8921489229992138,
        0.7982300051823311,
        0.21754366122830673
    ],
    [
        0.8919541251575502,
        0.8030083016990515,
        0.22936111759075375
    ],
    [
        0.8917224627025341,
        0.8077701061519036,
        0.24143487256567192
    ],
    [
        0.8914609357258643,
        0.8125137446059154,
        0.25375659744863954
    ],
    [
        0.891176544319241,
        0.8172375431261155,
        0.2663179635352347
    ],
    [
        0.8908762885743634,
        0.8219398277775324,
        0.27911064212103565
    ],
    [
        0.8905671685829314,
        0.826618924625194,
        0.29212630450162036
    ],
    [
        0.8902561844366447,
        0.8312731597341289,
        0.3053566219725672
    ],
    [
        0.8899503362272028,
        0.8359008591693654,
        0.3187932658294537
    ],
    [
        0.8896566240463055,
        0.8405003489959322,
        0.3324279073678585
    ],
    [
        0.8893820479856521,
        0.845069955278857,
        0.34625221788336
    ],
    [
        0.8891336081369426,
        0.8496080040831686,
        0.3602578686715354
    ],
    [
        0.8889183045918766,
        0.8541128214738952,
        0.3744365310279631
    ],
    [
        0.8887431374421535,
        0.8585827335160652,
        0.38877987624822147
    ],
    [
        0.8886151067794731,
        0.8630160662747068,
        0.4032795756278885
    ],
    [
        0.8885412126955351,
        0.8674111458148485,
        0.4179273004625421
    ],
    [
        0.888528455282039,
        0.8717662982015187,
        0.4327147220477608
    ],
    [
        0.8885838346306844,
        0.8760798494997456,
        0.4476335116791226
    ],
    [
        0.8887143508331712,
        0.8803501257745576,
        0.4626753406522051
    ],
    [
        0.888927003981199,
        0.884575453090983,
        0.4778318802625869
    ],
    [
        0.8892287941664672,
        0.8887541575140503,
        0.49309480180584586
    ],
    [
        0.8896267214806755,
        0.8928845651087878,
        0.5084557765775602
    ],
    [
        0.8901277860155237,
        0.8969650019402237,
        0.5239064758733081
    ],
    [
        0.8907389878627112,
        0.900993794073386,
        0.5394385709886674
    ],
    [
        0.8914673271139381,
        0.9049692675733041,
        0.5550437332192164
    ],
    [
        0.8923198038609036,
        0.9088897485050056,
        0.5707136338605333
    ],
    [
        0.8933034181953075,
        0.9127535629335192,
        0.5864399442081965
    ],
    [
        0.8944251702088493,
        0.9165590369238726,
        0.602214335557783
    ],
    [
        0.8956920599932288,
        0.9203044965410948,
        0.6180284792048719
    ],
    [
        0.8971110876401455,
        0.9239882678502137,
        0.6338740464450409
    ],
    [
        0.8986892532412992,
        0.927608676916258,
        0.6497427085738681
    ],
    [
        0.9004335568883894,
        0.9311640498042558,
        0.6656261368869317
    ],
    [
        0.9023509986731161,
        0.9346527125792357,
        0.6815160026798099
    ],
    [
        0.9044485786871785,
        0.9380729913062259,
        0.6974039772480811
    ],
    [
        0.9067332970222763,
        0.9414232120502549,
        0.7132817318873226
    ],
    [
        0.9092121537701094,
        0.9447017008763506,
        0.729140937893113
    ],
    [
        0.9118921490223773,
        0.9479067838495417,
        0.74497326656103
    ],
    [
        0.9147802828707794,
        0.9510367870348567,
        0.7607703891866522
    ],
    [
        0.9178835554070156,
        0.9540900364973234,
        0.7765239770655574
    ],
    [
        0.9212089667227855,
        0.9570648583019707,
        0.792225701493324
    ],
    [
        0.924763516909789,
        0.9599595785138268,
        0.80786723376553
    ],
    [
        0.9285542060597253,
        0.96277252319792,
        0.8234402451777534
    ],
    [
        0.9325880342642942,
        0.9655020184192783,
        0.8389364070255725
    ],
    [
        0.9368720016151953,
        0.9681463902429307,
        0.854347390604565
    ],
    [
        0.9414131082041285,
        0.9707039647339052,
        0.8696648672103092
    ],
    [
        0.946218354122793,
        0.97317306795723,
        0.8848805081383833
    ],
    [
        0.9512947394628888,
        0.9755520259779337,
        0.8999859846843653
    ],
    [
        0.9566492643161155,
        0.9778391648610446,
        0.9149729681438334
    ],
    [
        0.9622889287741725,
        0.9800328106715909,
        0.9298331298123655
    ],
    [
        0.9682207329287598,
        0.9821312894746012,
        0.9445581409855404
    ],
    [
        0.9744516768715766,
        0.9841329273351035,
        0.9591396729589352
    ],
    [
        0.980988760694323,
        0.9860360503181264,
        0.9735693970281285
    ],
    [
        0.9878389844886982,
        0.9878389844886982,
        0.9878389844886982
    ]
]
"""

CMAP = numpy.array(json.loads(JSON_CMAP))
