/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "com.adobe.epubcheck.util.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.adobe.epubcheck.util.messages", Locale.getDefault(), new UTF8Control());

    private Messages() {
    }

    public static String get(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String get(String key, Object ... arguments) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8)));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

