/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dict;

import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;

public class SearchKeyMapHandler
implements XMLHandler {
    private final ValidationContext context;
    private final String path;
    private final XMLParser parser;

    public SearchKeyMapHandler(ValidationContext context, XMLParser parser) {
        this.context = context;
        this.path = context.path;
        this.parser = parser;
    }

    @Override
    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if ("http://www.idpf.org/2007/ops".equals(e.getNamespace())) {
            if ("search-key-group".equals(name)) {
                this.processRef(e.getAttribute("href"));
            } else if ("match".equals(name)) {
                this.processRef(e.getAttribute("href"));
            }
        }
    }

    private void processRef(String ref) {
        if (ref != null && this.context.xrefChecker.isPresent()) {
            ref = PathUtil.resolveRelativeReference(this.path, ref, null);
            this.context.xrefChecker.get().registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ref, XRefChecker.Type.SEARCH_KEY);
        }
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

