/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.google.common.base.CharMatcher;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.idpf.epubcheck.util.css.CssContentHandler;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssGrammar;
import org.idpf.epubcheck.util.css.CssLocation;

public class CSSHandler
implements CssContentHandler,
CssErrorHandler {
    final String path;
    final XRefChecker xrefChecker;
    final Report report;
    final EPUBVersion version;
    int startingLineNumber = 0;
    int startingColumnNumber = 0;
    static final CharMatcher SPACE_AND_QUOTES = CharMatcher.anyOf(" \t\n\r\f\"'").precomputed();
    String fontFamily;
    String fontStyle;
    String fontWeight;
    String fontUri;
    boolean inFontFace = false;
    boolean hasFontFaceDeclarations = false;
    boolean inKeyFrames = false;
    CssGrammar.CssAtRule atRule = null;
    static final Pattern invalidTokenStringFinder = Pattern.compile("Token '[0-9]+%' not allowed here");
    static final Pattern keyframesPattern = Pattern.compile("@((keyframes)|(-moz-keyframes)|(-webkit-keyframes)|(-o-keyframes))");

    public CSSHandler(String path, XRefChecker xrefChecker, Report report, EPUBVersion version) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.version = version;
    }

    private EPUBLocation getCorrectedEPUBLocation(String fileName, int lineNumber, int columnNumber, String context) {
        lineNumber = this.correctedLineNumber(lineNumber);
        columnNumber = this.correctedColumnNumber(lineNumber, columnNumber);
        return EPUBLocation.create(fileName, lineNumber, columnNumber, context);
    }

    private int correctedLineNumber(int lineNumber) {
        return this.startingLineNumber + lineNumber;
    }

    private int correctedColumnNumber(int lineNumber, int columnNumber) {
        if (lineNumber != 0) {
            return columnNumber;
        }
        return this.startingColumnNumber + columnNumber;
    }

    @Override
    public void error(CssExceptions.CssException e) throws CssExceptions.CssException {
        Matcher m;
        String message = e.getMessage();
        if (this.inKeyFrames && (m = invalidTokenStringFinder.matcher(message)).matches()) {
            return;
        }
        CssLocation location = e.getLocation();
        this.report.message(MessageId.CSS_008, this.getCorrectedEPUBLocation(this.path, location.getLine(), location.getColumn(), null), e.getMessage());
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startAtRule(CssGrammar.CssAtRule atRule) {
        String ruleName = (String)atRule.getName().get();
        this.atRule = atRule;
        if (ruleName.equals("@import")) {
            CssGrammar.CssConstruct uriOrString = (CssGrammar.CssConstruct)atRule.getComponents().get(0);
            if (uriOrString != null) {
                int line = uriOrString.getLocation().getLine();
                int col = uriOrString.getLocation().getColumn();
                String uri = null;
                if (uriOrString.getType() == CssGrammar.CssConstruct.Type.URI) {
                    uri = ((CssGrammar.CssURI)uriOrString).toUriString();
                } else if (uriOrString.getType() == CssGrammar.CssConstruct.Type.STRING) {
                    uri = CharMatcher.anyOf("\"'").trimFrom(uriOrString.toCssString());
                }
                if (uri != null) {
                    this.resolveAndRegister(uri, line, col, atRule.toCssString());
                }
            }
        } else if (!((String)atRule.getName().get()).equals("@namespace")) {
            this.registerURIs(atRule.getComponents(), atRule.getLocation().getLine(), atRule.getLocation().getColumn());
        }
        if (ruleName.equals("@font-face")) {
            this.inFontFace = true;
        } else if (keyframesPattern.matcher(ruleName).matches()) {
            this.inKeyFrames = true;
        }
    }

    @Override
    public void endAtRule(String name) {
        if (this.inFontFace) {
            this.inFontFace = false;
            this.handleFontFaceInfo();
            if (!this.hasFontFaceDeclarations) {
                this.report.message(MessageId.CSS_019, EPUBLocation.create(this.path, this.atRule.getLocation().getLine(), this.atRule.getLocation().getColumn(), this.atRule.toCssString()), new Object[0]);
            }
            this.hasFontFaceDeclarations = false;
        }
        if (this.inKeyFrames) {
            this.inKeyFrames = false;
        }
        this.atRule = null;
    }

    @Override
    public void selectors(List<CssGrammar.CssSelector> selectors) {
    }

    @Override
    public void endSelectors(List<CssGrammar.CssSelector> selectors) {
    }

    @Override
    public void declaration(CssGrammar.CssDeclaration declaration) {
        String value;
        CssGrammar.CssConstruct cns;
        this.registerURIs(declaration.getComponents(), declaration.getLocation().getLine(), declaration.getLocation().getColumn());
        String propertyName = (String)declaration.getName().get();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("position") && (cns = (CssGrammar.CssConstruct)declaration.getComponents().get(0)) != null && (value = cns.toCssString()) != null && value.equalsIgnoreCase("fixed")) {
            this.report.message(MessageId.CSS_006, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), new Object[0]);
        }
        if (this.version == EPUBVersion.VERSION_3 && (propertyName.equals("direction") || propertyName.equals("unicode-bidi"))) {
            this.report.message(MessageId.CSS_001, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), propertyName);
        }
        if (this.inFontFace) {
            CssGrammar.CssConstruct cc;
            this.hasFontFaceDeclarations = true;
            if (propertyName.equals("font-family")) {
                cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                if (cc != null) {
                    this.fontFamily = SPACE_AND_QUOTES.trimFrom(cc.toCssString());
                }
            } else if (propertyName.equals("font-style")) {
                cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                this.fontStyle = cc.toCssString();
            } else if (propertyName.equals("font-weight")) {
                cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                this.fontWeight = cc.toCssString();
            } else if (propertyName.equals("src")) {
                for (CssGrammar.CssConstruct construct : declaration.getComponents()) {
                    if (construct.getType() != CssGrammar.CssConstruct.Type.URI) continue;
                    this.fontUri = ((CssGrammar.CssURI)construct).toUriString();
                    this.fontUri = PathUtil.resolveRelativeReference(this.path, this.fontUri, null);
                    String fontMimeType = this.xrefChecker.getMimeType(this.fontUri);
                    if (fontMimeType == null) continue;
                    boolean blessed = true;
                    if (this.version == EPUBVersion.VERSION_2) {
                        blessed = OPFChecker.isBlessedFontMimetype20(fontMimeType);
                    } else if (this.version == EPUBVersion.VERSION_3) {
                        blessed = OPFChecker30.isBlessedFontType(fontMimeType);
                    }
                    if (blessed) continue;
                    this.report.message(MessageId.CSS_007, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), this.fontUri, fontMimeType);
                }
            }
            this.report.message(MessageId.CSS_028, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), this.fontUri != null ? this.fontUri : "null"), new Object[0]);
        }
    }

    private void registerURIs(List<CssGrammar.CssConstruct> constructs, int line, int col) {
        for (CssGrammar.CssConstruct construct : constructs) {
            if (construct.getType() != CssGrammar.CssConstruct.Type.URI) continue;
            this.resolveAndRegister(((CssGrammar.CssURI)construct).toUriString(), line, col, construct.toCssString());
        }
    }

    private void resolveAndRegister(String relativeRef, int line, int col, String context) {
        if (relativeRef != null && relativeRef.trim().length() > 0) {
            String resolved = PathUtil.resolveRelativeReference(this.path, relativeRef, null);
            this.xrefChecker.registerReference(this.path, line + this.startingLineNumber, col, resolved, XRefChecker.Type.GENERIC);
        } else {
            this.report.message(MessageId.CSS_002, this.getCorrectedEPUBLocation(this.path, line, col, context), new Object[0]);
        }
    }

    private void handleFontFaceInfo() {
        if (this.fontFamily != null) {
            if (this.fontUri != null && !this.fontUri.startsWith("http")) {
                this.report.info(this.path, FeatureEnum.FONT_EMBEDDED, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
            } else {
                this.report.info(this.path, FeatureEnum.FONT_REFERENCE, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
                this.report.info(this.path, FeatureEnum.REFERENCE, this.fontUri);
            }
        }
    }

    public void setStartingLineNumber(int offset) {
        this.startingLineNumber = offset - 1;
        if (this.startingLineNumber < 0) {
            this.startingLineNumber = 0;
        }
    }
}

