# Copyright (c) Microsoft Corporation.  All rights reserved.

"""Runtime Constants.
"""


class MediaTypes:
    """Constants of media types.

    http://www.iana.org/assignments/media-types/media-types.xhtml
    """
    Any = '*/*'
    Json = 'application/json'
    Xml = 'application/xml'
    OctetStream = 'application/octet-stream'
    SQL = 'application/sql'  
    ImageJpeg = 'image/jpeg'
    ImagePng = 'image/png'
    TextHtml = 'text/html'
    TextPlain = 'text/plain'
    JavaScript = 'application/x-javascript'