'''OpenGL extension ARB.transpose_matrix

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.transpose_matrix to provide a more 
Python-friendly API

Overview (from the spec)
	
	New functions and tokens are added allowing application matrices
	stored in row major order rather than column major order to be
	transferred to the OpenGL implementation.  This allows an application
	to use standard C-language 2-dimensional arrays (m[row][col]) and
	have the array indices match the expected matrix row and column indexes.
	These arrays are referred to as transpose matrices since they are
	the transpose of the standard matrices passed to OpenGL.
	
	This extension adds an interface for transfering data to and from the
	OpenGL pipeline, it does not change any OpenGL processing or imply any
	changes in state representation.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/transpose_matrix.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.transpose_matrix import *
### END AUTOGENERATED SECTION
for typ,arrayType in (
    ('d',arrays.GLdoubleArray),
    ('f',arrays.GLfloatArray),
):
    for function in ('glLoadTransposeMatrix','glMultTransposeMatrix'):
        name = '%s%sARB'%(function,typ)
        globals()[name] = arrays.setInputArraySizeType(
            globals()[name],
            16,
            arrayType,
            'm',
        )
        try:
            del function,name
        except NameError, err:
            pass
    try:
        del typ,arrayType
    except NameError, err:
        pass
