/*global window, jQuery, document, OpenLayers, google*/
/*

  Documentation is accessibile to this address
  - http://<plone_url>/++resource++collective.geo.mapwidget/docs.html

*/

(function ($) {
    "use strict";

    // = Collective Geo init =
    //
    // This script initialize collective.geo maps for each div
    // with {{{widget-cgmap}}} class
    //
    // See [[#collectivegeo.js]] for details
    //
    //
    // == Load maps ==
    //
    // After page has been loaded and the dom tree is fully instantiated
    // collective.geo javascript initalizes maps for each
    // {{{.widget-cgmap}}} div
    //
    // For each map you can customize some properties using data attributes
    //
    // * cgeolongitude
    // * cgeolatitude
    // * cgeozoom
    // * cgeolang
    //
    // you can also pass some default parameter to c.geo plugin:
    // For example.:
    //
    // {{{
    // maps.collectivegeo({
    //     center: new OpenLayers.LonLat('45.00', '7.3'),
    //     zoom: 7,
    //     lang: 'it'
    // });
    // }}}
    //
    //
    // == Add layers to specific map ==
    //
    // You can add layers to a map using {{{add_layer}}} method
    //
    // {{{
    // $('#mymap').collectivegeo(
    //     'add_layer',
    //     function () {
    //         return new OpenLayers.Layer...(
    //         ...layer code...
    //         );
    //     }
    // );
    // }}}
    //
    // or by {{{mapload}}} event
    //
    // {{{
    // $(window).bind('mapload', function (evt, widget) {
    //     widget.addLayers(
    //         [
    //             function () {
    //                 return new OpenLayers.Layer...(
    //                 ... layer code...
    //             }
    //         ],
    //         'mymapid'
    //     );
    // }}}


    $(window).bind("load", function () {
        // get all visible map and map-widgets
        var maps = $('.widget-cgmap').filter(':visible'),
            map_widgets = $('.map-widget .widget-cgmap').filter(':visible'),
            geosetting_map = $('#geosettings-cgmap'),
            fieldset = $(maps).parents('.formPanel'),
            tabs;

        // === Initialize Maps ==
        //
        // Initialize map for all div with class {{{widget-cgmap}}}
        //
        // Default settings are taken from data attributes
        //
        // * cgeolongitude
        // * cgeolatitude
        // * cgeozoom
        // * cgeolang
        maps.collectivegeo();

        // === Map in hidden tabs ==
        //
        // When a map is displayed in a hidden tab or div
        // it has to be refreshed when the tab is show.
        //
        // This trick works with jquerytools tabs in Plone forms
        // and also with tabs generated by {{{enableFormTabbing}}} class:
        // {{{
        //
        // <dl class="enableFormTabbing">
        //   ...
        //   <dt id="fieldsetlegend-map"><h2>My Map</h2></dt>
        //   <dd id="fieldset-map">
        //     <div id="mymap" class="widget-cgmap"></div>
        //   </dd>
        //   ...
        // </dl>
        //
        // }}}
        // get hidden maps (maps with no size yet)
        maps = $('.widget-cgmap').filter(':hidden');
        if (maps.length > 0) {
            tabs = $('select.formTabs, ul.formTabs');
            tabs.bind("onClick", function (e, index) {
                var curpanel = $(this).data('tabs').getCurrentPane();
                curpanel.find('.widget-cgmap').collectivegeo(); // refresh
                curpanel.find('.map-widget .widget-cgmap').collectivegeo('add_edit_layer');
                curpanel.find('.map-widget .widget-cgmap').collectivegeo('add_geocoder');
            });
        }
        

        // === Collective.geo controlpanel ==
        //
        // Set marker edit layer and geocoder in
        // collective.geo control panel.
        //
        // All maps with id {{{geosettings-cgmap}}}
        geosetting_map.collectivegeo(
            'add_markeredit_layer',
            'form-widgets-longitude',
            'form-widgets-latitude',
            'form-widgets-zoom'
        );
        geosetting_map.collectivegeo('add_geocoder');

        // === Collective.geo controlpanel ==
        //
        // Initialize maps for collective.z3cform.mapwidget
        //
        // Maps with edit bar are displayed in all div elements
        // with class {{{map-widget}}}
        map_widgets.collectivegeo('add_edit_layer');
        map_widgets.collectivegeo('add_geocoder');
    });

}(jQuery));
