!***************************************************************************************************
! Copyright 2000 D. Boscher, 2004 S. Bourdarie
!
! This file is part of IRBEM-LIB.
!
!    IRBEM-LIB is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Lesser General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    IRBEM-LIB is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU Lesser General Public License for more details.
!
!    You should have received a copy of the GNU Lesser General Public License
!    along with IRBEM-LIB.  If not, see <http://www.gnu.org/licenses/>.
!
!
! VERSION: IGRF13
!
! [EOS TRANS. AGU APRIL 21, 1992, P. 182]
!  Additional IGRF References:
!  (J. GEOMAG. GEOELECTR.(1982), V.34, P.313-315,
!  GEOMAGN. AND AERONOMY (1986), V.26, P.523-525).
!
!------INPUT PARAMETERS:
!  iyr - YEAR NUMBER (FROM 1900 UP TO 2025)
!----- OUTPUT PARAMETERS:
!  g,h - coefficients for the igrf model interpolated (or extrapolated)
!  to the epoch of iyr
!
!
       subroutine get_igrf_coeffs(year,g,h,ierr)
C
       IMPLICIT NONE
C
       REAL*8 F1,F2,DT,G(66),H(66)
       REAL*8 G1900(66), H1900(66)
       REAL*8 G1905(66), H1905(66)
       REAL*8 G1910(66), H1910(66)
       REAL*8 G1915(66), H1915(66)
       REAL*8 G1920(66), H1920(66)
       REAL*8 G1925(66), H1925(66)
       REAL*8 G1930(66), H1930(66)
       REAL*8 G1935(66), H1935(66)
       REAL*8 G1940(66), H1940(66)
       REAL*8 G1945(66), H1945(66)
       REAL*8 G1950(66), H1950(66)
       REAL*8 G1955(66), H1955(66)
       REAL*8 G1960(66), H1960(66)
       REAL*8 G1965(66), H1965(66)
       REAL*8 G1970(66), H1970(66)
       REAL*8 G1975(66), H1975(66)
       REAL*8 G1980(66), H1980(66)
       REAL*8 G1985(66), H1985(66)
       REAL*8 G1990(66), H1990(66)
       REAL*8 G1995(66), H1995(66)
       REAL*8 G2000(66), H2000(66)
       REAL*8 G2005(66), H2005(66)
       REAL*8 G2010(66), H2010(66)
       REAL*8 G2015(66), H2015(66)
       REAL*8 G2020(66), H2020(66)
       REAL*8 DG2020(45), DH2020(45)
C
       INTEGER*4 N,ierr
       REAL*8    year
       INTEGER*4 year_error_reported ! only report year error once
       save year_error_reported
       DATA year_error_reported/0/ ! initially not reported
C
       DATA G1900/
     *      0.00d0,
     * -31543.00d0, -2298.00d0,
     *   -677.00d0,  2905.00d0,   924.00d0,
     *   1022.00d0, -1469.00d0,  1256.00d0,   572.00d0,
     *    876.00d0,   628.00d0,   660.00d0,  -361.00d0,   134.00d0,
     *   -184.00d0,   328.00d0,   264.00d0,     5.00d0,   -86.00d0,
     *    -16.00d0,
     *     63.00d0,    61.00d0,   -11.00d0,  -217.00d0,   -58.00d0,
     *     59.00d0,   -90.00d0,
     *     70.00d0,   -55.00d0,     0.00d0,    34.00d0,   -41.00d0,
     *    -21.00d0,    18.00d0,     6.00d0,
     *     11.00d0,     8.00d0,    -4.00d0,    -9.00d0,     1.00d0,
     *      2.00d0,    -9.00d0,     5.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,    -1.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     2.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1900/
     *      0.00d0,
     *      0.00d0,  5922.00d0,
     *      0.00d0, -1061.00d0,  1121.00d0,
     *      0.00d0,  -330.00d0,     3.00d0,   523.00d0,
     *      0.00d0,   195.00d0,   -69.00d0,  -210.00d0,   -75.00d0,
     *      0.00d0,  -210.00d0,    53.00d0,   -33.00d0,  -124.00d0,
     *      3.00d0,
     *      0.00d0,    -9.00d0,    83.00d0,     2.00d0,   -35.00d0,
     *     36.00d0,   -69.00d0,
     *      0.00d0,   -45.00d0,   -13.00d0,   -10.00d0,    -1.00d0,
     *     28.00d0,   -12.00d0,   -22.00d0,
     *      0.00d0,     8.00d0,   -14.00d0,     7.00d0,   -13.00d0,
     *      5.00d0,    16.00d0,    -5.00d0,   -18.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     8.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1905/
     *      0.00d0,
     * -31464.00d0, -2298.00d0,
     *   -728.00d0,  2928.00d0,  1041.00d0,
     *   1037.00d0, -1494.00d0,  1239.00d0,   635.00d0,
     *    880.00d0,   643.00d0,   653.00d0,  -380.00d0,   146.00d0,
     *   -192.00d0,   328.00d0,   259.00d0,    -1.00d0,   -93.00d0,
     *    -26.00d0,
     *     62.00d0,    60.00d0,   -11.00d0,  -221.00d0,   -57.00d0,
     *     57.00d0,   -92.00d0,
     *     70.00d0,   -54.00d0,     0.00d0,    33.00d0,   -41.00d0,
     *    -20.00d0,    18.00d0,     6.00d0,
     *     11.00d0,     8.00d0,    -4.00d0,    -9.00d0,     1.00d0,
     *      2.00d0,    -8.00d0,     5.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,     0.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     2.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1905/
     *      0.00d0,
     *      0.00d0,  5909.00d0,
     *      0.00d0, -1086.00d0,  1065.00d0,
     *      0.00d0,  -357.00d0,    34.00d0,   480.00d0,
     *      0.00d0,   203.00d0,   -77.00d0,  -201.00d0,   -65.00d0,
     *      0.00d0,  -193.00d0,    56.00d0,   -32.00d0,  -125.00d0,
     *     11.00d0,
     *      0.00d0,    -7.00d0,    86.00d0,     4.00d0,   -32.00d0,
     *     32.00d0,   -67.00d0,
     *      0.00d0,   -46.00d0,   -14.00d0,   -11.00d0,     0.00d0,
     *     28.00d0,   -12.00d0,   -22.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     7.00d0,   -13.00d0,
     *      5.00d0,    16.00d0,    -5.00d0,   -18.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     8.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1910/
     *      0.00d0,
     * -31354.00d0, -2297.00d0,
     *   -769.00d0,  2948.00d0,  1176.00d0,
     *   1058.00d0, -1524.00d0,  1223.00d0,   705.00d0,
     *    884.00d0,   660.00d0,   644.00d0,  -400.00d0,   160.00d0,
     *   -201.00d0,   327.00d0,   253.00d0,    -9.00d0,  -102.00d0,
     *    -38.00d0,
     *     62.00d0,    58.00d0,   -11.00d0,  -224.00d0,   -54.00d0,
     *     54.00d0,   -95.00d0,
     *     71.00d0,   -54.00d0,     1.00d0,    32.00d0,   -40.00d0,
     *    -19.00d0,    18.00d0,     6.00d0,
     *     11.00d0,     8.00d0,    -4.00d0,    -9.00d0,     1.00d0,
     *      2.00d0,    -8.00d0,     5.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,     0.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     2.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1910/
     *      0.00d0,
     *      0.00d0,  5898.00d0,
     *      0.00d0, -1128.00d0,  1000.00d0,
     *      0.00d0,  -389.00d0,    62.00d0,   425.00d0,
     *      0.00d0,   211.00d0,   -90.00d0,  -189.00d0,   -55.00d0,
     *      0.00d0,  -172.00d0,    57.00d0,   -33.00d0,  -126.00d0,
     *     21.00d0,
     *      0.00d0,    -5.00d0,    89.00d0,     5.00d0,   -29.00d0,
     *     28.00d0,   -65.00d0,
     *      0.00d0,   -47.00d0,   -14.00d0,   -12.00d0,     1.00d0,
     *     28.00d0,   -13.00d0,   -22.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     6.00d0,   -13.00d0,
     *      5.00d0,    16.00d0,    -5.00d0,   -18.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     8.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1915/
     *      0.00d0,
     * -31212.00d0, -2306.00d0,
     *   -802.00d0,  2956.00d0,  1309.00d0,
     *   1084.00d0, -1559.00d0,  1212.00d0,   778.00d0,
     *    887.00d0,   678.00d0,   631.00d0,  -416.00d0,   178.00d0,
     *   -211.00d0,   327.00d0,   245.00d0,   -16.00d0,  -111.00d0,
     *    -51.00d0,
     *     61.00d0,    57.00d0,   -10.00d0,  -228.00d0,   -51.00d0,
     *     49.00d0,   -98.00d0,
     *     72.00d0,   -54.00d0,     2.00d0,    31.00d0,   -38.00d0,
     *    -18.00d0,    19.00d0,     6.00d0,
     *     11.00d0,     8.00d0,    -4.00d0,    -9.00d0,     2.00d0,
     *      3.00d0,    -8.00d0,     6.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,     0.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     1.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1915/
     *      0.00d0,
     *      0.00d0,  5875.00d0,
     *      0.00d0, -1191.00d0,   917.00d0,
     *      0.00d0,  -421.00d0,    84.00d0,   360.00d0,
     *      0.00d0,   218.00d0,  -109.00d0,  -173.00d0,   -51.00d0,
     *      0.00d0,  -148.00d0,    58.00d0,   -34.00d0,  -126.00d0,
     *     32.00d0,
     *      0.00d0,    -2.00d0,    93.00d0,     8.00d0,   -26.00d0,
     *     23.00d0,   -62.00d0,
     *      0.00d0,   -48.00d0,   -14.00d0,   -12.00d0,     2.00d0,
     *     28.00d0,   -15.00d0,   -22.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     6.00d0,   -13.00d0,
     *      5.00d0,    16.00d0,    -5.00d0,   -18.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     8.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1920/
     *      0.00d0,
     * -31060.00d0, -2317.00d0,
     *   -839.00d0,  2959.00d0,  1407.00d0,
     *   1111.00d0, -1600.00d0,  1205.00d0,   839.00d0,
     *    889.00d0,   695.00d0,   616.00d0,  -424.00d0,   199.00d0,
     *   -221.00d0,   326.00d0,   236.00d0,   -23.00d0,  -119.00d0,
     *    -62.00d0,
     *     61.00d0,    55.00d0,   -10.00d0,  -233.00d0,   -46.00d0,
     *     44.00d0,  -101.00d0,
     *     73.00d0,   -54.00d0,     2.00d0,    29.00d0,   -37.00d0,
     *    -16.00d0,    19.00d0,     6.00d0,
     *     11.00d0,     7.00d0,    -3.00d0,    -9.00d0,     2.00d0,
     *      4.00d0,    -7.00d0,     6.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,     0.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     1.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1920/
     *      0.00d0,
     *      0.00d0,  5845.00d0,
     *      0.00d0, -1259.00d0,   823.00d0,
     *      0.00d0,  -445.00d0,   103.00d0,   293.00d0,
     *      0.00d0,   220.00d0,  -134.00d0,  -153.00d0,   -57.00d0,
     *      0.00d0,  -122.00d0,    58.00d0,   -38.00d0,  -125.00d0,
     *     43.00d0,
     *      0.00d0,     0.00d0,    96.00d0,    11.00d0,   -22.00d0,
     *     18.00d0,   -57.00d0,
     *      0.00d0,   -49.00d0,   -14.00d0,   -13.00d0,     4.00d0,
     *     28.00d0,   -16.00d0,   -22.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     6.00d0,   -14.00d0,
     *      5.00d0,    17.00d0,    -5.00d0,   -19.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     9.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1925/
     *      0.00d0,
     * -30926.00d0, -2318.00d0,
     *   -893.00d0,  2969.00d0,  1471.00d0,
     *   1140.00d0, -1645.00d0,  1202.00d0,   881.00d0,
     *    891.00d0,   711.00d0,   601.00d0,  -426.00d0,   217.00d0,
     *   -230.00d0,   326.00d0,   226.00d0,   -28.00d0,  -125.00d0,
     *    -69.00d0,
     *     61.00d0,    54.00d0,    -9.00d0,  -238.00d0,   -40.00d0,
     *     39.00d0,  -103.00d0,
     *     73.00d0,   -54.00d0,     3.00d0,    27.00d0,   -35.00d0,
     *    -14.00d0,    19.00d0,     6.00d0,
     *     11.00d0,     7.00d0,    -3.00d0,    -9.00d0,     2.00d0,
     *      4.00d0,    -7.00d0,     7.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -11.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     2.00d0,     0.00d0,    -1.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     1.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1925/
     *      0.00d0,
     *      0.00d0,  5817.00d0,
     *      0.00d0, -1334.00d0,   728.00d0,
     *      0.00d0,  -462.00d0,   119.00d0,   229.00d0,
     *      0.00d0,   216.00d0,  -163.00d0,  -130.00d0,   -70.00d0,
     *      0.00d0,   -96.00d0,    58.00d0,   -44.00d0,  -122.00d0,
     *     51.00d0,
     *      0.00d0,     3.00d0,    99.00d0,    14.00d0,   -18.00d0,
     *     13.00d0,   -52.00d0,
     *      0.00d0,   -50.00d0,   -14.00d0,   -14.00d0,     5.00d0,
     *     29.00d0,   -17.00d0,   -21.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     6.00d0,   -14.00d0,
     *      5.00d0,    17.00d0,    -5.00d0,   -19.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     9.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1930/
     *      0.00d0,
     * -30805.00d0, -2316.00d0,
     *   -951.00d0,  2980.00d0,  1517.00d0,
     *   1172.00d0, -1692.00d0,  1205.00d0,   907.00d0,
     *    896.00d0,   727.00d0,   584.00d0,  -422.00d0,   234.00d0,
     *   -237.00d0,   327.00d0,   218.00d0,   -32.00d0,  -131.00d0,
     *    -74.00d0,
     *     60.00d0,    53.00d0,    -9.00d0,  -242.00d0,   -32.00d0,
     *     32.00d0,  -104.00d0,
     *     74.00d0,   -54.00d0,     4.00d0,    25.00d0,   -34.00d0,
     *    -12.00d0,    18.00d0,     6.00d0,
     *     11.00d0,     7.00d0,    -3.00d0,    -9.00d0,     2.00d0,
     *      5.00d0,    -6.00d0,     8.00d0,     8.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -12.00d0,    12.00d0,
     *      1.00d0,    -2.00d0,     3.00d0,     0.00d0,    -2.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     1.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1930/
     *      0.00d0,
     *      0.00d0,  5808.00d0,
     *      0.00d0, -1424.00d0,   644.00d0,
     *      0.00d0,  -480.00d0,   133.00d0,   166.00d0,
     *      0.00d0,   205.00d0,  -195.00d0,  -109.00d0,   -90.00d0,
     *      0.00d0,   -72.00d0,    60.00d0,   -53.00d0,  -118.00d0,
     *     58.00d0,
     *      0.00d0,     4.00d0,   102.00d0,    19.00d0,   -16.00d0,
     *      8.00d0,   -46.00d0,
     *      0.00d0,   -51.00d0,   -15.00d0,   -14.00d0,     6.00d0,
     *     29.00d0,   -18.00d0,   -20.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     5.00d0,   -14.00d0,
     *      5.00d0,    18.00d0,    -5.00d0,   -19.00d0,
     *      0.00d0,   -20.00d0,    14.00d0,     5.00d0,    -3.00d0,
     *     -2.00d0,     9.00d0,    10.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1935/
     *      0.00d0,
     * -30715.00d0, -2306.00d0,
     *  -1018.00d0,  2984.00d0,  1550.00d0,
     *   1206.00d0, -1740.00d0,  1215.00d0,   918.00d0,
     *    903.00d0,   744.00d0,   565.00d0,  -415.00d0,   249.00d0,
     *   -241.00d0,   329.00d0,   211.00d0,   -33.00d0,  -136.00d0,
     *    -76.00d0,
     *     59.00d0,    53.00d0,    -8.00d0,  -246.00d0,   -25.00d0,
     *     25.00d0,  -106.00d0,
     *     74.00d0,   -53.00d0,     4.00d0,    23.00d0,   -33.00d0,
     *    -11.00d0,    18.00d0,     6.00d0,
     *     11.00d0,     7.00d0,    -3.00d0,    -9.00d0,     1.00d0,
     *      6.00d0,    -6.00d0,     8.00d0,     7.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -12.00d0,    11.00d0,
     *      1.00d0,    -2.00d0,     3.00d0,     0.00d0,    -2.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     2.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1935/
     *      0.00d0,
     *      0.00d0,  5812.00d0,
     *      0.00d0, -1520.00d0,   586.00d0,
     *      0.00d0,  -494.00d0,   146.00d0,   101.00d0,
     *      0.00d0,   188.00d0,  -226.00d0,   -90.00d0,  -114.00d0,
     *      0.00d0,   -51.00d0,    64.00d0,   -64.00d0,  -115.00d0,
     *     64.00d0,
     *      0.00d0,     4.00d0,   104.00d0,    25.00d0,   -15.00d0,
     *      4.00d0,   -40.00d0,
     *      0.00d0,   -52.00d0,   -17.00d0,   -14.00d0,     7.00d0,
     *     29.00d0,   -19.00d0,   -19.00d0,
     *      0.00d0,     8.00d0,   -15.00d0,     5.00d0,   -15.00d0,
     *      5.00d0,    18.00d0,    -5.00d0,   -19.00d0,
     *      0.00d0,   -20.00d0,    15.00d0,     5.00d0,    -3.00d0,
     *     -3.00d0,     9.00d0,    11.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -1.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1940/
     *      0.00d0,
     * -30654.00d0, -2292.00d0,
     *  -1106.00d0,  2981.00d0,  1566.00d0,
     *   1240.00d0, -1790.00d0,  1232.00d0,   916.00d0,
     *    914.00d0,   762.00d0,   550.00d0,  -405.00d0,   265.00d0,
     *   -241.00d0,   334.00d0,   208.00d0,   -33.00d0,  -141.00d0,
     *    -76.00d0,
     *     57.00d0,    54.00d0,    -7.00d0,  -249.00d0,   -18.00d0,
     *     18.00d0,  -107.00d0,
     *     74.00d0,   -53.00d0,     4.00d0,    20.00d0,   -31.00d0,
     *     -9.00d0,    17.00d0,     5.00d0,
     *     11.00d0,     7.00d0,    -3.00d0,   -10.00d0,     1.00d0,
     *      6.00d0,    -5.00d0,     9.00d0,     7.00d0,
     *      8.00d0,    10.00d0,     1.00d0,   -12.00d0,    11.00d0,
     *      1.00d0,    -2.00d0,     3.00d0,     1.00d0,    -2.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      6.00d0,     4.00d0,     0.00d0,     2.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1940/
     *      0.00d0,
     *      0.00d0,  5821.00d0,
     *      0.00d0, -1614.00d0,   528.00d0,
     *      0.00d0,  -499.00d0,   163.00d0,    43.00d0,
     *      0.00d0,   169.00d0,  -252.00d0,   -72.00d0,  -141.00d0,
     *      0.00d0,   -33.00d0,    71.00d0,   -75.00d0,  -113.00d0,
     *     69.00d0,
     *      0.00d0,     4.00d0,   105.00d0,    33.00d0,   -15.00d0,
     *      0.00d0,   -33.00d0,
     *      0.00d0,   -52.00d0,   -18.00d0,   -14.00d0,     7.00d0,
     *     29.00d0,   -20.00d0,   -19.00d0,
     *      0.00d0,     8.00d0,   -14.00d0,     5.00d0,   -15.00d0,
     *      5.00d0,    19.00d0,    -5.00d0,   -19.00d0,
     *      0.00d0,   -21.00d0,    15.00d0,     5.00d0,    -3.00d0,
     *     -3.00d0,     9.00d0,    11.00d0,    -2.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -1.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1945/
     *      0.00d0,
     * -30594.00d0, -2285.00d0,
     *  -1244.00d0,  2990.00d0,  1578.00d0,
     *   1282.00d0, -1834.00d0,  1255.00d0,   913.00d0,
     *    944.00d0,   776.00d0,   544.00d0,  -421.00d0,   304.00d0,
     *   -253.00d0,   346.00d0,   194.00d0,   -20.00d0,  -142.00d0,
     *    -82.00d0,
     *     59.00d0,    57.00d0,     6.00d0,  -246.00d0,   -25.00d0,
     *     21.00d0,  -104.00d0,
     *     70.00d0,   -40.00d0,     0.00d0,     0.00d0,   -29.00d0,
     *    -10.00d0,    15.00d0,    29.00d0,
     *     13.00d0,     7.00d0,    -8.00d0,    -5.00d0,     9.00d0,
     *      7.00d0,   -10.00d0,     7.00d0,     2.00d0,
     *      5.00d0,   -21.00d0,     1.00d0,   -11.00d0,     3.00d0,
     *     16.00d0,    -3.00d0,    -4.00d0,    -3.00d0,    -4.00d0,
     *     -3.00d0,    11.00d0,     1.00d0,     2.00d0,    -5.00d0,
     *     -1.00d0,     8.00d0,    -1.00d0,    -3.00d0,     5.00d0,
     *     -2.00d0
     * /

       DATA H1945/
     *      0.00d0,
     *      0.00d0,  5810.00d0,
     *      0.00d0, -1702.00d0,   477.00d0,
     *      0.00d0,  -499.00d0,   186.00d0,   -11.00d0,
     *      0.00d0,   144.00d0,  -276.00d0,   -55.00d0,  -178.00d0,
     *      0.00d0,   -12.00d0,    95.00d0,   -67.00d0,  -119.00d0,
     *     82.00d0,
     *      0.00d0,     6.00d0,   100.00d0,    16.00d0,    -9.00d0,
     *    -16.00d0,   -39.00d0,
     *      0.00d0,   -45.00d0,   -18.00d0,     2.00d0,     6.00d0,
     *     28.00d0,   -17.00d0,   -22.00d0,
     *      0.00d0,    12.00d0,   -21.00d0,   -12.00d0,    -7.00d0,
     *      2.00d0,    18.00d0,     3.00d0,   -11.00d0,
     *      0.00d0,   -27.00d0,    17.00d0,    29.00d0,    -9.00d0,
     *      4.00d0,     9.00d0,     6.00d0,     1.00d0,     8.00d0,
     *      0.00d0,     5.00d0,     1.00d0,   -20.00d0,    -1.00d0,
     *     -6.00d0,     6.00d0,    -4.00d0,    -2.00d0,     0.00d0,
     *     -2.00d0
     * /
       DATA G1950/
     *      0.00d0,
     * -30554.00d0, -2250.00d0,
     *  -1341.00d0,  2998.00d0,  1576.00d0,
     *   1297.00d0, -1889.00d0,  1274.00d0,   896.00d0,
     *    954.00d0,   792.00d0,   528.00d0,  -408.00d0,   303.00d0,
     *   -240.00d0,   349.00d0,   211.00d0,   -20.00d0,  -147.00d0,
     *    -76.00d0,
     *     54.00d0,    57.00d0,     4.00d0,  -247.00d0,   -16.00d0,
     *     12.00d0,  -105.00d0,
     *     65.00d0,   -55.00d0,     2.00d0,     1.00d0,   -40.00d0,
     *     -7.00d0,     5.00d0,    19.00d0,
     *     22.00d0,    15.00d0,    -4.00d0,    -1.00d0,    11.00d0,
     *     15.00d0,   -13.00d0,     5.00d0,    -1.00d0,
     *      3.00d0,    -7.00d0,    -1.00d0,   -25.00d0,    10.00d0,
     *      5.00d0,    -5.00d0,    -2.00d0,     3.00d0,     8.00d0,
     *     -8.00d0,     4.00d0,    -1.00d0,    13.00d0,    -4.00d0,
     *      4.00d0,    12.00d0,     3.00d0,     2.00d0,    10.00d0,
     *      3.00d0
     * /

       DATA H1950/
     *      0.00d0,
     *      0.00d0,  5815.00d0,
     *      0.00d0, -1810.00d0,   381.00d0,
     *      0.00d0,  -476.00d0,   206.00d0,   -46.00d0,
     *      0.00d0,   136.00d0,  -278.00d0,   -37.00d0,  -210.00d0,
     *      0.00d0,     3.00d0,   103.00d0,   -87.00d0,  -122.00d0,
     *     80.00d0,
     *      0.00d0,    -1.00d0,    99.00d0,    33.00d0,   -12.00d0,
     *    -12.00d0,   -30.00d0,
     *      0.00d0,   -35.00d0,   -17.00d0,     0.00d0,    10.00d0,
     *     36.00d0,   -18.00d0,   -16.00d0,
     *      0.00d0,     5.00d0,   -22.00d0,     0.00d0,   -21.00d0,
     *     -8.00d0,    17.00d0,    -4.00d0,   -17.00d0,
     *      0.00d0,   -24.00d0,    19.00d0,    12.00d0,     2.00d0,
     *      2.00d0,     8.00d0,     8.00d0,   -11.00d0,    -7.00d0,
     *      0.00d0,    13.00d0,    -2.00d0,   -10.00d0,     2.00d0,
     *     -3.00d0,     6.00d0,    -3.00d0,     6.00d0,    11.00d0,
     *      8.00d0
     * /
       DATA G1955/
     *      0.00d0,
     * -30500.00d0, -2215.00d0,
     *  -1440.00d0,  3003.00d0,  1581.00d0,
     *   1302.00d0, -1944.00d0,  1288.00d0,   882.00d0,
     *    958.00d0,   796.00d0,   510.00d0,  -397.00d0,   290.00d0,
     *   -229.00d0,   360.00d0,   230.00d0,   -23.00d0,  -152.00d0,
     *    -69.00d0,
     *     47.00d0,    57.00d0,     3.00d0,  -247.00d0,    -8.00d0,
     *      7.00d0,  -107.00d0,
     *     65.00d0,   -56.00d0,     2.00d0,    10.00d0,   -32.00d0,
     *    -11.00d0,     9.00d0,    18.00d0,
     *     11.00d0,     9.00d0,    -6.00d0,   -14.00d0,     6.00d0,
     *     10.00d0,    -7.00d0,     6.00d0,     9.00d0,
     *      4.00d0,     9.00d0,    -4.00d0,    -5.00d0,     2.00d0,
     *      4.00d0,     1.00d0,     2.00d0,     2.00d0,     5.00d0,
     *     -3.00d0,    -5.00d0,    -1.00d0,     2.00d0,    -3.00d0,
     *      7.00d0,     4.00d0,    -2.00d0,     6.00d0,    -2.00d0,
     *      0.00d0
     * /

       DATA H1955/
     *      0.00d0,
     *      0.00d0,  5820.00d0,
     *      0.00d0, -1898.00d0,   291.00d0,
     *      0.00d0,  -462.00d0,   216.00d0,   -83.00d0,
     *      0.00d0,   133.00d0,  -274.00d0,   -23.00d0,  -230.00d0,
     *      0.00d0,    15.00d0,   110.00d0,   -98.00d0,  -121.00d0,
     *     78.00d0,
     *      0.00d0,    -9.00d0,    96.00d0,    48.00d0,   -16.00d0,
     *    -12.00d0,   -24.00d0,
     *      0.00d0,   -50.00d0,   -24.00d0,    -4.00d0,     8.00d0,
     *     28.00d0,   -20.00d0,   -18.00d0,
     *      0.00d0,    10.00d0,   -15.00d0,     5.00d0,   -23.00d0,
     *      3.00d0,    23.00d0,    -4.00d0,   -13.00d0,
     *      0.00d0,   -11.00d0,    12.00d0,     7.00d0,     6.00d0,
     *     -2.00d0,    10.00d0,     7.00d0,    -6.00d0,     5.00d0,
     *      0.00d0,    -4.00d0,     0.00d0,    -8.00d0,    -2.00d0,
     *     -4.00d0,     1.00d0,    -3.00d0,     7.00d0,    -1.00d0,
     *     -3.00d0
     * /
       DATA G1960/
     *      0.00d0,
     * -30421.00d0, -2169.00d0,
     *  -1555.00d0,  3002.00d0,  1590.00d0,
     *   1302.00d0, -1992.00d0,  1289.00d0,   878.00d0,
     *    957.00d0,   800.00d0,   504.00d0,  -394.00d0,   269.00d0,
     *   -222.00d0,   362.00d0,   242.00d0,   -26.00d0,  -156.00d0,
     *    -63.00d0,
     *     46.00d0,    58.00d0,     1.00d0,  -237.00d0,    -1.00d0,
     *     -2.00d0,  -113.00d0,
     *     67.00d0,   -56.00d0,     5.00d0,    15.00d0,   -32.00d0,
     *     -7.00d0,    17.00d0,     8.00d0,
     *     15.00d0,     6.00d0,    -4.00d0,   -11.00d0,     2.00d0,
     *     10.00d0,    -5.00d0,    10.00d0,     8.00d0,
     *      4.00d0,     6.00d0,     0.00d0,    -9.00d0,     1.00d0,
     *      4.00d0,    -1.00d0,    -2.00d0,     3.00d0,    -1.00d0,
     *      1.00d0,    -3.00d0,     4.00d0,     0.00d0,    -1.00d0,
     *      4.00d0,     6.00d0,     1.00d0,    -1.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1960/
     *      0.00d0,
     *      0.00d0,  5791.00d0,
     *      0.00d0, -1967.00d0,   206.00d0,
     *      0.00d0,  -414.00d0,   224.00d0,  -130.00d0,
     *      0.00d0,   135.00d0,  -278.00d0,     3.00d0,  -255.00d0,
     *      0.00d0,    16.00d0,   125.00d0,  -117.00d0,  -114.00d0,
     *     81.00d0,
     *      0.00d0,   -10.00d0,    99.00d0,    60.00d0,   -20.00d0,
     *    -11.00d0,   -17.00d0,
     *      0.00d0,   -55.00d0,   -28.00d0,    -6.00d0,     7.00d0,
     *     23.00d0,   -18.00d0,   -17.00d0,
     *      0.00d0,    11.00d0,   -14.00d0,     7.00d0,   -18.00d0,
     *      4.00d0,    23.00d0,     1.00d0,   -20.00d0,
     *      0.00d0,   -18.00d0,    12.00d0,     2.00d0,     0.00d0,
     *     -3.00d0,     9.00d0,     8.00d0,     0.00d0,     5.00d0,
     *      0.00d0,     4.00d0,     1.00d0,     0.00d0,     2.00d0,
     *     -5.00d0,     1.00d0,    -1.00d0,     6.00d0,     0.00d0,
     *     -7.00d0
     * /
       DATA G1965/
     *      0.00d0,
     * -30334.00d0, -2119.00d0,
     *  -1662.00d0,  2997.00d0,  1594.00d0,
     *   1297.00d0, -2038.00d0,  1292.00d0,   856.00d0,
     *    957.00d0,   804.00d0,   479.00d0,  -390.00d0,   252.00d0,
     *   -219.00d0,   358.00d0,   254.00d0,   -31.00d0,  -157.00d0,
     *    -62.00d0,
     *     45.00d0,    61.00d0,     8.00d0,  -228.00d0,     4.00d0,
     *      1.00d0,  -111.00d0,
     *     75.00d0,   -57.00d0,     4.00d0,    13.00d0,   -26.00d0,
     *     -6.00d0,    13.00d0,     1.00d0,
     *     13.00d0,     5.00d0,    -4.00d0,   -14.00d0,     0.00d0,
     *      8.00d0,    -1.00d0,    11.00d0,     4.00d0,
     *      8.00d0,    10.00d0,     2.00d0,   -13.00d0,    10.00d0,
     *     -1.00d0,    -1.00d0,     5.00d0,     1.00d0,    -2.00d0,
     *     -2.00d0,    -3.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      4.00d0,     4.00d0,     0.00d0,     2.00d0,     2.00d0,
     *      0.00d0
     * /

       DATA H1965/
     *      0.00d0,
     *      0.00d0,  5776.00d0,
     *      0.00d0, -2016.00d0,   114.00d0,
     *      0.00d0,  -404.00d0,   240.00d0,  -165.00d0,
     *      0.00d0,   148.00d0,  -269.00d0,    13.00d0,  -269.00d0,
     *      0.00d0,    19.00d0,   128.00d0,  -126.00d0,   -97.00d0,
     *     81.00d0,
     *      0.00d0,   -11.00d0,   100.00d0,    68.00d0,   -32.00d0,
     *     -8.00d0,    -7.00d0,
     *      0.00d0,   -61.00d0,   -27.00d0,    -2.00d0,     6.00d0,
     *     26.00d0,   -23.00d0,   -12.00d0,
     *      0.00d0,     7.00d0,   -12.00d0,     9.00d0,   -16.00d0,
     *      4.00d0,    24.00d0,    -3.00d0,   -17.00d0,
     *      0.00d0,   -22.00d0,    15.00d0,     7.00d0,    -4.00d0,
     *     -5.00d0,    10.00d0,    10.00d0,    -4.00d0,     1.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     2.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     3.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1970/
     *      0.00d0,
     * -30220.00d0, -2068.00d0,
     *  -1781.00d0,  3000.00d0,  1611.00d0,
     *   1287.00d0, -2091.00d0,  1278.00d0,   838.00d0,
     *    952.00d0,   800.00d0,   461.00d0,  -395.00d0,   234.00d0,
     *   -216.00d0,   359.00d0,   262.00d0,   -42.00d0,  -160.00d0,
     *    -56.00d0,
     *     43.00d0,    64.00d0,    15.00d0,  -212.00d0,     2.00d0,
     *      3.00d0,  -112.00d0,
     *     72.00d0,   -57.00d0,     1.00d0,    14.00d0,   -22.00d0,
     *     -2.00d0,    13.00d0,    -2.00d0,
     *     14.00d0,     6.00d0,    -2.00d0,   -13.00d0,    -3.00d0,
     *      5.00d0,     0.00d0,    11.00d0,     3.00d0,
     *      8.00d0,    10.00d0,     2.00d0,   -12.00d0,    10.00d0,
     *     -1.00d0,     0.00d0,     3.00d0,     1.00d0,    -1.00d0,
     *     -3.00d0,    -3.00d0,     2.00d0,    -5.00d0,    -1.00d0,
     *      6.00d0,     4.00d0,     1.00d0,     0.00d0,     3.00d0,
     *     -1.00d0
     * /

       DATA H1970/
     *      0.00d0,
     *      0.00d0,  5737.00d0,
     *      0.00d0, -2047.00d0,    25.00d0,
     *      0.00d0,  -366.00d0,   251.00d0,  -196.00d0,
     *      0.00d0,   167.00d0,  -266.00d0,    26.00d0,  -279.00d0,
     *      0.00d0,    26.00d0,   139.00d0,  -139.00d0,   -91.00d0,
     *     83.00d0,
     *      0.00d0,   -12.00d0,   100.00d0,    72.00d0,   -37.00d0,
     *     -6.00d0,     1.00d0,
     *      0.00d0,   -70.00d0,   -27.00d0,    -4.00d0,     8.00d0,
     *     23.00d0,   -23.00d0,   -11.00d0,
     *      0.00d0,     7.00d0,   -15.00d0,     6.00d0,   -17.00d0,
     *      6.00d0,    21.00d0,    -6.00d0,   -16.00d0,
     *      0.00d0,   -21.00d0,    16.00d0,     6.00d0,    -4.00d0,
     *     -5.00d0,    10.00d0,    11.00d0,    -2.00d0,     1.00d0,
     *      0.00d0,     1.00d0,     1.00d0,     3.00d0,     4.00d0,
     *     -4.00d0,     0.00d0,    -1.00d0,     3.00d0,     1.00d0,
     *     -4.00d0
     * /
       DATA G1975/
     *      0.00d0,
     * -30100.00d0, -2013.00d0,
     *  -1902.00d0,  3010.00d0,  1632.00d0,
     *   1276.00d0, -2144.00d0,  1260.00d0,   830.00d0,
     *    946.00d0,   791.00d0,   438.00d0,  -405.00d0,   216.00d0,
     *   -218.00d0,   356.00d0,   264.00d0,   -59.00d0,  -159.00d0,
     *    -49.00d0,
     *     45.00d0,    66.00d0,    28.00d0,  -198.00d0,     1.00d0,
     *      6.00d0,  -111.00d0,
     *     71.00d0,   -56.00d0,     1.00d0,    16.00d0,   -14.00d0,
     *      0.00d0,    12.00d0,    -5.00d0,
     *     14.00d0,     6.00d0,    -1.00d0,   -12.00d0,    -8.00d0,
     *      4.00d0,     0.00d0,    10.00d0,     1.00d0,
     *      7.00d0,    10.00d0,     2.00d0,   -12.00d0,    10.00d0,
     *     -1.00d0,    -1.00d0,     4.00d0,     1.00d0,    -2.00d0,
     *     -3.00d0,    -3.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      5.00d0,     4.00d0,     1.00d0,     0.00d0,     3.00d0,
     *     -1.00d0
     * /

       DATA H1975/
     *      0.00d0,
     *      0.00d0,  5675.00d0,
     *      0.00d0, -2067.00d0,   -68.00d0,
     *      0.00d0,  -333.00d0,   262.00d0,  -223.00d0,
     *      0.00d0,   191.00d0,  -265.00d0,    39.00d0,  -288.00d0,
     *      0.00d0,    31.00d0,   148.00d0,  -152.00d0,   -83.00d0,
     *     88.00d0,
     *      0.00d0,   -13.00d0,    99.00d0,    75.00d0,   -41.00d0,
     *     -4.00d0,    11.00d0,
     *      0.00d0,   -77.00d0,   -26.00d0,    -5.00d0,    10.00d0,
     *     22.00d0,   -23.00d0,   -12.00d0,
     *      0.00d0,     6.00d0,   -16.00d0,     4.00d0,   -19.00d0,
     *      6.00d0,    18.00d0,   -10.00d0,   -17.00d0,
     *      0.00d0,   -21.00d0,    16.00d0,     7.00d0,    -4.00d0,
     *     -5.00d0,    10.00d0,    11.00d0,    -3.00d0,     1.00d0,
     *      0.00d0,     1.00d0,     1.00d0,     3.00d0,     4.00d0,
     *     -4.00d0,    -1.00d0,    -1.00d0,     3.00d0,     1.00d0,
     *     -5.00d0
     * /
       DATA G1980/
     *      0.00d0,
     * -29992.00d0, -1956.00d0,
     *  -1997.00d0,  3027.00d0,  1663.00d0,
     *   1281.00d0, -2180.00d0,  1251.00d0,   833.00d0,
     *    938.00d0,   782.00d0,   398.00d0,  -419.00d0,   199.00d0,
     *   -218.00d0,   357.00d0,   261.00d0,   -74.00d0,  -162.00d0,
     *    -48.00d0,
     *     48.00d0,    66.00d0,    42.00d0,  -192.00d0,     4.00d0,
     *     14.00d0,  -108.00d0,
     *     72.00d0,   -59.00d0,     2.00d0,    21.00d0,   -12.00d0,
     *      1.00d0,    11.00d0,    -2.00d0,
     *     18.00d0,     6.00d0,     0.00d0,   -11.00d0,    -7.00d0,
     *      4.00d0,     3.00d0,     6.00d0,    -1.00d0,
     *      5.00d0,    10.00d0,     1.00d0,   -12.00d0,     9.00d0,
     *     -3.00d0,    -1.00d0,     7.00d0,     2.00d0,    -5.00d0,
     *     -4.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      5.00d0,     3.00d0,     1.00d0,     2.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1980/
     *      0.00d0,
     *      0.00d0,  5604.00d0,
     *      0.00d0, -2129.00d0,  -200.00d0,
     *      0.00d0,  -336.00d0,   271.00d0,  -252.00d0,
     *      0.00d0,   212.00d0,  -257.00d0,    53.00d0,  -297.00d0,
     *      0.00d0,    46.00d0,   150.00d0,  -151.00d0,   -78.00d0,
     *     92.00d0,
     *      0.00d0,   -15.00d0,    93.00d0,    71.00d0,   -43.00d0,
     *     -2.00d0,    17.00d0,
     *      0.00d0,   -82.00d0,   -27.00d0,    -5.00d0,    16.00d0,
     *     18.00d0,   -23.00d0,   -10.00d0,
     *      0.00d0,     7.00d0,   -18.00d0,     4.00d0,   -22.00d0,
     *      9.00d0,    16.00d0,   -13.00d0,   -15.00d0,
     *      0.00d0,   -21.00d0,    16.00d0,     9.00d0,    -5.00d0,
     *     -6.00d0,     9.00d0,    10.00d0,    -6.00d0,     2.00d0,
     *      0.00d0,     1.00d0,     0.00d0,     3.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -1.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1985/
     *      0.00d0,
     * -29873.00d0, -1905.00d0,
     *  -2072.00d0,  3044.00d0,  1687.00d0,
     *   1296.00d0, -2208.00d0,  1247.00d0,   829.00d0,
     *    936.00d0,   780.00d0,   361.00d0,  -424.00d0,   170.00d0,
     *   -214.00d0,   355.00d0,   253.00d0,   -93.00d0,  -164.00d0,
     *    -46.00d0,
     *     53.00d0,    65.00d0,    51.00d0,  -185.00d0,     4.00d0,
     *     16.00d0,  -102.00d0,
     *     74.00d0,   -62.00d0,     3.00d0,    24.00d0,    -6.00d0,
     *      4.00d0,    10.00d0,     0.00d0,
     *     21.00d0,     6.00d0,     0.00d0,   -11.00d0,    -9.00d0,
     *      4.00d0,     4.00d0,     4.00d0,    -4.00d0,
     *      5.00d0,    10.00d0,     1.00d0,   -12.00d0,     9.00d0,
     *     -3.00d0,    -1.00d0,     7.00d0,     1.00d0,    -5.00d0,
     *     -4.00d0,    -4.00d0,     3.00d0,    -5.00d0,    -2.00d0,
     *      5.00d0,     3.00d0,     1.00d0,     2.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1985/
     *      0.00d0,
     *      0.00d0,  5500.00d0,
     *      0.00d0, -2197.00d0,  -306.00d0,
     *      0.00d0,  -310.00d0,   284.00d0,  -297.00d0,
     *      0.00d0,   232.00d0,  -249.00d0,    69.00d0,  -297.00d0,
     *      0.00d0,    47.00d0,   150.00d0,  -154.00d0,   -75.00d0,
     *     95.00d0,
     *      0.00d0,   -16.00d0,    88.00d0,    69.00d0,   -48.00d0,
     *     -1.00d0,    21.00d0,
     *      0.00d0,   -83.00d0,   -27.00d0,    -2.00d0,    20.00d0,
     *     17.00d0,   -23.00d0,    -7.00d0,
     *      0.00d0,     8.00d0,   -19.00d0,     5.00d0,   -23.00d0,
     *     11.00d0,    14.00d0,   -15.00d0,   -11.00d0,
     *      0.00d0,   -21.00d0,    15.00d0,     9.00d0,    -6.00d0,
     *     -6.00d0,     9.00d0,     9.00d0,    -7.00d0,     2.00d0,
     *      0.00d0,     1.00d0,     0.00d0,     3.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -1.00d0,     4.00d0,     0.00d0,
     *     -6.00d0
     * /
       DATA G1990/
     *      0.00d0,
     * -29775.00d0, -1848.00d0,
     *  -2131.00d0,  3059.00d0,  1686.00d0,
     *   1314.00d0, -2239.00d0,  1248.00d0,   802.00d0,
     *    939.00d0,   780.00d0,   325.00d0,  -423.00d0,   141.00d0,
     *   -214.00d0,   353.00d0,   245.00d0,  -109.00d0,  -165.00d0,
     *    -36.00d0,
     *     61.00d0,    65.00d0,    59.00d0,  -178.00d0,     3.00d0,
     *     18.00d0,   -96.00d0,
     *     77.00d0,   -64.00d0,     2.00d0,    26.00d0,    -1.00d0,
     *      5.00d0,     9.00d0,     0.00d0,
     *     23.00d0,     5.00d0,    -1.00d0,   -10.00d0,   -12.00d0,
     *      3.00d0,     4.00d0,     2.00d0,    -6.00d0,
     *      4.00d0,     9.00d0,     1.00d0,   -12.00d0,     9.00d0,
     *     -4.00d0,    -2.00d0,     7.00d0,     1.00d0,    -6.00d0,
     *     -3.00d0,    -4.00d0,     2.00d0,    -5.00d0,    -2.00d0,
     *      4.00d0,     3.00d0,     1.00d0,     3.00d0,     3.00d0,
     *      0.00d0
     * /

       DATA H1990/
     *      0.00d0,
     *      0.00d0,  5406.00d0,
     *      0.00d0, -2279.00d0,  -373.00d0,
     *      0.00d0,  -284.00d0,   293.00d0,  -352.00d0,
     *      0.00d0,   247.00d0,  -240.00d0,    84.00d0,  -299.00d0,
     *      0.00d0,    46.00d0,   154.00d0,  -153.00d0,   -69.00d0,
     *     97.00d0,
     *      0.00d0,   -16.00d0,    82.00d0,    69.00d0,   -52.00d0,
     *      1.00d0,    24.00d0,
     *      0.00d0,   -80.00d0,   -26.00d0,     0.00d0,    21.00d0,
     *     17.00d0,   -23.00d0,    -4.00d0,
     *      0.00d0,    10.00d0,   -19.00d0,     6.00d0,   -22.00d0,
     *     12.00d0,    12.00d0,   -16.00d0,   -10.00d0,
     *      0.00d0,   -20.00d0,    15.00d0,    11.00d0,    -7.00d0,
     *     -7.00d0,     9.00d0,     8.00d0,    -7.00d0,     2.00d0,
     *      0.00d0,     2.00d0,     1.00d0,     3.00d0,     6.00d0,
     *     -4.00d0,     0.00d0,    -2.00d0,     3.00d0,    -1.00d0,
     *     -6.00d0
     * /
       DATA G1995/
     *      0.00d0,
     * -29692.00d0, -1784.00d0,
     *  -2200.00d0,  3070.00d0,  1681.00d0,
     *   1335.00d0, -2267.00d0,  1249.00d0,   759.00d0,
     *    940.00d0,   780.00d0,   290.00d0,  -418.00d0,   122.00d0,
     *   -214.00d0,   352.00d0,   235.00d0,  -118.00d0,  -166.00d0,
     *    -17.00d0,
     *     68.00d0,    67.00d0,    68.00d0,  -170.00d0,    -1.00d0,
     *     19.00d0,   -93.00d0,
     *     77.00d0,   -72.00d0,     1.00d0,    28.00d0,     5.00d0,
     *      4.00d0,     8.00d0,    -2.00d0,
     *     25.00d0,     6.00d0,    -6.00d0,    -9.00d0,   -14.00d0,
     *      9.00d0,     6.00d0,    -5.00d0,    -7.00d0,
     *      4.00d0,     9.00d0,     3.00d0,   -10.00d0,     8.00d0,
     *     -8.00d0,    -1.00d0,    10.00d0,    -2.00d0,    -8.00d0,
     *     -3.00d0,    -6.00d0,     2.00d0,    -4.00d0,    -1.00d0,
     *      4.00d0,     2.00d0,     2.00d0,     5.00d0,     1.00d0,
     *      0.00d0
     * /

       DATA H1995/
     *      0.00d0,
     *      0.00d0,  5306.00d0,
     *      0.00d0, -2366.00d0,  -413.00d0,
     *      0.00d0,  -262.00d0,   302.00d0,  -427.00d0,
     *      0.00d0,   262.00d0,  -236.00d0,    97.00d0,  -306.00d0,
     *      0.00d0,    46.00d0,   165.00d0,  -143.00d0,   -55.00d0,
     *    107.00d0,
     *      0.00d0,   -17.00d0,    72.00d0,    67.00d0,   -58.00d0,
     *      1.00d0,    36.00d0,
     *      0.00d0,   -69.00d0,   -25.00d0,     4.00d0,    24.00d0,
     *     17.00d0,   -24.00d0,    -6.00d0,
     *      0.00d0,    11.00d0,   -21.00d0,     8.00d0,   -23.00d0,
     *     15.00d0,    11.00d0,   -16.00d0,    -4.00d0,
     *      0.00d0,   -20.00d0,    15.00d0,    12.00d0,    -6.00d0,
     *     -8.00d0,     8.00d0,     5.00d0,    -8.00d0,     3.00d0,
     *      0.00d0,     1.00d0,     0.00d0,     4.00d0,     5.00d0,
     *     -5.00d0,    -1.00d0,    -2.00d0,     1.00d0,    -2.00d0,
     *     -7.00d0
     * /
       DATA G2000/
     *      0.00d0,
     * -29619.40d0, -1728.20d0,
     *  -2267.70d0,  3068.40d0,  1670.90d0,
     *   1339.60d0, -2288.00d0,  1252.10d0,   714.50d0,
     *    932.30d0,   786.80d0,   250.00d0,  -403.00d0,   111.30d0,
     *   -218.80d0,   351.40d0,   222.30d0,  -130.40d0,  -168.60d0,
     *    -12.90d0,
     *     72.30d0,    68.20d0,    74.20d0,  -160.90d0,    -5.90d0,
     *     16.90d0,   -90.40d0,
     *     79.00d0,   -74.00d0,     0.00d0,    33.30d0,     9.10d0,
     *      6.90d0,     7.30d0,    -1.20d0,
     *     24.40d0,     6.60d0,    -9.20d0,    -7.90d0,   -16.60d0,
     *      9.10d0,     7.00d0,    -7.90d0,    -7.00d0,
     *      5.00d0,     9.40d0,     3.00d0,    -8.40d0,     6.30d0,
     *     -8.90d0,    -1.50d0,     9.30d0,    -4.30d0,    -8.20d0,
     *     -2.60d0,    -6.00d0,     1.70d0,    -3.10d0,    -0.50d0,
     *      3.70d0,     1.00d0,     2.00d0,     4.20d0,     0.30d0,
     *     -1.10d0
     * /

       DATA H2000/
     *      0.00d0,
     *      0.00d0,  5186.10d0,
     *      0.00d0, -2481.60d0,  -458.00d0,
     *      0.00d0,  -227.60d0,   293.40d0,  -491.10d0,
     *      0.00d0,   272.60d0,  -231.90d0,   119.80d0,  -303.80d0,
     *      0.00d0,    43.80d0,   171.90d0,  -133.10d0,   -39.30d0,
     *    106.30d0,
     *      0.00d0,   -17.40d0,    63.70d0,    65.10d0,   -61.20d0,
     *      0.70d0,    43.80d0,
     *      0.00d0,   -64.60d0,   -24.20d0,     6.20d0,    24.00d0,
     *     14.80d0,   -25.40d0,    -5.80d0,
     *      0.00d0,    11.90d0,   -21.50d0,     8.50d0,   -21.50d0,
     *     15.50d0,     8.90d0,   -14.90d0,    -2.10d0,
     *      0.00d0,   -19.70d0,    13.40d0,    12.50d0,    -6.20d0,
     *     -8.40d0,     8.40d0,     3.80d0,    -8.20d0,     4.80d0,
     *      0.00d0,     1.70d0,     0.00d0,     4.00d0,     4.90d0,
     *     -5.90d0,    -1.20d0,    -2.90d0,     0.20d0,    -2.20d0,
     *     -7.40d0
     * /
       DATA G2005/
     *      0.00d0,
     * -29554.63d0, -1669.05d0,
     *  -2337.24d0,  3047.69d0,  1657.76d0,
     *   1336.30d0, -2305.83d0,  1246.39d0,   672.51d0,
     *    920.55d0,   797.96d0,   210.65d0,  -379.86d0,   100.00d0,
     *   -227.00d0,   354.41d0,   208.95d0,  -136.54d0,  -168.05d0,
     *    -13.55d0,
     *     73.60d0,    69.56d0,    76.74d0,  -151.34d0,   -14.58d0,
     *     14.58d0,   -86.36d0,
     *     79.88d0,   -74.46d0,    -1.65d0,    38.73d0,    12.30d0,
     *      9.37d0,     5.42d0,     1.94d0,
     *     24.80d0,     7.62d0,   -11.73d0,    -6.88d0,   -18.11d0,
     *     10.17d0,     9.36d0,   -11.25d0,    -4.87d0,
     *      5.58d0,     9.76d0,     3.58d0,    -6.94d0,     5.01d0,
     *    -10.76d0,    -1.25d0,     8.76d0,    -6.66d0,    -9.22d0,
     *     -2.17d0,    -6.12d0,     1.42d0,    -2.35d0,    -0.15d0,
     *      3.06d0,     0.29d0,     2.06d0,     3.77d0,    -0.21d0,
     *     -2.09d0
     * /

       DATA H2005/
     *      0.00d0,
     *      0.00d0,  5077.99d0,
     *      0.00d0, -2594.50d0,  -515.43d0,
     *      0.00d0,  -198.86d0,   269.72d0,  -524.72d0,
     *      0.00d0,   282.07d0,  -225.23d0,   145.15d0,  -305.36d0,
     *      0.00d0,    42.72d0,   180.25d0,  -123.45d0,   -19.57d0,
     *    103.85d0,
     *      0.00d0,   -20.33d0,    54.75d0,    63.63d0,   -63.53d0,
     *      0.24d0,    50.94d0,
     *      0.00d0,   -61.14d0,   -22.57d0,     6.82d0,    25.35d0,
     *     10.93d0,   -26.32d0,    -4.64d0,
     *      0.00d0,    11.20d0,   -20.88d0,     9.83d0,   -19.71d0,
     *     16.22d0,     7.61d0,   -12.76d0,    -0.06d0,
     *      0.00d0,   -20.11d0,    12.69d0,    12.67d0,    -6.72d0,
     *     -8.16d0,     8.10d0,     2.92d0,    -7.73d0,     6.01d0,
     *      0.00d0,     2.19d0,     0.10d0,     4.46d0,     4.76d0,
     *     -6.58d0,    -1.01d0,    -3.47d0,    -0.86d0,    -2.31d0,
     *     -7.93d0
     * /
       DATA G2010/
     *      0.00d0,
     * -29496.57d0, -1586.42d0,
     *  -2396.06d0,  3026.34d0,  1668.17d0,
     *   1339.85d0, -2326.54d0,  1232.10d0,   633.73d0,
     *    912.66d0,   808.97d0,   166.58d0,  -356.83d0,    89.40d0,
     *   -230.87d0,   357.29d0,   200.26d0,  -141.05d0,  -163.17d0,
     *     -8.03d0,
     *     72.78d0,    68.69d0,    75.92d0,  -141.40d0,   -22.83d0,
     *     13.10d0,   -78.09d0,
     *     80.44d0,   -75.00d0,    -4.55d0,    45.24d0,    14.00d0,
     *     10.46d0,     1.64d0,     4.92d0,
     *     24.41d0,     8.21d0,   -14.50d0,    -5.59d0,   -19.34d0,
     *     11.61d0,    10.85d0,   -14.05d0,    -3.54d0,
     *      5.50d0,     9.45d0,     3.45d0,    -5.27d0,     3.13d0,
     *    -12.38d0,    -0.76d0,     8.43d0,    -8.42d0,   -10.08d0,
     *     -1.94d0,    -6.24d0,     0.89d0,    -1.07d0,    -0.16d0,
     *      2.45d0,    -0.33d0,     2.13d0,     3.09d0,    -1.03d0,
     *     -2.80d0
     * /

       DATA H2010/
     *      0.00d0,
     *      0.00d0,  4944.26d0,
     *      0.00d0, -2708.54d0,  -575.73d0,
     *      0.00d0,  -160.40d0,   251.75d0,  -537.03d0,
     *      0.00d0,   286.48d0,  -211.03d0,   164.46d0,  -309.72d0,
     *      0.00d0,    44.58d0,   189.01d0,  -118.06d0,    -0.01d0,
     *    101.04d0,
     *      0.00d0,   -20.90d0,    44.18d0,    61.54d0,   -66.26d0,
     *      3.02d0,    55.40d0,
     *      0.00d0,   -57.80d0,   -21.20d0,     6.54d0,    24.96d0,
     *      7.03d0,   -27.61d0,    -3.28d0,
     *      0.00d0,    10.84d0,   -20.03d0,    11.83d0,   -17.41d0,
     *     16.71d0,     6.96d0,   -10.74d0,     1.64d0,
     *      0.00d0,   -20.54d0,    11.51d0,    12.75d0,    -7.14d0,
     *     -7.42d0,     7.97d0,     2.14d0,    -6.08d0,     7.01d0,
     *      0.00d0,     2.73d0,    -0.10d0,     4.71d0,     4.44d0,
     *     -7.22d0,    -0.96d0,    -3.95d0,    -1.99d0,    -1.97d0,
     *     -8.31d0
     * /
       DATA G2015/
     *      0.00d0,
     * -29441.46d0, -1501.77d0,
     *  -2445.88d0,  3012.20d0,  1676.35d0,
     *   1350.33d0, -2352.26d0,  1225.85d0,   581.69d0,
     *    907.42d0,   813.68d0,   120.49d0,  -334.85d0,    70.38d0,
     *   -232.91d0,   360.14d0,   192.35d0,  -140.94d0,  -157.40d0,
     *      4.30d0,
     *     69.55d0,    67.57d0,    72.79d0,  -129.85d0,   -28.93d0,
     *     13.14d0,   -70.85d0,
     *     81.29d0,   -75.99d0,    -6.79d0,    51.82d0,    15.07d0,
     *      9.32d0,    -2.88d0,     6.61d0,
     *     23.98d0,     8.89d0,   -16.78d0,    -3.16d0,   -20.56d0,
     *     13.33d0,    11.76d0,   -15.98d0,    -2.02d0,
     *      5.33d0,     8.83d0,     3.02d0,    -3.22d0,     0.67d0,
     *    -13.20d0,    -0.10d0,     8.68d0,    -9.06d0,   -10.54d0,
     *     -2.01d0,    -6.26d0,     0.17d0,     0.55d0,    -0.55d0,
     *      1.70d0,    -0.67d0,     2.13d0,     2.33d0,    -1.80d0,
     *     -3.59d0
     * /

       DATA H2015/
     *      0.00d0,
     *      0.00d0,  4795.99d0,
     *      0.00d0, -2845.41d0,  -642.17d0,
     *      0.00d0,  -115.29d0,   245.04d0,  -538.70d0,
     *      0.00d0,   283.54d0,  -188.43d0,   180.95d0,  -329.23d0,
     *      0.00d0,    46.98d0,   196.98d0,  -119.14d0,    15.98d0,
     *    100.12d0,
     *      0.00d0,   -20.61d0,    33.30d0,    58.74d0,   -66.64d0,
     *      7.35d0,    62.41d0,
     *      0.00d0,   -54.27d0,   -19.53d0,     5.59d0,    24.45d0,
     *      3.27d0,   -27.50d0,    -2.32d0,
     *      0.00d0,    10.04d0,   -18.26d0,    13.18d0,   -14.60d0,
     *     16.16d0,     5.69d0,    -9.10d0,     2.26d0,
     *      0.00d0,   -21.77d0,    10.76d0,    11.74d0,    -6.74d0,
     *     -6.88d0,     7.79d0,     1.04d0,    -3.89d0,     8.44d0,
     *      0.00d0,     3.28d0,    -0.40d0,     4.55d0,     4.40d0,
     *     -7.92d0,    -0.61d0,    -4.16d0,    -2.85d0,    -1.12d0,
     *     -8.72d0
     * /
       DATA G2020/
     *      0.00d0,
     * -29404.80d0, -1450.90d0,
     *  -2499.60d0,  2982.00d0,  1677.00d0,
     *   1363.20d0, -2381.20d0,  1236.20d0,   525.70d0,
     *    903.00d0,   809.50d0,    86.30d0,  -309.40d0,    48.00d0,
     *   -234.30d0,   363.20d0,   187.80d0,  -140.70d0,  -151.20d0,
     *     13.50d0,
     *     66.00d0,    65.50d0,    72.90d0,  -121.50d0,   -36.20d0,
     *     13.50d0,   -64.70d0,
     *     80.60d0,   -76.70d0,    -8.20d0,    56.50d0,    15.80d0,
     *      6.40d0,    -7.20d0,     9.80d0,
     *     23.70d0,     9.70d0,   -17.60d0,    -0.50d0,   -21.10d0,
     *     15.30d0,    13.70d0,   -16.50d0,    -0.30d0,
     *      5.00d0,     8.40d0,     2.90d0,    -1.50d0,    -1.10d0,
     *    -13.20d0,     1.10d0,     8.80d0,    -9.30d0,   -11.90d0,
     *     -1.90d0,    -6.20d0,    -0.10d0,     1.70d0,    -0.90d0,
     *      0.70d0,    -0.90d0,     1.90d0,     1.40d0,    -2.40d0,
     *     -3.80d0
     * /

       DATA H2020/
     *      0.00d0,
     *      0.00d0,  4652.50d0,
     *      0.00d0, -2991.60d0,  -734.60d0,
     *      0.00d0,   -82.10d0,   241.90d0,  -543.40d0,
     *      0.00d0,   281.90d0,  -158.40d0,   199.70d0,  -349.70d0,
     *      0.00d0,    47.70d0,   208.30d0,  -121.20d0,    32.30d0,
     *     98.90d0,
     *      0.00d0,   -19.10d0,    25.10d0,    52.80d0,   -64.50d0,
     *      8.90d0,    68.10d0,
     *      0.00d0,   -51.50d0,   -16.90d0,     2.20d0,    23.50d0,
     *     -2.20d0,   -27.20d0,    -1.80d0,
     *      0.00d0,     8.40d0,   -15.30d0,    12.80d0,   -11.70d0,
     *     14.90d0,     3.60d0,    -6.90d0,     2.80d0,
     *      0.00d0,   -23.40d0,    11.00d0,     9.80d0,    -5.10d0,
     *     -6.30d0,     7.80d0,     0.40d0,    -1.40d0,     9.60d0,
     *      0.00d0,     3.40d0,    -0.20d0,     3.60d0,     4.80d0,
     *     -8.60d0,    -0.10d0,    -4.30d0,    -3.40d0,    -0.10d0,
     *     -8.80d0
     * /
       DATA DG2020/
     *      0.00d0,
     *      5.70d0,     7.40d0,
     *    -11.00d0,    -7.00d0,    -2.10d0,
     *      2.20d0,    -5.90d0,     3.10d0,   -12.00d0,
     *     -1.20d0,    -1.60d0,    -5.90d0,     5.20d0,    -5.10d0,
     *     -0.30d0,     0.50d0,    -0.60d0,     0.20d0,     1.30d0,
     *      0.90d0,
     *     -0.50d0,    -0.30d0,     0.40d0,     1.30d0,    -1.40d0,
     *      0.00d0,     0.90d0,
     *     -0.10d0,    -0.20d0,     0.00d0,     0.70d0,     0.10d0,
     *     -0.50d0,    -0.80d0,     0.80d0,
     *      0.00d0,     0.10d0,    -0.10d0,     0.40d0,    -0.10d0,
     *      0.40d0,     0.30d0,    -0.10d0,     0.40d0
     * /

       DATA DH2020/
     *      0.00d0,
     *      0.00d0,   -25.90d0,
     *      0.00d0,   -30.20d0,   -22.40d0,
     *      0.00d0,     6.00d0,    -1.10d0,     0.50d0,
     *      0.00d0,    -0.10d0,     6.50d0,     3.60d0,    -5.00d0,
     *      0.00d0,     0.00d0,     2.50d0,    -0.60d0,     3.00d0,
     *      0.30d0,
     *      0.00d0,     0.00d0,    -1.60d0,    -1.30d0,     0.80d0,
     *      0.00d0,     1.00d0,
     *      0.00d0,     0.60d0,     0.60d0,    -0.80d0,    -0.20d0,
     *     -1.10d0,     0.10d0,     0.30d0,
     *      0.00d0,    -0.20d0,     0.60d0,    -0.20d0,     0.50d0,
     *     -0.30d0,    -0.40d0,     0.50d0,     0.00d0
     * /
       if ((year.lt.1900.d0).or.(year.gt.2025.d0)) then
         ierr=1
         if (year_error_reported .eq. 0) then
           write(*,999) year
           year_error_reported = 1
         endif
       endif
       if (year.lt.1905.d0) goto 1905  ! interpolate between  1900 - 1905
       if (year.lt.1910.d0) goto 1910  ! interpolate between  1905 - 1910
       if (year.lt.1915.d0) goto 1915  ! interpolate between  1910 - 1915
       if (year.lt.1920.d0) goto 1920  ! interpolate between  1915 - 1920
       if (year.lt.1925.d0) goto 1925  ! interpolate between  1920 - 1925
       if (year.lt.1930.d0) goto 1930  ! interpolate between  1925 - 1930
       if (year.lt.1935.d0) goto 1935  ! interpolate between  1930 - 1935
       if (year.lt.1940.d0) goto 1940  ! interpolate between  1935 - 1940
       if (year.lt.1945.d0) goto 1945  ! interpolate between  1940 - 1945
       if (year.lt.1950.d0) goto 1950  ! interpolate between  1945 - 1950
       if (year.lt.1955.d0) goto 1955  ! interpolate between  1950 - 1955
       if (year.lt.1960.d0) goto 1960  ! interpolate between  1955 - 1960
       if (year.lt.1965.d0) goto 1965  ! interpolate between  1960 - 1965
       if (year.lt.1970.d0) goto 1970  ! interpolate between  1965 - 1970
       if (year.lt.1975.d0) goto 1975  ! interpolate between  1970 - 1975
       if (year.lt.1980.d0) goto 1980  ! interpolate between  1975 - 1980
       if (year.lt.1985.d0) goto 1985  ! interpolate between  1980 - 1985
       if (year.lt.1990.d0) goto 1990  ! interpolate between  1985 - 1990
       if (year.lt.1995.d0) goto 1995  ! interpolate between  1990 - 1995
       if (year.lt.2000.d0) goto 2000  ! interpolate between  1995 - 2000
       if (year.lt.2005.d0) goto 2005  ! interpolate between  2000 - 2005
       if (year.lt.2010.d0) goto 2010  ! interpolate between  2005 - 2010
       if (year.lt.2015.d0) goto 2015  ! interpolate between  2010 - 2015
       if (year.lt.2020.d0) goto 2020  ! interpolate between  2015 - 2020
C
C EXTRAPOLATE BETWEEN 2020 -  2030
C
       DT=year-2020.D0
       if (DT.gt.10.D0) then
         DT = 10.D0 ! effectively  2030
       endif
       DO 40 N=1,66
         G(N)=G2020(N)
         H(N)=H2020(N)
         IF (N.GT.45) GOTO 40
         G(N)=G(N)+DG2020(N)*DT
         H(N)=H(N)+DH2020(N)*DT
40     CONTINUE
       GOTO 300
C
C
C INTERPOLATE BETWEEEN 1900 - 1905
C
1905  if (year.gt.1900.D0) then
         F2=(year-1900.D0)/5.D0
       else
         F2=0.D0 ! effectively 1900
       endif
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1900(N)*F1+G1905(N)*F2
         H(N)=H1900(N)*F1+H1905(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1905 - 1910
C
1910   F2=(year-1905.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1905(N)*F1+G1910(N)*F2
         H(N)=H1905(N)*F1+H1910(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1910 - 1915
C
1915   F2=(year-1910.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1910(N)*F1+G1915(N)*F2
         H(N)=H1910(N)*F1+H1915(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1915 - 1920
C
1920   F2=(year-1915.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1915(N)*F1+G1920(N)*F2
         H(N)=H1915(N)*F1+H1920(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1920 - 1925
C
1925   F2=(year-1920.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1920(N)*F1+G1925(N)*F2
         H(N)=H1920(N)*F1+H1925(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1925 - 1930
C
1930   F2=(year-1925.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1925(N)*F1+G1930(N)*F2
         H(N)=H1925(N)*F1+H1930(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1930 - 1935
C
1935   F2=(year-1930.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1930(N)*F1+G1935(N)*F2
         H(N)=H1930(N)*F1+H1935(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1935 - 1940
C
1940   F2=(year-1935.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1935(N)*F1+G1940(N)*F2
         H(N)=H1935(N)*F1+H1940(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1940 - 1945
C
1945   F2=(year-1940.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1940(N)*F1+G1945(N)*F2
         H(N)=H1940(N)*F1+H1945(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1945 - 1950
C
1950   F2=(year-1945.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1945(N)*F1+G1950(N)*F2
         H(N)=H1945(N)*F1+H1950(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1950 - 1955
C
1955   F2=(year-1950.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1950(N)*F1+G1955(N)*F2
         H(N)=H1950(N)*F1+H1955(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1955 - 1960
C
1960   F2=(year-1955.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1955(N)*F1+G1960(N)*F2
         H(N)=H1955(N)*F1+H1960(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1960 - 1965
C
1965   F2=(year-1960.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1960(N)*F1+G1965(N)*F2
         H(N)=H1960(N)*F1+H1965(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1965 - 1970
C
1970   F2=(year-1965.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1965(N)*F1+G1970(N)*F2
         H(N)=H1965(N)*F1+H1970(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1970 - 1975
C
1975   F2=(year-1970.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1970(N)*F1+G1975(N)*F2
         H(N)=H1970(N)*F1+H1975(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1975 - 1980
C
1980   F2=(year-1975.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1975(N)*F1+G1980(N)*F2
         H(N)=H1975(N)*F1+H1980(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1980 - 1985
C
1985   F2=(year-1980.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1980(N)*F1+G1985(N)*F2
         H(N)=H1980(N)*F1+H1985(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1985 - 1990
C
1990   F2=(year-1985.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1985(N)*F1+G1990(N)*F2
         H(N)=H1985(N)*F1+H1990(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1990 - 1995
C
1995   F2=(year-1990.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1990(N)*F1+G1995(N)*F2
         H(N)=H1990(N)*F1+H1995(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 1995 - 2000
C
2000   F2=(year-1995.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G1995(N)*F1+G2000(N)*F2
         H(N)=H1995(N)*F1+H2000(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 2000 - 2005
C
2005   F2=(year-2000.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G2000(N)*F1+G2005(N)*F2
         H(N)=H2000(N)*F1+H2005(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 2005 - 2010
C
2010   F2=(year-2005.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G2005(N)*F1+G2010(N)*F2
         H(N)=H2005(N)*F1+H2010(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 2010 - 2015
C
2015   F2=(year-2010.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G2010(N)*F1+G2015(N)*F2
         H(N)=H2010(N)*F1+H2015(N)*F2
       enddo
       GOTO 300
C
C
C INTERPOLATE BETWEEN 2015 - 2020
C
2020   F2=(year-2015.D0)/5.D0
       F1=1.D0-F2
       DO N=1,66
         G(N)=G2015(N)*F1+G2020(N)*F2
         H(N)=H2015(N)*F1+H2020(N)*F2
       enddo
       GOTO 300
C
C
300    continue
c
C
999    format(//1x,
     *   '*** WARNING -- Input year = ',F7.2,/
     *   ' is out of valid range 1900-2025 Using nearest ***'//)
c
       return
       end
