#!/usr/bin/env python

__author__ = "Christopher and Cody Reichert"
__copyright__ = "Copyright 2015, SimplyRETS Inc. <support@simplyrets.com>"
__credits__ = ["Christopher Reichert", "Cody Reichert"]
__license__ = "MIT"
__version__ = "0.1"
__maintainer__ = "Christopher Reichert"
__email__ = "christopher@simplyrets.com"
__status__ = "Production"

class Listing:
    """ NOTE: This class is auto generated by the SimplyRets code
              generator program.  Do not edit the class manually.
    """

    def __init__(self):
        self.simplyRetsTypes = {
            'property': 'Property',
            'mlsId': 'long',
            'showingInstructions': 'str',
            'office': 'Office',
            'disclaimer': 'str',
            'address': 'StreetAddress',
            'listDate': 'datetime',
            'agent': 'Agent',
            'modified': 'datetime',
            'school': 'School',
            'photos': 'list[str]',
            'listPrice': 'float',
            'listingId': 'str',
            'mls': 'MlsInformation',
            'geo': 'GeographicData',
            'tax': 'Tax',
            'remarks': 'str'

        }

        # Specific property data associated with listing.
        self.property = None # Property
        # A unique identifier for this listing specific to the SimplyRETS API.
        self.mlsId = None # long
        # Public instructions for showing the property.
        self.showingInstructions = None # str
        # Listing office or brokerage.
        self.office = None # Office
        # Data accuracy disclaimer. The value in the disclaimer may change depending on your MLS vendors rules.
        self.disclaimer = None # str
        # Comprehensive property address information
        self.address = None # StreetAddress
        # Date and time the listing became Active
        self.listDate = None # datetime
        # Comprehensive listing agent information
        self.agent = None # Agent
        # Date and time of the last modification
        self.modified = None # datetime
        # Comprehensive school zone data
        self.school = None # School
        # Photos of the property. Images are served over https and are suitable for production use on secure websites
        self.photos = None # list[str]
        # Price of the listing
        self.listPrice = None # float
        # Data Dictionary v1.3 ListingId. The well known identifier for the listing. The value may be identical to mlsId. However, listingId is intended to be the value used by a human to retrieve the information about a specific listing.
        self.listingId = None # str
        # MLS vendor information and data
        self.mls = None # MlsInformation
        # Geographic data for the listing
        self.geo = None # GeographicData
        # Associate tax data
        self.tax = None # Tax
        # Description or remarks
        self.remarks = None # str
