# -*- coding: utf-8 -*-
# pylint: disable=bad-whitespace
# flake8: noqa
"""
    GitHub Commander – A tool to access the GitHub APIv3
    from the CLI and automate otherwise tedious tasks.

    “GitHub Commander” implements the ``gh`` command line tool,
    which provides a ‘fluent’ interface using Click.
    It allows to access the GitHub API v3 from a shell
    prompt for things usually done in the browser, and also
    automates tasks that otherwise are tedious at best,
    when done by clicking around on a web page.


    Copyright ©  2015 Jürgen Hermann <jh@web.de>

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""
from __future__ import absolute_import, unicode_literals, print_function

__url__             = "https://github.com/jhermann/gh-commander"
__version__         = "0.1.0"
__license__         = "Apache 2.0"
__author__          = "Jürgen Hermann"
__author_email__    = "jh@web.de"
__keywords__        = "hosted.by.github github cli tool automation"

__all__ = []
