/*
 * Decompiled with CFR 0.152.
 */
package be.re.util;

import com.ibm.xml.omake.Regexp;

public class Substitute {
    public static String neutralizeMetaChars(String s) {
        String[] metaChars = new String[]{".", "*", "+", "?", "[", "]", "(", ")", "|", "\\"};
        String result = s;
        for (int i = 0; i < metaChars.length; ++i) {
            result = Substitute.substitute(result, new Regexp("\\" + metaChars[i]), "\\" + metaChars[i]);
        }
        return result;
    }

    public static String substitute(String s, Regexp regexp, String replacement) {
        int index = regexp.match(s);
        if (index == -1) {
            return s;
        }
        int matchedLength = regexp.getMatchedString(0).length();
        return s.substring(0, index) + Substitute.substituteReplacement(regexp, replacement) + (index + matchedLength < s.length() ? Substitute.substitute(s.substring(index + matchedLength), regexp, replacement) : "");
    }

    private static String substituteReplacement(Regexp regexp, String replacement) {
        int groups = regexp.getNumberOfGroups();
        String result = replacement;
        for (int i = 0; i < groups; ++i) {
            result = Substitute.substitute(result, new Regexp("\\\\" + String.valueOf(i)), regexp.getMatchedString(i).replace('\\', '\u0007'));
        }
        return result.replace('\u0007', '\\');
    }
}

