/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.InternedElementSelector;
import be.re.css.Property;
import be.re.css.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public class Rule {
    private Property[] cachedArray = null;
    private String elementName;
    private int position;
    private Map properties = new HashMap();
    private String pseudoElementName;
    private Selector selector;
    private Selector[] selectorChain;
    private int specificity;

    Rule(Selector selector, int position, int offset) {
        this.selector = selector instanceof ElementSelector ? new InternedElementSelector((ElementSelector)selector) : selector;
        this.position = position;
        this.selectorChain = Util.getSelectorChain(selector);
        this.specificity = this.specificity() + offset * 10000000;
        this.elementName = Rule.getElementName(this.selectorChain, this.selectorChain.length - 1);
        this.pseudoElementName = Rule.getPseudoElementName(this.selectorChain);
        if (this.elementName != null) {
            this.elementName = this.elementName.intern();
        }
        if (this.pseudoElementName != null) {
            this.pseudoElementName = this.pseudoElementName.intern();
        }
    }

    private Rule(Rule source, int position) {
        this.selector = source.selector;
        this.position = position;
        this.elementName = source.elementName;
        this.pseudoElementName = source.pseudoElementName;
        this.selectorChain = source.selectorChain;
        this.specificity = source.specificity;
    }

    void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public String getElementName() {
        return this.elementName;
    }

    private static String getElementName(Selector[] selectorChain, int position) {
        switch (selectorChain[position].getSelectorType()) {
            case 4: {
                return ((ElementSelector)selectorChain[position]).getLocalName();
            }
            case 9: {
                return Rule.getElementName(selectorChain, position - 1);
            }
        }
        return null;
    }

    int getPosition() {
        return this.position;
    }

    Property[] getProperties() {
        if (this.cachedArray == null || this.cachedArray.length != this.properties.size()) {
            this.cachedArray = this.properties.values().toArray(new Property[this.properties.size()]);
        }
        return this.cachedArray;
    }

    public Property getProperty() {
        Property[] result = this.getProperties();
        if (result.length != 1) {
            throw new RuntimeException("Unsplit rule");
        }
        return result[0];
    }

    private static void getPseudoClassConditions(Condition c, List result) {
        if (c.getConditionType() == 10) {
            result.add(((AttributeCondition)c).getValue());
        } else if (c.getConditionType() == 0) {
            Rule.getPseudoClassConditions(((CombinatorCondition)c).getFirstCondition(), result);
            Rule.getPseudoClassConditions(((CombinatorCondition)c).getSecondCondition(), result);
        }
    }

    public String getPseudoElementName() {
        return this.pseudoElementName;
    }

    private static String getPseudoElementName(Selector[] selectorChain) {
        if (selectorChain[selectorChain.length - 1].getSelectorType() == 9) {
            return ((ElementSelector)selectorChain[selectorChain.length - 1]).getLocalName();
        }
        if (selectorChain.length > 1 && selectorChain[selectorChain.length - 2].getSelectorType() == 0) {
            ArrayList conditions = new ArrayList();
            Rule.getPseudoClassConditions(((ConditionalSelector)selectorChain[selectorChain.length - 2]).getCondition(), conditions);
            return conditions.contains("before") ? "before" : (conditions.contains("after") ? "after" : (conditions.contains("first-line") ? "first-line" : null));
        }
        return null;
    }

    public Selector getSelector() {
        return this.selector;
    }

    Selector[] getSelectorChain() {
        return this.selectorChain;
    }

    int getSpecificity() {
        return this.specificity;
    }

    private int specificity() {
        Specificity s = new Specificity();
        Rule.specificity(this.selector, s);
        return 10000 * s.ids + 100 * s.attributes + s.names;
    }

    private static void specificity(Selector selector, Specificity s) {
        if (selector instanceof ConditionalSelector) {
            Rule.specificity(((ConditionalSelector)selector).getCondition(), s);
            Rule.specificity(((ConditionalSelector)selector).getSimpleSelector(), s);
        } else if (selector instanceof DescendantSelector) {
            Rule.specificity(((DescendantSelector)selector).getAncestorSelector(), s);
            Rule.specificity(((DescendantSelector)selector).getSimpleSelector(), s);
        } else if (selector instanceof NegativeSelector) {
            Rule.specificity(((NegativeSelector)selector).getSimpleSelector(), s);
        } else if (selector instanceof SiblingSelector) {
            Rule.specificity(((SiblingSelector)selector).getSelector(), s);
            Rule.specificity(((SiblingSelector)selector).getSiblingSelector(), s);
        } else if (selector.getSelectorType() == 4 && ((ElementSelector)selector).getLocalName() != null) {
            ++s.names;
        }
    }

    private static void specificity(Condition c, Specificity s) {
        switch (c.getConditionType()) {
            case 5: {
                ++s.ids;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                ++s.attributes;
                break;
            }
            case 0: 
            case 1: {
                Rule.specificity(((CombinatorCondition)c).getFirstCondition(), s);
                Rule.specificity(((CombinatorCondition)c).getSecondCondition(), s);
            }
        }
        if (c.getConditionType() == 3 && ((PositionalCondition)c).getPosition() == 1) {
            ++s.attributes;
        }
    }

    Rule[] split() {
        Rule[] result = new Rule[this.getProperties().length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Rule(this, this.getPosition());
            result[i].addProperty(this.getProperties()[i]);
        }
        return result;
    }

    private static class Specificity {
        private int attributes;
        private int ids;
        private int names;

        private Specificity() {
        }
    }
}

