# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AccessUri(Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    """

    _validation = {
        'access_sas': {'readonly': True},
    }

    _attribute_map = {
        'access_sas': {'key': 'accessSAS', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AccessUri, self).__init__(**kwargs)
        self.access_sas = None


class ApiError(Model):
    """Api error.

    :param details: The Api error details
    :type details: list[~azure.mgmt.compute.v2019_11_01.models.ApiErrorBase]
    :param innererror: The Api inner error
    :type innererror: ~azure.mgmt.compute.v2019_11_01.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, details=None, innererror=None, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class CloudError(Model):
    """An error response from the Compute service.

    :param error:
    :type error: ~azure.mgmt.compute.v2019_11_01.models.ApiError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CreationData(Model):
    """Data used when creating a disk.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param create_option: Required. This enumerates the possible sources of a
     disk's creation. Possible values include: 'Empty', 'Attach', 'FromImage',
     'Import', 'Copy', 'Restore', 'Upload'
    :type create_option: str or
     ~azure.mgmt.compute.v2019_11_01.models.DiskCreateOption
    :param storage_account_id: Required if createOption is Import. The Azure
     Resource Manager identifier of the storage account containing the blob to
     import as a disk.
    :type storage_account_id: str
    :param image_reference: Disk source information.
    :type image_reference:
     ~azure.mgmt.compute.v2019_11_01.models.ImageDiskReference
    :param gallery_image_reference: Required if creating from a Gallery Image.
     The id of the ImageDiskReference will be the ARM id of the shared galley
     image version from which to create a disk.
    :type gallery_image_reference:
     ~azure.mgmt.compute.v2019_11_01.models.ImageDiskReference
    :param source_uri: If createOption is Import, this is the URI of a blob to
     be imported into a managed disk.
    :type source_uri: str
    :param source_resource_id: If createOption is Copy, this is the ARM id of
     the source snapshot or disk.
    :type source_resource_id: str
    :ivar source_unique_id: If this field is set, this is the unique id
     identifying the source of this resource.
    :vartype source_unique_id: str
    :param upload_size_bytes: If createOption is Upload, this is the size of
     the contents of the upload including the VHD footer. This value should be
     between 20972032 (20 MiB + 512 bytes for the VHD footer) and
     35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
    :type upload_size_bytes: long
    """

    _validation = {
        'create_option': {'required': True},
        'source_unique_id': {'readonly': True},
    }

    _attribute_map = {
        'create_option': {'key': 'createOption', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'image_reference': {'key': 'imageReference', 'type': 'ImageDiskReference'},
        'gallery_image_reference': {'key': 'galleryImageReference', 'type': 'ImageDiskReference'},
        'source_uri': {'key': 'sourceUri', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'source_unique_id': {'key': 'sourceUniqueId', 'type': 'str'},
        'upload_size_bytes': {'key': 'uploadSizeBytes', 'type': 'long'},
    }

    def __init__(self, *, create_option, storage_account_id: str=None, image_reference=None, gallery_image_reference=None, source_uri: str=None, source_resource_id: str=None, upload_size_bytes: int=None, **kwargs) -> None:
        super(CreationData, self).__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.gallery_image_reference = gallery_image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id
        self.source_unique_id = None
        self.upload_size_bytes = upload_size_bytes


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Disk(Resource):
    """Disk resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar managed_by: A relative URI containing the ID of the VM that has the
     disk attached.
    :vartype managed_by: str
    :ivar managed_by_extended: List of relative URIs containing the IDs of the
     VMs that have the disk attached. maxShares should be set to a value
     greater than one for disks to allow attaching them to multiple VMs.
    :vartype managed_by_extended: list[str]
    :param sku:
    :type sku: ~azure.mgmt.compute.v2019_11_01.models.DiskSku
    :param zones: The Logical zone list for Disk.
    :type zones: list[str]
    :ivar time_created: The time when the disk was created.
    :vartype time_created: datetime
    :param os_type: The Operating System type. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2019_11_01.models.OperatingSystemTypes
    :param hyper_vgeneration: The hypervisor generation of the Virtual
     Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'
    :type hyper_vgeneration: str or
     ~azure.mgmt.compute.v2019_11_01.models.HyperVGeneration
    :param creation_data: Required. Disk source information. CreationData
     information cannot be changed after the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2019_11_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is
     mandatory and it indicates the size of the disk to create. If this field
     is present for updates or creation with other options, it indicates a
     resize. Resizes are only allowed if the disk is not attached to a running
     VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read
     only.
    :vartype disk_size_bytes: long
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :param encryption_settings_collection: Encryption settings collection used
     for Azure Disk Encryption, can contain multiple encryption settings per
     disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2019_11_01.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :param disk_iops_read_write: The number of IOPS allowed for this disk;
     only settable for UltraSSD disks. One operation can transfer between 4k
     and 256k bytes.
    :type disk_iops_read_write: long
    :param disk_mbps_read_write: The bandwidth allowed for this disk; only
     settable for UltraSSD disks. MBps means millions of bytes per second - MB
     here uses the ISO notation, of powers of 10.
    :type disk_mbps_read_write: long
    :param disk_iops_read_only: The total number of IOPS that will be allowed
     across all VMs mounting the shared disk as ReadOnly. One operation can
     transfer between 4k and 256k bytes.
    :type disk_iops_read_only: long
    :param disk_mbps_read_only: The total throughput (MBps) that will be
     allowed across all VMs mounting the shared disk as ReadOnly. MBps means
     millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :type disk_mbps_read_only: long
    :ivar disk_state: The state of the disk. Possible values include:
     'Unattached', 'Attached', 'Reserved', 'ActiveSAS', 'ReadyToUpload',
     'ActiveUpload'
    :vartype disk_state: str or
     ~azure.mgmt.compute.v2019_11_01.models.DiskState
    :param encryption: Encryption property can be used to encrypt data at rest
     with customer managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2019_11_01.models.Encryption
    :param max_shares: The maximum number of VMs that can attach to the disk
     at the same time. Value greater than one indicates a disk that can be
     mounted on multiple VMs at the same time.
    :type max_shares: int
    :ivar share_info: Details of the list of all VMs that have the disk
     attached. maxShares should be set to a value greater than one for disks to
     allow attaching them to multiple VMs.
    :vartype share_info:
     list[~azure.mgmt.compute.v2019_11_01.models.ShareInfoElement]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'managed_by_extended': {'readonly': True},
        'time_created': {'readonly': True},
        'creation_data': {'required': True},
        'disk_size_bytes': {'readonly': True},
        'unique_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'disk_state': {'readonly': True},
        'share_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'managed_by_extended': {'key': 'managedByExtended', 'type': '[str]'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'hyper_vgeneration': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'disk_size_bytes': {'key': 'properties.diskSizeBytes', 'type': 'long'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'disk_iops_read_write': {'key': 'properties.diskIOPSReadWrite', 'type': 'long'},
        'disk_mbps_read_write': {'key': 'properties.diskMBpsReadWrite', 'type': 'long'},
        'disk_iops_read_only': {'key': 'properties.diskIOPSReadOnly', 'type': 'long'},
        'disk_mbps_read_only': {'key': 'properties.diskMBpsReadOnly', 'type': 'long'},
        'disk_state': {'key': 'properties.diskState', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'max_shares': {'key': 'properties.maxShares', 'type': 'int'},
        'share_info': {'key': 'properties.shareInfo', 'type': '[ShareInfoElement]'},
    }

    def __init__(self, *, location: str, creation_data, tags=None, sku=None, zones=None, os_type=None, hyper_vgeneration=None, disk_size_gb: int=None, encryption_settings_collection=None, disk_iops_read_write: int=None, disk_mbps_read_write: int=None, disk_iops_read_only: int=None, disk_mbps_read_only: int=None, encryption=None, max_shares: int=None, **kwargs) -> None:
        super(Disk, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.managed_by_extended = None
        self.sku = sku
        self.zones = zones
        self.time_created = None
        self.os_type = os_type
        self.hyper_vgeneration = hyper_vgeneration
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_mbps_read_write = disk_mbps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_mbps_read_only = disk_mbps_read_only
        self.disk_state = None
        self.encryption = encryption
        self.max_shares = max_shares
        self.share_info = None


class DiskEncryptionSet(Resource):
    """disk encryption set resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~azure.mgmt.compute.v2019_11_01.models.EncryptionSetIdentity
    :param active_key: The key vault key which is currently used by this disk
     encryption set.
    :type active_key:
     ~azure.mgmt.compute.v2019_11_01.models.KeyVaultAndKeyReference
    :ivar previous_keys: A readonly collection of key vault keys previously
     used by this disk encryption set while a key rotation is in progress. It
     will be empty if there is no ongoing key rotation.
    :vartype previous_keys:
     list[~azure.mgmt.compute.v2019_11_01.models.KeyVaultAndKeyReference]
    :ivar provisioning_state: The disk encryption set provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'previous_keys': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'EncryptionSetIdentity'},
        'active_key': {'key': 'properties.activeKey', 'type': 'KeyVaultAndKeyReference'},
        'previous_keys': {'key': 'properties.previousKeys', 'type': '[KeyVaultAndKeyReference]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, identity=None, active_key=None, **kwargs) -> None:
        super(DiskEncryptionSet, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.active_key = active_key
        self.previous_keys = None
        self.provisioning_state = None


class DiskEncryptionSetUpdate(Model):
    """disk encryption set update resource.

    :param active_key:
    :type active_key:
     ~azure.mgmt.compute.v2019_11_01.models.KeyVaultAndKeyReference
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'active_key': {'key': 'properties.activeKey', 'type': 'KeyVaultAndKeyReference'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, active_key=None, tags=None, **kwargs) -> None:
        super(DiskEncryptionSetUpdate, self).__init__(**kwargs)
        self.active_key = active_key
        self.tags = tags


class DiskSku(Model):
    """The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, or
    UltraSSD_LRS.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The sku name. Possible values include: 'Standard_LRS',
     'Premium_LRS', 'StandardSSD_LRS', 'UltraSSD_LRS'
    :type name: str or
     ~azure.mgmt.compute.v2019_11_01.models.DiskStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(DiskSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class DiskUpdate(Model):
    """Disk update resource.

    :param os_type: the Operating System type. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2019_11_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is
     mandatory and it indicates the size of the disk to create. If this field
     is present for updates or creation with other options, it indicates a
     resize. Resizes are only allowed if the disk is not attached to a running
     VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings_collection: Encryption settings collection used
     be Azure Disk Encryption, can contain multiple encryption settings per
     disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2019_11_01.models.EncryptionSettingsCollection
    :param disk_iops_read_write: The number of IOPS allowed for this disk;
     only settable for UltraSSD disks. One operation can transfer between 4k
     and 256k bytes.
    :type disk_iops_read_write: long
    :param disk_mbps_read_write: The bandwidth allowed for this disk; only
     settable for UltraSSD disks. MBps means millions of bytes per second - MB
     here uses the ISO notation, of powers of 10.
    :type disk_mbps_read_write: long
    :param disk_iops_read_only: The total number of IOPS that will be allowed
     across all VMs mounting the shared disk as ReadOnly. One operation can
     transfer between 4k and 256k bytes.
    :type disk_iops_read_only: long
    :param disk_mbps_read_only: The total throughput (MBps) that will be
     allowed across all VMs mounting the shared disk as ReadOnly. MBps means
     millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :type disk_mbps_read_only: long
    :param max_shares: The maximum number of VMs that can attach to the disk
     at the same time. Value greater than one indicates a disk that can be
     mounted on multiple VMs at the same time.
    :type max_shares: int
    :param encryption: Encryption property can be used to encrypt data at rest
     with customer managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2019_11_01.models.Encryption
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku:
    :type sku: ~azure.mgmt.compute.v2019_11_01.models.DiskSku
    """

    _attribute_map = {
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'disk_iops_read_write': {'key': 'properties.diskIOPSReadWrite', 'type': 'long'},
        'disk_mbps_read_write': {'key': 'properties.diskMBpsReadWrite', 'type': 'long'},
        'disk_iops_read_only': {'key': 'properties.diskIOPSReadOnly', 'type': 'long'},
        'disk_mbps_read_only': {'key': 'properties.diskMBpsReadOnly', 'type': 'long'},
        'max_shares': {'key': 'properties.maxShares', 'type': 'int'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
    }

    def __init__(self, *, os_type=None, disk_size_gb: int=None, encryption_settings_collection=None, disk_iops_read_write: int=None, disk_mbps_read_write: int=None, disk_iops_read_only: int=None, disk_mbps_read_only: int=None, max_shares: int=None, encryption=None, tags=None, sku=None, **kwargs) -> None:
        super(DiskUpdate, self).__init__(**kwargs)
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_mbps_read_write = disk_mbps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_mbps_read_only = disk_mbps_read_only
        self.max_shares = max_shares
        self.encryption = encryption
        self.tags = tags
        self.sku = sku


class Encryption(Model):
    """Encryption at rest settings for disk or snapshot.

    :param disk_encryption_set_id: ResourceId of the disk encryption set to
     use for enabling encryption at rest.
    :type disk_encryption_set_id: str
    :param type: The type of key used to encrypt the data of the disk.
     Possible values include: 'EncryptionAtRestWithPlatformKey',
     'EncryptionAtRestWithCustomerKey'
    :type type: str or ~azure.mgmt.compute.v2019_11_01.models.EncryptionType
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, disk_encryption_set_id: str=None, type=None, **kwargs) -> None:
        super(Encryption, self).__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id
        self.type = type


class EncryptionSetIdentity(Model):
    """The managed identity for the disk encryption set. It should be given
    permission on the key vault before it can be used to encrypt disks.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: The type of Managed Identity used by the DiskEncryptionSet.
     Only SystemAssigned is supported. Possible values include:
     'SystemAssigned'
    :type type: str or
     ~azure.mgmt.compute.v2019_11_01.models.DiskEncryptionSetIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This
     will be sent to the RP from ARM via the x-ms-identity-principal-id header
     in the PUT request if the resource has a systemAssigned(implicit) identity
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will
     be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT
     request if the resource has a systemAssigned(implicit) identity
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(EncryptionSetIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class EncryptionSettingsCollection(Model):
    """Encryption settings for disk or snapshot.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Set this flag to true and provide
     DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set
     this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to
     disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged.
    :type enabled: bool
    :param encryption_settings: A collection of encryption settings, one for
     each disk volume.
    :type encryption_settings:
     list[~azure.mgmt.compute.v2019_11_01.models.EncryptionSettingsElement]
    :param encryption_settings_version: Describes what type of encryption is
     used for the disks. Once this field is set, it cannot be overwritten.
     '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds
     to Azure Disk Encryption.
    :type encryption_settings_version: str
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': '[EncryptionSettingsElement]'},
        'encryption_settings_version': {'key': 'encryptionSettingsVersion', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool, encryption_settings=None, encryption_settings_version: str=None, **kwargs) -> None:
        super(EncryptionSettingsCollection, self).__init__(**kwargs)
        self.enabled = enabled
        self.encryption_settings = encryption_settings
        self.encryption_settings_version = encryption_settings_version


class EncryptionSettingsElement(Model):
    """Encryption settings for one disk volume.

    :param disk_encryption_key: Key Vault Secret Url and vault id of the disk
     encryption key
    :type disk_encryption_key:
     ~azure.mgmt.compute.v2019_11_01.models.KeyVaultAndSecretReference
    :param key_encryption_key: Key Vault Key Url and vault id of the key
     encryption key. KeyEncryptionKey is optional and when provided is used to
     unwrap the disk encryption key.
    :type key_encryption_key:
     ~azure.mgmt.compute.v2019_11_01.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultAndSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultAndKeyReference'},
    }

    def __init__(self, *, disk_encryption_key=None, key_encryption_key=None, **kwargs) -> None:
        super(EncryptionSettingsElement, self).__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key


class GrantAccessData(Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to Azure.

    :param access: Required. Possible values include: 'None', 'Read', 'Write'
    :type access: str or ~azure.mgmt.compute.v2019_11_01.models.AccessLevel
    :param duration_in_seconds: Required. Time duration in seconds until the
     SAS access expires.
    :type duration_in_seconds: int
    """

    _validation = {
        'access': {'required': True},
        'duration_in_seconds': {'required': True},
    }

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'int'},
    }

    def __init__(self, *, access, duration_in_seconds: int, **kwargs) -> None:
        super(GrantAccessData, self).__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds


class ImageDiskReference(Model):
    """The source image used for creating the disk.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A relative uri containing either a Platform Image
     Repository or user image reference.
    :type id: str
    :param lun: If the disk is created from an image's data disk, this is an
     index that indicates which of the data disks in the image to use. For OS
     disks, this field is null.
    :type lun: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(self, *, id: str, lun: int=None, **kwargs) -> None:
        super(ImageDiskReference, self).__init__(**kwargs)
        self.id = id
        self.lun = lun


class InnerError(Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(self, *, exceptiontype: str=None, errordetail: str=None, **kwargs) -> None:
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class KeyVaultAndKeyReference(Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is
    used to unwrap the encryptionKey.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the
     key or secret
    :type source_vault: ~azure.mgmt.compute.v2019_11_01.models.SourceVault
    :param key_url: Required. Url pointing to a key or secret in KeyVault
    :type key_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'key_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'key_url': {'key': 'keyUrl', 'type': 'str'},
    }

    def __init__(self, *, source_vault, key_url: str, **kwargs) -> None:
        super(KeyVaultAndKeyReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndSecretReference(Model):
    """Key Vault Secret Url and vault id of the encryption key .

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the
     key or secret
    :type source_vault: ~azure.mgmt.compute.v2019_11_01.models.SourceVault
    :param secret_url: Required. Url pointing to a key or secret in KeyVault
    :type secret_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'secret_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
    }

    def __init__(self, *, source_vault, secret_url: str, **kwargs) -> None:
        super(KeyVaultAndSecretReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class ShareInfoElement(Model):
    """ShareInfoElement.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar vm_uri: A relative URI containing the ID of the VM that has the disk
     attached.
    :vartype vm_uri: str
    """

    _validation = {
        'vm_uri': {'readonly': True},
    }

    _attribute_map = {
        'vm_uri': {'key': 'vmUri', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ShareInfoElement, self).__init__(**kwargs)
        self.vm_uri = None


class Snapshot(Resource):
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar managed_by: Unused. Always Null.
    :vartype managed_by: str
    :param sku:
    :type sku: ~azure.mgmt.compute.v2019_11_01.models.SnapshotSku
    :ivar time_created: The time when the disk was created.
    :vartype time_created: datetime
    :param os_type: The Operating System type. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2019_11_01.models.OperatingSystemTypes
    :param hyper_vgeneration: The hypervisor generation of the Virtual
     Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'
    :type hyper_vgeneration: str or
     ~azure.mgmt.compute.v2019_11_01.models.HyperVGeneration
    :param creation_data: Required. Disk source information. CreationData
     information cannot be changed after the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2019_11_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is
     mandatory and it indicates the size of the disk to create. If this field
     is present for updates or creation with other options, it indicates a
     resize. Resizes are only allowed if the disk is not attached to a running
     VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read
     only.
    :vartype disk_size_bytes: long
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :param encryption_settings_collection: Encryption settings collection used
     be Azure Disk Encryption, can contain multiple encryption settings per
     disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2019_11_01.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :param incremental: Whether a snapshot is incremental. Incremental
     snapshots on the same disk occupy less space than full snapshots and can
     be diffed.
    :type incremental: bool
    :param encryption: Encryption property can be used to encrypt data at rest
     with customer managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2019_11_01.models.Encryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'time_created': {'readonly': True},
        'creation_data': {'required': True},
        'disk_size_bytes': {'readonly': True},
        'unique_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'hyper_vgeneration': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'disk_size_bytes': {'key': 'properties.diskSizeBytes', 'type': 'long'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'incremental': {'key': 'properties.incremental', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
    }

    def __init__(self, *, location: str, creation_data, tags=None, sku=None, os_type=None, hyper_vgeneration=None, disk_size_gb: int=None, encryption_settings_collection=None, incremental: bool=None, encryption=None, **kwargs) -> None:
        super(Snapshot, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.sku = sku
        self.time_created = None
        self.os_type = os_type
        self.hyper_vgeneration = hyper_vgeneration
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.incremental = incremental
        self.encryption = encryption


class SnapshotSku(Model):
    """The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The sku name. Possible values include: 'Standard_LRS',
     'Premium_LRS', 'Standard_ZRS'
    :type name: str or
     ~azure.mgmt.compute.v2019_11_01.models.SnapshotStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(SnapshotSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class SnapshotUpdate(Model):
    """Snapshot update resource.

    :param os_type: the Operating System type. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2019_11_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is
     mandatory and it indicates the size of the disk to create. If this field
     is present for updates or creation with other options, it indicates a
     resize. Resizes are only allowed if the disk is not attached to a running
     VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings_collection: Encryption settings collection used
     be Azure Disk Encryption, can contain multiple encryption settings per
     disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2019_11_01.models.EncryptionSettingsCollection
    :param encryption: Encryption property can be used to encrypt data at rest
     with customer managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2019_11_01.models.Encryption
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku:
    :type sku: ~azure.mgmt.compute.v2019_11_01.models.SnapshotSku
    """

    _attribute_map = {
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
    }

    def __init__(self, *, os_type=None, disk_size_gb: int=None, encryption_settings_collection=None, encryption=None, tags=None, sku=None, **kwargs) -> None:
        super(SnapshotUpdate, self).__init__(**kwargs)
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.encryption = encryption
        self.tags = tags
        self.sku = sku


class SourceVault(Model):
    """The vault id is an Azure Resource Manager Resource id in the form
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :param id: Resource Id
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(SourceVault, self).__init__(**kwargs)
        self.id = id
