/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Util;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class CenterFilter
extends XMLFilterImpl {
    private Stack stack = new Stack();

    CenterFilter() {
    }

    CenterFilter(XMLReader parent) {
        super(parent);
    }

    private void column(String width) throws SAXException {
        AttributesImpl atts = CenterFilter.displayType("table-column");
        if (width != null) {
            atts.addAttribute(Constants.CSS, "width", "css:width", "CDATA", width);
        }
        super.startElement(Constants.CSS, "table-column", "css:table-column", atts);
        super.endElement(Constants.CSS, "table-column", "css:table-column");
    }

    private static AttributesImpl displayType(String type) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(Constants.CSS, "display", "css:display", "CDATA", type);
        return atts;
    }

    private void emptyCell() throws SAXException {
        super.startElement(Constants.CSS, "table-cell", "css:table-cell", CenterFilter.displayType("table-cell"));
        super.endElement(Constants.CSS, "table-cell", "css:table-cell");
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (((Boolean)this.stack.pop()).booleanValue()) {
            super.endElement(Constants.CSS, "table-cell", "css:table-cell");
            this.emptyCell();
            super.endElement(Constants.CSS, "table-row", "css:table-row");
            super.endElement(Constants.CSS, "table-row-group", "css:table-row-group");
            super.endElement(Constants.CSS, "table", "css:table");
        }
    }

    private void generateTable(Attributes atts) throws SAXException {
        AttributesImpl tableAtts = CenterFilter.displayType("table");
        Util.copyAttribute(atts, tableAtts, Constants.CSS, "margin-bottom");
        Util.copyAttribute(atts, tableAtts, Constants.CSS, "margin-top");
        tableAtts.addAttribute(Constants.CSS, "table-layout", "css:table-layout", "CDATA", "fixed");
        super.startElement(Constants.CSS, "table", "css:table", tableAtts);
        this.column("1*");
        this.column(atts.getValue(Constants.CSS, "width"));
        this.column("1*");
        super.startElement(Constants.CSS, "table-row-group", "css:table-row-group", CenterFilter.displayType("table-row-group"));
        super.startElement(Constants.CSS, "table-row", "css:table-row", CenterFilter.displayType("table-row"));
        this.emptyCell();
        super.startElement(Constants.CSS, "table-cell", "css:table-cell", CenterFilter.displayType("table-cell"));
    }

    private static boolean shouldCenter(Attributes atts) {
        return "auto".equals(atts.getValue(Constants.CSS, "margin-left")) && "auto".equals(atts.getValue(Constants.CSS, "margin-right"));
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String display = atts.getValue(Constants.CSS, "display");
        boolean extra = false;
        if (("block".equals(display) || "table".equals(display)) && CenterFilter.shouldCenter(atts)) {
            extra = true;
            this.generateTable(atts);
            atts = new AttributesImpl(atts);
            Util.removeAttribute((AttributesImpl)atts, Constants.CSS, "margin-bottom");
            Util.removeAttribute((AttributesImpl)atts, Constants.CSS, "margin-top");
            Util.removeAttribute((AttributesImpl)atts, Constants.CSS, "margin-left");
            Util.removeAttribute((AttributesImpl)atts, Constants.CSS, "margin-right");
            Util.setAttribute((AttributesImpl)atts, Constants.CSS, "width", "css:width", "100%");
        }
        this.stack.push(new Boolean(extra));
        super.startElement(namespaceURI, localName, qName, atts);
    }
}

