# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._attestation_client_enums import *


class AttestationCertificateManagementBody(msrest.serialization.Model):
    """The body of the JWT used for the PolicyCertificates APIs.

    :param policy_certificate: RFC 7517 Json Web Key describing the certificate.
    :type policy_certificate: ~azure.security.attestation.models.JSONWebKey
    """

    _attribute_map = {
        'policy_certificate': {'key': 'policyCertificate', 'type': 'JSONWebKey'},
    }

    def __init__(
        self,
        *,
        policy_certificate: Optional["JSONWebKey"] = None,
        **kwargs
    ):
        super(AttestationCertificateManagementBody, self).__init__(**kwargs)
        self.policy_certificate = policy_certificate


class AttestationResponse(msrest.serialization.Model):
    """The result of an attestation operation.

    :param token: An RFC 7519 JSON Web Token, the body of which is an AttestationResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(AttestationResponse, self).__init__(**kwargs)
        self.token = token


class AttestationResult(msrest.serialization.Model):
    """A Microsoft Azure Attestation response token body - the body of a response token issued by MAA.

    :param jti: Unique Identifier for the token.
    :type jti: str
    :param iss: The Principal who issued the token.
    :type iss: str
    :param iat: The time at which the token was issued, in the number of seconds since
     1970-01-0T00:00:00Z UTC.
    :type iat: float
    :param exp: The expiration time after which the token is no longer valid, in the number of
     seconds since 1970-01-0T00:00:00Z UTC.
    :type exp: float
    :param nbf: The not before time before which the token cannot be considered valid, in the
     number of seconds since 1970-01-0T00:00:00Z UTC.
    :type nbf: float
    :param cnf: An RFC 7800 Proof of Possession Key.
    :type cnf: object
    :param nonce: The Nonce input to the attestation request, if provided.
    :type nonce: str
    :param version: The Schema version of this structure. Current Value: 1.0.
    :type version: str
    :param runtime_claims: Runtime Claims.
    :type runtime_claims: object
    :param inittime_claims: Inittime Claims.
    :type inittime_claims: object
    :param policy_claims: Policy Generated Claims.
    :type policy_claims: object
    :param verifier_type: The Attestation type being attested.
    :type verifier_type: str
    :param policy_signer: The certificate used to sign the policy object, if specified.
    :type policy_signer: ~azure.security.attestation.models.JSONWebKey
    :param policy_hash: The SHA256 hash of the BASE64URL encoded policy text used for attestation.
    :type policy_hash: bytes
    :param is_debuggable: True if the enclave is debuggable, false otherwise.
    :type is_debuggable: bool
    :param product_id: The SGX Product ID for the enclave.
    :type product_id: float
    :param mr_enclave: The HEX encoded SGX MRENCLAVE value for the enclave.
    :type mr_enclave: str
    :param mr_signer: The HEX encoded SGX MRSIGNER value for the enclave.
    :type mr_signer: str
    :param svn: The SGX SVN value for the enclave.
    :type svn: float
    :param enclave_held_data: A copy of the RuntimeData specified as an input to the attest call.
    :type enclave_held_data: bytes
    :param sgx_collateral: The SGX SVN value for the enclave.
    :type sgx_collateral: object
    :param deprecated_version: DEPRECATED: Private Preview version of x-ms-ver claim.
    :type deprecated_version: str
    :param deprecated_is_debuggable: DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable
     claim.
    :type deprecated_is_debuggable: bool
    :param deprecated_sgx_collateral: DEPRECATED: Private Preview version of x-ms-sgx-collateral
     claim.
    :type deprecated_sgx_collateral: object
    :param deprecated_enclave_held_data: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
    :type deprecated_enclave_held_data: bytes
    :param deprecated_enclave_held_data2: DEPRECATED: Private Preview version of x-ms-sgx-ehd
     claim.
    :type deprecated_enclave_held_data2: bytes
    :param deprecated_product_id: DEPRECATED: Private Preview version of x-ms-sgx-product-id.
    :type deprecated_product_id: float
    :param deprecated_mr_enclave: DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
    :type deprecated_mr_enclave: str
    :param deprecated_mr_signer: DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
    :type deprecated_mr_signer: str
    :param deprecated_svn: DEPRECATED: Private Preview version of x-ms-sgx-svn.
    :type deprecated_svn: float
    :param deprecated_tee: DEPRECATED: Private Preview version of x-ms-tee.
    :type deprecated_tee: str
    :param deprecated_policy_signer: DEPRECATED: Private Preview version of x-ms-policy-signer.
    :type deprecated_policy_signer: ~azure.security.attestation.models.JSONWebKey
    :param deprecated_policy_hash: DEPRECATED: Private Preview version of x-ms-policy-hash.
    :type deprecated_policy_hash: bytes
    :param deprecated_rp_data: DEPRECATED: Private Preview version of nonce.
    :type deprecated_rp_data: str
    """

    _attribute_map = {
        'jti': {'key': 'jti', 'type': 'str'},
        'iss': {'key': 'iss', 'type': 'str'},
        'iat': {'key': 'iat', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'cnf': {'key': 'cnf', 'type': 'object'},
        'nonce': {'key': 'nonce', 'type': 'str'},
        'version': {'key': 'x-ms-ver', 'type': 'str'},
        'runtime_claims': {'key': 'x-ms-runtime', 'type': 'object'},
        'inittime_claims': {'key': 'x-ms-inittime', 'type': 'object'},
        'policy_claims': {'key': 'x-ms-policy', 'type': 'object'},
        'verifier_type': {'key': 'x-ms-attestation-type', 'type': 'str'},
        'policy_signer': {'key': 'x-ms-policy-signer', 'type': 'JSONWebKey'},
        'policy_hash': {'key': 'x-ms-policy-hash', 'type': 'base64'},
        'is_debuggable': {'key': 'x-ms-sgx-is-debuggable', 'type': 'bool'},
        'product_id': {'key': 'x-ms-sgx-product-id', 'type': 'float'},
        'mr_enclave': {'key': 'x-ms-sgx-mrenclave', 'type': 'str'},
        'mr_signer': {'key': 'x-ms-sgx-mrsigner', 'type': 'str'},
        'svn': {'key': 'x-ms-sgx-svn', 'type': 'float'},
        'enclave_held_data': {'key': 'x-ms-sgx-ehd', 'type': 'base64'},
        'sgx_collateral': {'key': 'x-ms-sgx-collateral', 'type': 'object'},
        'deprecated_version': {'key': 'ver', 'type': 'str'},
        'deprecated_is_debuggable': {'key': 'is-debuggable', 'type': 'bool'},
        'deprecated_sgx_collateral': {'key': 'maa-attestationcollateral', 'type': 'object'},
        'deprecated_enclave_held_data': {'key': 'aas-ehd', 'type': 'base64'},
        'deprecated_enclave_held_data2': {'key': 'maa-ehd', 'type': 'base64'},
        'deprecated_product_id': {'key': 'product-id', 'type': 'float'},
        'deprecated_mr_enclave': {'key': 'sgx-mrenclave', 'type': 'str'},
        'deprecated_mr_signer': {'key': 'sgx-mrsigner', 'type': 'str'},
        'deprecated_svn': {'key': 'svn', 'type': 'float'},
        'deprecated_tee': {'key': 'tee', 'type': 'str'},
        'deprecated_policy_signer': {'key': 'policy_signer', 'type': 'JSONWebKey'},
        'deprecated_policy_hash': {'key': 'policy_hash', 'type': 'base64'},
        'deprecated_rp_data': {'key': 'rp_data', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        jti: Optional[str] = None,
        iss: Optional[str] = None,
        iat: Optional[float] = None,
        exp: Optional[float] = None,
        nbf: Optional[float] = None,
        cnf: Optional[object] = None,
        nonce: Optional[str] = None,
        version: Optional[str] = None,
        runtime_claims: Optional[object] = None,
        inittime_claims: Optional[object] = None,
        policy_claims: Optional[object] = None,
        verifier_type: Optional[str] = None,
        policy_signer: Optional["JSONWebKey"] = None,
        policy_hash: Optional[bytes] = None,
        is_debuggable: Optional[bool] = None,
        product_id: Optional[float] = None,
        mr_enclave: Optional[str] = None,
        mr_signer: Optional[str] = None,
        svn: Optional[float] = None,
        enclave_held_data: Optional[bytes] = None,
        sgx_collateral: Optional[object] = None,
        deprecated_version: Optional[str] = None,
        deprecated_is_debuggable: Optional[bool] = None,
        deprecated_sgx_collateral: Optional[object] = None,
        deprecated_enclave_held_data: Optional[bytes] = None,
        deprecated_enclave_held_data2: Optional[bytes] = None,
        deprecated_product_id: Optional[float] = None,
        deprecated_mr_enclave: Optional[str] = None,
        deprecated_mr_signer: Optional[str] = None,
        deprecated_svn: Optional[float] = None,
        deprecated_tee: Optional[str] = None,
        deprecated_policy_signer: Optional["JSONWebKey"] = None,
        deprecated_policy_hash: Optional[bytes] = None,
        deprecated_rp_data: Optional[str] = None,
        **kwargs
    ):
        super(AttestationResult, self).__init__(**kwargs)
        self.jti = jti
        self.iss = iss
        self.iat = iat
        self.exp = exp
        self.nbf = nbf
        self.cnf = cnf
        self.nonce = nonce
        self.version = version
        self.runtime_claims = runtime_claims
        self.inittime_claims = inittime_claims
        self.policy_claims = policy_claims
        self.verifier_type = verifier_type
        self.policy_signer = policy_signer
        self.policy_hash = policy_hash
        self.is_debuggable = is_debuggable
        self.product_id = product_id
        self.mr_enclave = mr_enclave
        self.mr_signer = mr_signer
        self.svn = svn
        self.enclave_held_data = enclave_held_data
        self.sgx_collateral = sgx_collateral
        self.deprecated_version = deprecated_version
        self.deprecated_is_debuggable = deprecated_is_debuggable
        self.deprecated_sgx_collateral = deprecated_sgx_collateral
        self.deprecated_enclave_held_data = deprecated_enclave_held_data
        self.deprecated_enclave_held_data2 = deprecated_enclave_held_data2
        self.deprecated_product_id = deprecated_product_id
        self.deprecated_mr_enclave = deprecated_mr_enclave
        self.deprecated_mr_signer = deprecated_mr_signer
        self.deprecated_svn = deprecated_svn
        self.deprecated_tee = deprecated_tee
        self.deprecated_policy_signer = deprecated_policy_signer
        self.deprecated_policy_hash = deprecated_policy_hash
        self.deprecated_rp_data = deprecated_rp_data


class AttestOpenEnclaveRequest(msrest.serialization.Model):
    """Attestation request for Intel SGX enclaves.

    :param report: OpenEnclave report from the enclave to be attested.
    :type report: bytes
    :param runtime_data: Runtime data provided by the enclave at the time of report generation. The
     MAA will verify that the first 32 bytes of the report_data field of the quote contains the
     SHA256 hash of the decoded "data" field of the runtime data.
    :type runtime_data: ~azure.security.attestation.models.RuntimeData
    :param init_time_data: Base64Url encoded "InitTime data". The MAA will verify that the init
     data was known to the enclave. Note that InitTimeData is invalid for CoffeeLake processors.
    :type init_time_data: ~azure.security.attestation.models.InitTimeData
    :param draft_policy_for_attestation: Attest against the provided draft policy. Note that the
     resulting token cannot be validated.
    :type draft_policy_for_attestation: str
    :param nonce: Nonce for incoming request - emitted in the generated attestation token.
    :type nonce: str
    """

    _attribute_map = {
        'report': {'key': 'report', 'type': 'base64'},
        'runtime_data': {'key': 'runtimeData', 'type': 'RuntimeData'},
        'init_time_data': {'key': 'initTimeData', 'type': 'InitTimeData'},
        'draft_policy_for_attestation': {'key': 'draftPolicyForAttestation', 'type': 'str'},
        'nonce': {'key': 'nonce', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        report: Optional[bytes] = None,
        runtime_data: Optional["RuntimeData"] = None,
        init_time_data: Optional["InitTimeData"] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs
    ):
        super(AttestOpenEnclaveRequest, self).__init__(**kwargs)
        self.report = report
        self.runtime_data = runtime_data
        self.init_time_data = init_time_data
        self.draft_policy_for_attestation = draft_policy_for_attestation
        self.nonce = nonce


class AttestSgxEnclaveRequest(msrest.serialization.Model):
    """Attestation request for Intel SGX enclaves.

    :param quote: Quote of the enclave to be attested.
    :type quote: bytes
    :param runtime_data: Runtime data provided by the enclave at the time of quote generation. The
     MAA will verify that the first 32 bytes of the report_data field of the quote contains the
     SHA256 hash of the decoded "data" field of the runtime data.
    :type runtime_data: ~azure.security.attestation.models.RuntimeData
    :param init_time_data: Initialization data provided when the enclave is created. MAA will
     verify that the init data was known to the enclave. Note that InitTimeData is invalid for
     CoffeeLake processors.
    :type init_time_data: ~azure.security.attestation.models.InitTimeData
    :param draft_policy_for_attestation: Attest against the provided draft policy. Note that the
     resulting token cannot be validated.
    :type draft_policy_for_attestation: str
    :param nonce: Nonce for incoming request - emitted in the generated attestation token.
    :type nonce: str
    """

    _attribute_map = {
        'quote': {'key': 'quote', 'type': 'base64'},
        'runtime_data': {'key': 'runtimeData', 'type': 'RuntimeData'},
        'init_time_data': {'key': 'initTimeData', 'type': 'InitTimeData'},
        'draft_policy_for_attestation': {'key': 'draftPolicyForAttestation', 'type': 'str'},
        'nonce': {'key': 'nonce', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        quote: Optional[bytes] = None,
        runtime_data: Optional["RuntimeData"] = None,
        init_time_data: Optional["InitTimeData"] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs
    ):
        super(AttestSgxEnclaveRequest, self).__init__(**kwargs)
        self.quote = quote
        self.runtime_data = runtime_data
        self.init_time_data = init_time_data
        self.draft_policy_for_attestation = draft_policy_for_attestation
        self.nonce = nonce


class CloudError(msrest.serialization.Model):
    """An error response from Attestation.

    :param error: An error response from Attestation.
    :type error: ~azure.security.attestation.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(
        self,
        *,
        error: Optional["CloudErrorBody"] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorBody(msrest.serialization.Model):
    """An error response from Attestation.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for displaying in a
     user interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class InitTimeData(msrest.serialization.Model):
    """Defines the "initialization time data" used to provision the attestation target for use by the MAA.

    :param data: UTF-8 encoded Initialization Data passed into the trusted environment when it is
     created.
    :type data: bytes
    :param data_type: The type of data contained within the "data" field. Possible values include:
     "Binary", "JSON".
    :type data_type: str or ~azure.security.attestation.models.DataType
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        data_type: Optional[Union[str, "DataType"]] = None,
        **kwargs
    ):
        super(InitTimeData, self).__init__(**kwargs)
        self.data = data
        self.data_type = data_type


class JSONWebKey(msrest.serialization.Model):
    """JSONWebKey.

    All required parameters must be populated in order to send to Azure.

    :param alg: Required. The "alg" (algorithm) parameter identifies the algorithm intended for
     use with the key.  The values used should either be registered in the
     IANA "JSON Web Signature and Encryption Algorithms" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.
    :type alg: str
    :param crv: The "crv" (curve) parameter identifies the curve type.
    :type crv: str
    :param d: RSA private exponent or ECC private key.
    :type d: str
    :param dp: RSA Private Key Parameter.
    :type dp: str
    :param dq: RSA Private Key Parameter.
    :type dq: str
    :param e: RSA public exponent, in Base64.
    :type e: str
    :param k: Symmetric key.
    :type k: str
    :param kid: Required. The "kid" (key ID) parameter is used to match a specific key.  This
     is used, for instance, to choose among a set of keys within a JWK Set
     during key rollover.  The structure of the "kid" value is
     unspecified.  When "kid" values are used within a JWK Set, different
     keys within the JWK Set SHOULD use distinct "kid" values.  (One
     example in which different keys might use the same "kid" value is if
     they have different "kty" (key type) values but are considered to be
     equivalent alternatives by the application using them.)  The "kid"
     value is a case-sensitive string.
    :type kid: str
    :param kty: Required. The "kty" (key type) parameter identifies the cryptographic algorithm
     family used with the key, such as "RSA" or "EC". "kty" values should
     either be registered in the IANA "JSON Web Key Types" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.  The "kty" value is a case-sensitive string.
    :type kty: str
    :param n: RSA modulus, in Base64.
    :type n: str
    :param p: RSA secret prime.
    :type p: str
    :param q: RSA secret prime, with p < q.
    :type q: str
    :param qi: RSA Private Key Parameter.
    :type qi: str
    :param use: Required. Use ("public key use") identifies the intended use of
     the public key. The "use" parameter is employed to indicate whether
     a public key is used for encrypting data or verifying the signature
     on data. Values are commonly "sig" (signature) or "enc" (encryption).
    :type use: str
    :param x: X coordinate for the Elliptic Curve point.
    :type x: str
    :param x5_c: The "x5c" (X.509 certificate chain) parameter contains a chain of one
     or more PKIX certificates [RFC5280].  The certificate chain is
     represented as a JSON array of certificate value strings.  Each
     string in the array is a base64-encoded (Section 4 of [RFC4648] --
     not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
     The PKIX certificate containing the key value MUST be the first
     certificate.
    :type x5_c: list[str]
    :param y: Y coordinate for the Elliptic Curve point.
    :type y: str
    """

    _validation = {
        'alg': {'required': True},
        'kid': {'required': True},
        'kty': {'required': True},
        'use': {'required': True},
    }

    _attribute_map = {
        'alg': {'key': 'alg', 'type': 'str'},
        'crv': {'key': 'crv', 'type': 'str'},
        'd': {'key': 'd', 'type': 'str'},
        'dp': {'key': 'dp', 'type': 'str'},
        'dq': {'key': 'dq', 'type': 'str'},
        'e': {'key': 'e', 'type': 'str'},
        'k': {'key': 'k', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'n': {'key': 'n', 'type': 'str'},
        'p': {'key': 'p', 'type': 'str'},
        'q': {'key': 'q', 'type': 'str'},
        'qi': {'key': 'qi', 'type': 'str'},
        'use': {'key': 'use', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'x5_c': {'key': 'x5c', 'type': '[str]'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alg: str,
        kid: str,
        kty: str,
        use: str,
        crv: Optional[str] = None,
        d: Optional[str] = None,
        dp: Optional[str] = None,
        dq: Optional[str] = None,
        e: Optional[str] = None,
        k: Optional[str] = None,
        n: Optional[str] = None,
        p: Optional[str] = None,
        q: Optional[str] = None,
        qi: Optional[str] = None,
        x: Optional[str] = None,
        x5_c: Optional[List[str]] = None,
        y: Optional[str] = None,
        **kwargs
    ):
        super(JSONWebKey, self).__init__(**kwargs)
        self.alg = alg
        self.crv = crv
        self.d = d
        self.dp = dp
        self.dq = dq
        self.e = e
        self.k = k
        self.kid = kid
        self.kty = kty
        self.n = n
        self.p = p
        self.q = q
        self.qi = qi
        self.use = use
        self.x = x
        self.x5_c = x5_c
        self.y = y


class JSONWebKeySet(msrest.serialization.Model):
    """JSONWebKeySet.

    :param keys: The value of the "keys" parameter is an array of JWK values.  By
     default, the order of the JWK values within the array does not imply
     an order of preference among them, although applications of JWK Sets
     can choose to assign a meaning to the order for their purposes, if
     desired.
    :type keys: list[~azure.security.attestation.models.JSONWebKey]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[JSONWebKey]'},
    }

    def __init__(
        self,
        *,
        keys: Optional[List["JSONWebKey"]] = None,
        **kwargs
    ):
        super(JSONWebKeySet, self).__init__(**kwargs)
        self.keys = keys


class PolicyCertificatesModificationResult(msrest.serialization.Model):
    """The result of a policy certificate modification.

    :param certificate_thumbprint: Hex encoded SHA1 Hash of the binary representation certificate
     which was added or removed.
    :type certificate_thumbprint: str
    :param certificate_resolution: The result of the operation. Possible values include:
     "IsPresent", "IsAbsent".
    :type certificate_resolution: str or ~azure.security.attestation.models.CertificateModification
    """

    _attribute_map = {
        'certificate_thumbprint': {'key': 'x-ms-certificate-thumbprint', 'type': 'str'},
        'certificate_resolution': {'key': 'x-ms-policycertificates-result', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_thumbprint: Optional[str] = None,
        certificate_resolution: Optional[Union[str, "CertificateModification"]] = None,
        **kwargs
    ):
        super(PolicyCertificatesModificationResult, self).__init__(**kwargs)
        self.certificate_thumbprint = certificate_thumbprint
        self.certificate_resolution = certificate_resolution


class PolicyCertificatesModifyResponse(msrest.serialization.Model):
    """The response to an attestation policy management API.

    :param token: An RFC7519 JSON Web Token structure whose body is a
     PolicyCertificatesModificationResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(PolicyCertificatesModifyResponse, self).__init__(**kwargs)
        self.token = token


class PolicyCertificatesResponse(msrest.serialization.Model):
    """The response to an attestation policy management API.

    :param token: An RFC7519 JSON Web Token structure containing a PolicyCertificatesResults object
     which contains the certificates used to validate policy changes.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(PolicyCertificatesResponse, self).__init__(**kwargs)
        self.token = token


class PolicyCertificatesResult(msrest.serialization.Model):
    """The result of a call to retrieve policy certificates.

    :param policy_certificates: SHA256 Hash of the binary representation certificate which was
     added or removed.
    :type policy_certificates: ~azure.security.attestation.models.JSONWebKeySet
    """

    _attribute_map = {
        'policy_certificates': {'key': 'x-ms-policy-certificates', 'type': 'JSONWebKeySet'},
    }

    def __init__(
        self,
        *,
        policy_certificates: Optional["JSONWebKeySet"] = None,
        **kwargs
    ):
        super(PolicyCertificatesResult, self).__init__(**kwargs)
        self.policy_certificates = policy_certificates


class PolicyResponse(msrest.serialization.Model):
    """The response to an attestation policy operation.

    :param token: An RFC7519 JSON Web Token structure whose body is an PolicyResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(PolicyResponse, self).__init__(**kwargs)
        self.token = token


class PolicyResult(msrest.serialization.Model):
    """The result of a policy certificate modification.

    :param policy_resolution: The result of the operation. Possible values include: "Updated",
     "Removed".
    :type policy_resolution: str or ~azure.security.attestation.models.PolicyModification
    :param policy_token_hash: The SHA256 hash of the policy object modified.
    :type policy_token_hash: bytes
    :param policy_signer: The certificate used to sign the policy object, if specified.
    :type policy_signer: ~azure.security.attestation.models.JSONWebKey
    :param policy: A JSON Web Token containing a StoredAttestationPolicy object with the
     attestation policy.
    :type policy: str
    """

    _validation = {
        'policy': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'policy_resolution': {'key': 'x-ms-policy-result', 'type': 'str'},
        'policy_token_hash': {'key': 'x-ms-policy-token-hash', 'type': 'base64'},
        'policy_signer': {'key': 'x-ms-policy-signer', 'type': 'JSONWebKey'},
        'policy': {'key': 'x-ms-policy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy_resolution: Optional[Union[str, "PolicyModification"]] = None,
        policy_token_hash: Optional[bytes] = None,
        policy_signer: Optional["JSONWebKey"] = None,
        policy: Optional[str] = None,
        **kwargs
    ):
        super(PolicyResult, self).__init__(**kwargs)
        self.policy_resolution = policy_resolution
        self.policy_token_hash = policy_token_hash
        self.policy_signer = policy_signer
        self.policy = policy


class RuntimeData(msrest.serialization.Model):
    """Defines the "run time data" provided by the attestation target for use by the MAA.

    :param data: UTF-8 encoded Runtime Data generated by the trusted environment.
    :type data: bytes
    :param data_type: The type of data contained within the "data" field. Possible values include:
     "Binary", "JSON".
    :type data_type: str or ~azure.security.attestation.models.DataType
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        data_type: Optional[Union[str, "DataType"]] = None,
        **kwargs
    ):
        super(RuntimeData, self).__init__(**kwargs)
        self.data = data
        self.data_type = data_type


class StoredAttestationPolicy(msrest.serialization.Model):
    """StoredAttestationPolicy.

    :param attestation_policy: Policy text to set as a sequence of UTF-8 encoded octets.
    :type attestation_policy: bytes
    """

    _attribute_map = {
        'attestation_policy': {'key': 'AttestationPolicy', 'type': 'base64'},
    }

    def __init__(
        self,
        *,
        attestation_policy: Optional[bytes] = None,
        **kwargs
    ):
        super(StoredAttestationPolicy, self).__init__(**kwargs)
        self.attestation_policy = attestation_policy


class TpmAttestationRequest(msrest.serialization.Model):
    """Attestation request for Trusted Platform Module (TPM) attestation.

    :param data: Protocol data containing artifacts for attestation.
    :type data: bytes
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
    }

    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        **kwargs
    ):
        super(TpmAttestationRequest, self).__init__(**kwargs)
        self.data = data


class TpmAttestationResponse(msrest.serialization.Model):
    """Attestation response for Trusted Platform Module (TPM) attestation.

    :param data: Protocol data containing attestation service response.
    :type data: bytes
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
    }

    def __init__(
        self,
        *,
        data: Optional[bytes] = None,
        **kwargs
    ):
        super(TpmAttestationResponse, self).__init__(**kwargs)
        self.data = data
