# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any

    from azure.core.credentials import TokenCredential

from ._configuration import AttestationClientConfiguration
from .operations import PolicyOperations
from .operations import PolicyCertificatesOperations
from .operations import AttestationOperations
from .operations import SigningCertificatesOperations
from .operations import MetadataConfigurationOperations
from . import models


class AttestationClient(object):
    """Describes the interface for the per-tenant enclave service.

    :ivar policy: PolicyOperations operations
    :vartype policy: azure.security.attestation.operations.PolicyOperations
    :ivar policy_certificates: PolicyCertificatesOperations operations
    :vartype policy_certificates: azure.security.attestation.operations.PolicyCertificatesOperations
    :ivar attestation: AttestationOperations operations
    :vartype attestation: azure.security.attestation.operations.AttestationOperations
    :ivar signing_certificates: SigningCertificatesOperations operations
    :vartype signing_certificates: azure.security.attestation.operations.SigningCertificatesOperations
    :ivar metadata_configuration: MetadataConfigurationOperations operations
    :vartype metadata_configuration: azure.security.attestation.operations.MetadataConfigurationOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param instance_url: The attestation instance base URI, for example https://mytenant.attest.azure.net.
    :type instance_url: str
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        instance_url,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        base_url = '{instanceUrl}'
        self._config = AttestationClientConfiguration(credential, instance_url, **kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.policy = PolicyOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.policy_certificates = PolicyCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.attestation = AttestationOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.signing_certificates = SigningCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.metadata_configuration = MetadataConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> AttestationClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
