# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventData(Model):
    """The Azure event log entries are of type EventData.

    :param authorization: the authorization used by the user who has
     performed the operation that led to this event.
    :type authorization: :class:`SenderAuthorization
     <azure.monitor.models.SenderAuthorization>`
    :param channels: the event channels. The regular event logs, that you see
     in the Azure Management Portals, flow through the 'Operation' channel.
     Possible values include: 'Admin', 'Operation', 'Debug', 'Analytics'
    :type channels: str or :class:`EventChannels
     <azure.monitor.models.EventChannels>`
    :param claims: key value pairs to identify ARM permissions.
    :type claims: dict
    :param caller: the email address of the user who has performed the
     operation, the UPN claim or SPN claim based on availability.
    :type caller: str
    :param description: the description of the event.
    :type description: str
    :param id: the resource Id.
    :type id: str
    :param event_data_id: the event data Id. This is a unique identifier for
     an event.
    :type event_data_id: str
    :param correlation_id: the correlation Id. The correlation Id is shared
     among the events that belong to the same deployment.
    :type correlation_id: str
    :param event_name: the event name. This value should not be confused with
     OperationName. For practical purposes, OperationName might be more
     appealing to end users.
    :type event_name: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param category: the event category.
    :type category: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param http_request: the HTTP request info. The client IP address of the
     user who initiated the event is captured as part of the HTTP request
     info.
    :type http_request: :class:`HttpRequestInfo
     <azure.monitor.models.HttpRequestInfo>`
    :param level: the event level. Possible values include: 'Critical',
     'Error', 'Warning', 'Informational', 'Verbose'
    :type level: str or :class:`EventLevel <azure.monitor.models.EventLevel>`
    :param resource_group_name: the resource group name.
    :type resource_group_name: str
    :param resource_provider_name: the resource provider name.
    :type resource_provider_name: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param resource_id: the resource uri
    :type resource_id: str
    :param resource_type: the resource type
    :type resource_type: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param operation_id: It is usually a GUID shared among the events
     corresponding to single operation. This value should not be confused
     with EventName.
    :type operation_id: str
    :param operation_name: the operation name.
    :type operation_name: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param properties: the property bag that includes details about the event.
    :type properties: dict
    :param status: the event status. Some typical values are: Started,
     Succeeded, Failed. For more information see:
     https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
    :type status: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param sub_status: the event sub status. Most of the time, when included,
     this captures the HTTP status code. For more information see:
     https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
    :type sub_status: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param event_timestamp: the occurrence time of event in ISO 8601 format
    :type event_timestamp: datetime
    :param submission_timestamp: the event submission time in ISO 8601
     format. This value should not be confused eventTimestamp. As there might
     be a delay between the occurence time of the event, and the time that
     the event is submitted to the Azure logging infrastructure.
    :type submission_timestamp: datetime
    :param subscription_id: the Azure subscription Id
    :type subscription_id: str
    :param tenant_id: the Azure tenant Id
    :type tenant_id: str
    """ 

    _validation = {
        'channels': {'required': True},
        'level': {'required': True},
        'event_timestamp': {'required': True},
        'submission_timestamp': {'required': True},
    }

    _attribute_map = {
        'authorization': {'key': 'authorization', 'type': 'SenderAuthorization'},
        'channels': {'key': 'channels', 'type': 'EventChannels'},
        'claims': {'key': 'claims', 'type': '{str}'},
        'caller': {'key': 'caller', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'event_data_id': {'key': 'eventDataId', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'LocalizableString'},
        'http_request': {'key': 'httpRequest', 'type': 'HttpRequestInfo'},
        'level': {'key': 'level', 'type': 'EventLevel'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'LocalizableString'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'LocalizableString'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'LocalizableString'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'LocalizableString'},
        'sub_status': {'key': 'subStatus', 'type': 'LocalizableString'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'submission_timestamp': {'key': 'submissionTimestamp', 'type': 'iso-8601'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, channels, level, event_timestamp, submission_timestamp, authorization=None, claims=None, caller=None, description=None, id=None, event_data_id=None, correlation_id=None, event_name=None, category=None, http_request=None, resource_group_name=None, resource_provider_name=None, resource_id=None, resource_type=None, operation_id=None, operation_name=None, properties=None, status=None, sub_status=None, subscription_id=None, tenant_id=None):
        self.authorization = authorization
        self.channels = channels
        self.claims = claims
        self.caller = caller
        self.description = description
        self.id = id
        self.event_data_id = event_data_id
        self.correlation_id = correlation_id
        self.event_name = event_name
        self.category = category
        self.http_request = http_request
        self.level = level
        self.resource_group_name = resource_group_name
        self.resource_provider_name = resource_provider_name
        self.resource_id = resource_id
        self.resource_type = resource_type
        self.operation_id = operation_id
        self.operation_name = operation_name
        self.properties = properties
        self.status = status
        self.sub_status = sub_status
        self.event_timestamp = event_timestamp
        self.submission_timestamp = submission_timestamp
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id
