'''OpenGL extension NV.texture_env_combine4

This module customises the behaviour of the 
OpenGL.raw.GL.NV.texture_env_combine4 to provide a more 
Python-friendly API

Overview (from the spec)
	
	New texture environment function COMBINE4_NV allows programmable
	texture combiner operations, including
	
	    ADD                     Arg0 * Arg1 + Arg2 * Arg3
	    ADD_SIGNED_EXT          Arg0 * Arg1 + Arg2 * Arg3 - 0.5
	
	where Arg0, Arg1, Arg2 and Arg3 are derived from
	
	    ZERO                    the value 0
	    PRIMARY_COLOR_EXT       primary color of incoming fragment
	    TEXTURE                 texture color of corresponding texture unit
	    CONSTANT_EXT            texture environment constant color
	    PREVIOUS_EXT            result of previous texture environment; on
	                            texture unit 0, this maps to PRIMARY_COLOR_EXT
	    TEXTURE<n>_ARB          texture color of the <n>th texture unit
	
	In addition, the result may be scaled by 1.0, 2.0 or 4.0.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/texture_env_combine4.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.texture_env_combine4 import *
### END AUTOGENERATED SECTION