/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.task.SimpleTaskLogs;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskLogs;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.flow.FlowAction;
import org.ow2.proactive.utils.ObjectByteConverter;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.TaskRestException;

public class TaskResultImpl
implements TaskResult {
    private static final long serialVersionUID = 1L;
    private TaskId id;
    private byte[] serializedValue;
    private byte[] serializedException;
    private Serializable value;
    private TaskLogs taskLogs;
    private String exceptionMessage;
    private Map<String, byte[]> propagatedVariables;
    private Map<String, Serializable> resultMap = new HashMap<String, Serializable>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private boolean isRaw;

    public TaskResultImpl(TaskId id, TaskResultData d) {
        this.id = id;
        this.serializedValue = ObjectByteConverter.base64StringToByteArray((String)d.getSerializedValue());
        this.metadata = d.getMetadata();
        this.exceptionMessage = d.getExceptionMessage();
        this.serializedException = ObjectByteConverter.base64StringToByteArray((String)d.getSerializedException());
        this.propagatedVariables = ObjectByteConverter.mapOfBase64StringToByteArray((Map)d.getSerializedPropagatedVariables());
        if (d.getOutput() != null) {
            this.taskLogs = new SimpleTaskLogs(d.getOutput().getStdoutLogs(), d.getOutput().getStderrLogs());
        }
        this.isRaw = d.isRaw();
    }

    public FlowAction getAction() {
        throw new UnsupportedOperationException();
    }

    public Throwable getException() {
        if (this.serializedException == null || this.exceptionMessage == null) {
            return null;
        }
        try {
            Throwable unserializedException = (Throwable)ObjectByteConverter.byteArrayToObject((byte[])this.serializedException);
            return unserializedException;
        }
        catch (ClassCastException e) {
            return new TaskRestException(this.exceptionMessage);
        }
    }

    public void setOutput(TaskLogs taskLogs) {
        this.taskLogs = taskLogs;
    }

    public TaskLogs getOutput() {
        return this.taskLogs;
    }

    public Map<String, byte[]> getPropagatedVariables() {
        return this.propagatedVariables;
    }

    public Map<String, Serializable> getVariables() throws IOException, ClassNotFoundException {
        return ObjectByteConverter.mapOfByteArrayToSerializable(this.propagatedVariables);
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    public Map<String, Serializable> getResultMap() {
        throw new UnsupportedOperationException();
    }

    public byte[] getSerializedValue() {
        return this.serializedValue;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TaskId getTaskId() {
        return this.id;
    }

    public boolean hadException() {
        return this.serializedException != null;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public Serializable value() throws Throwable {
        if (this.value == null) {
            if (this.serializedValue == null) {
                return null;
            }
            if (this.isRaw) {
                return this.serializedValue;
            }
            return (Serializable)ObjectByteConverter.byteArrayToObject((byte[])this.serializedValue);
        }
        return this.value;
    }

    public Serializable getValue() throws Throwable {
        return this.value();
    }
}

