LiPD
========

Input/output and manipulation utilities for LiPD files in Matlab, R and Python.


What is it?
----

LiPD is short for Linked PaleoData. LiPD is the data standard for paleoclimatology and the exchange of data amongst paleoclimate experts. This package will help you convert your existing database of paleoclimate observations into LiPD files. Moreover, it contains tools to analyze and manipulate LiPD data.


How does it work?
-----------

The LiPD package runs within the Jupyter (formerly iPython) environment. Jupyter is an important component for interactive data science and data scientific computing. If you are familiar with iPython, then you’ll have no problem here. If not, don’t worry, Jupyter is still very easy to learn. 

LiPD has its own way of manipulating and converting data, but uses Jupyter for its structure and interactive computing. When you're working you will see Jupyter's interface; however, LiPD will be working in the background.


Installation
------------
Python v3.4+ is required

LiPD is published through PyPi and easily installed via `pip`.

```
pip install LiPD
```
For more detailed installation instructions, please refer to the file called INSTALL.



Quickstart guide
----------------
1. Open your command line application (Terminal or Command Prompt):

2. Install with command:  `pip install LiPD`

3. Wait for installation to complete, then type `lipd` to launch the package.

4. A web portal will launch in your default internet browser.

5. Click to open the `Welcome LiPD - Quickstart.ipynb` file.

That’s it!

What you have done is launched the LiPD package and opened your first **Notebook**. This specific Notebook is an example and a guide to getting you familiar with what LiPD can do, and how to use LiPD commands.Once you get the hang of it, you can start creating your own Notebooks that are specific to your needs.


Features
----

- Convert Excel files to LiPD files
- Convert NOAA files to LiPD files
- Convert LiPD files to NOAA files
- Update LiPD publication data by fetching up-to-date information from DOI.org
- Load LiPD files for data analyzation
- Extract TimeSeries from LiPD files


Requirements
----
For a list of requirements that are installed with this package, please refer to the file called REQUIREMENTS.


Further information
----------
Github: https://github.com/nickmckay/LiPD-utilities

Linked Earth Wiki: http://www.organicdatacuration.org/linkedearth/index.php/Main_Page

Jupyter Documentation: https://jupyter.readthedocs.org/en/latest/


Contact
-------

If you are having issues, please let me know.
Contact me at heiser@nau.edu.


License
-------

The project is licensed under the GNU Public License. Please refer to the file called LICENSE.
