/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.SpelValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class SPELParserValidator
extends BaseParserValidator<String> {
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String SPEL_TYPE_REGEXP = "^" + SPELParserValidator.ignoreCaseRegexp(ModelType.SPEL.name()) + "\\" + "(" + "(.+)\\" + ")" + "$";

    public SPELParserValidator(String model) throws ModelSyntaxException {
        super(model, ModelType.SPEL, SPEL_TYPE_REGEXP);
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String spelString = this.parseAndGetOneGroup(model, SPEL_TYPE_REGEXP);
        try {
            return new SpelValidator(spelString);
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

