/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.serial;

import com.google.common.util.concurrent.SettableFuture;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.atmosphere.wasync.serial.SerializedFireStage;
import org.atmosphere.wasync.serial.SerializedSocket;

public class DefaultSerializedFireStage
implements SerializedFireStage {
    private volatile SerializedSocket socket;
    private final int maxBinaryMessagesAggregationSize;
    private final BlockingQueue<FirePayloadEntry> firePayloadsQueue;
    private final ExecutorService executorService;
    private final Runnable fireTask;

    public DefaultSerializedFireStage() {
        this(100);
    }

    public DefaultSerializedFireStage(int maxBinaryPayloadAggregationSize) {
        this.maxBinaryMessagesAggregationSize = maxBinaryPayloadAggregationSize;
        this.firePayloadsQueue = new LinkedBlockingQueue<FirePayloadEntry>();
        this.executorService = Executors.newSingleThreadExecutor();
        this.fireTask = this.createFireTask();
        this.executorService.execute(this.fireTask);
    }

    @Override
    public void setSocket(SerializedSocket socket) {
        this.socket = socket;
    }

    @Override
    public void enqueue(Object firePayload, SettableFuture<Response> originalFuture) {
        this.firePayloadsQueue.add(new FirePayloadEntry(firePayload, originalFuture));
    }

    private Runnable createFireTask() {
        return new Runnable(){

            @Override
            public void run() {
                ArrayList<FirePayloadEntry> aggregatedByteArrayPayloads = new ArrayList<FirePayloadEntry>(DefaultSerializedFireStage.this.maxBinaryMessagesAggregationSize);
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        FirePayloadEntry payloadEntry = (FirePayloadEntry)DefaultSerializedFireStage.this.firePayloadsQueue.take();
                        int aggregationCount = 1;
                        if (byte[].class.isAssignableFrom(payloadEntry.getFirePayload().getClass())) {
                            aggregatedByteArrayPayloads.add(payloadEntry);
                            while ((payloadEntry = (FirePayloadEntry)DefaultSerializedFireStage.this.firePayloadsQueue.poll()) != null) {
                                if (!byte[].class.isAssignableFrom(payloadEntry.getFirePayload().getClass())) {
                                    if (!aggregatedByteArrayPayloads.isEmpty()) {
                                        DefaultSerializedFireStage.this.fireSynchronously(aggregatedByteArrayPayloads);
                                        aggregatedByteArrayPayloads.clear();
                                    }
                                    DefaultSerializedFireStage.this.fireSynchronously(payloadEntry);
                                } else {
                                    aggregatedByteArrayPayloads.add(payloadEntry);
                                    if (++aggregationCount < DefaultSerializedFireStage.this.maxBinaryMessagesAggregationSize) continue;
                                }
                                break;
                            }
                        } else {
                            DefaultSerializedFireStage.this.fireSynchronously(payloadEntry);
                        }
                        if (aggregatedByteArrayPayloads.isEmpty()) continue;
                        DefaultSerializedFireStage.this.fireSynchronously(aggregatedByteArrayPayloads);
                        aggregatedByteArrayPayloads.clear();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSynchronously(ArrayList<FirePayloadEntry> aggregatedByteArrayPayloads) {
        int aggregatedSize = 0;
        for (FirePayloadEntry entry : aggregatedByteArrayPayloads) {
            aggregatedSize += ((byte[])entry.getFirePayload()).length;
        }
        byte[] aggregatedByteArray = new byte[aggregatedSize];
        int destPos = 0;
        for (FirePayloadEntry entry : aggregatedByteArrayPayloads) {
            byte[] payload = (byte[])entry.getFirePayload();
            System.arraycopy(payload, 0, aggregatedByteArray, destPos, payload.length);
            destPos += payload.length;
        }
        Response response = null;
        try {
            ListenableFuture<Response> future = this.socket.directWrite(aggregatedByteArray);
            response = (Response)future.get();
        }
        catch (Exception e) {
            for (FirePayloadEntry entry : aggregatedByteArrayPayloads) {
                entry.getOriginalFuture().setException((Throwable)e);
                entry.getOriginalFuture().cancel(true);
            }
        }
        finally {
            for (FirePayloadEntry entry : aggregatedByteArrayPayloads) {
                entry.getOriginalFuture().set((Object)response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSynchronously(FirePayloadEntry firePayloadEntry) {
        Response response = null;
        try {
            ListenableFuture<Response> future = this.socket.directWrite(firePayloadEntry.firePayload);
            response = (Response)future.get();
        }
        catch (Exception e) {
            try {
                firePayloadEntry.getOriginalFuture().setException((Throwable)e);
                firePayloadEntry.getOriginalFuture().cancel(true);
            }
            catch (Throwable throwable) {
                firePayloadEntry.getOriginalFuture().set(response);
                throw throwable;
            }
            firePayloadEntry.getOriginalFuture().set((Object)response);
        }
        firePayloadEntry.getOriginalFuture().set((Object)response);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
        for (FirePayloadEntry entry : this.firePayloadsQueue) {
            entry.getOriginalFuture().cancel(true);
        }
    }

    private class FirePayloadEntry {
        private Object firePayload;
        private SettableFuture<Response> originalFuture;

        public FirePayloadEntry(Object firePayload, SettableFuture<Response> originalFuture) {
            this.firePayload = firePayload;
            this.originalFuture = originalFuture;
        }

        public Object getFirePayload() {
            return this.firePayload;
        }

        public SettableFuture<Response> getOriginalFuture() {
            return this.originalFuture;
        }
    }
}

