/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.scheduler.client;

import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.plugins.interceptors.encoding.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.ow2.proactive_grid_cloud_portal.common.SchedulerRestInterface;
import org.ow2.proactive_grid_cloud_portal.common.exceptionmapper.ExceptionToJson;
import org.ow2.proactive_grid_cloud_portal.dataspace.dto.ListFile;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.utils.Zipper;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;

public class SchedulerRestClient {
    private SchedulerRestInterface scheduler;
    private String restEndpointURL;
    private ResteasyProviderFactory providerFactory;
    private static ClientHttpEngine httpEngine;
    private static SSLContext sslContext;

    public SchedulerRestClient(String restEndpointURL) {
        this(restEndpointURL, null);
    }

    public SchedulerRestClient(String restEndpointURL, ClientHttpEngine httpEngine) {
        if (httpEngine == null) {
            this.setBlindTrustSSLContext();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
            httpEngine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        }
        SchedulerRestClient.httpEngine = httpEngine;
        this.restEndpointURL = restEndpointURL;
        this.providerFactory = ResteasyProviderFactory.getInstance();
        if (!this.providerFactory.isRegistered(JacksonContextResolver.class)) {
            this.providerFactory.registerProvider(JacksonContextResolver.class);
        }
        SchedulerRestClient.registerGzipEncoding(this.providerFactory);
        this.scheduler = SchedulerRestClient.createRestProxy(this.providerFactory, restEndpointURL, httpEngine);
    }

    private void setBlindTrustSSLContext() {
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static ResteasyClient buildResteasyClient(ResteasyProviderFactory provider) {
        return new ResteasyClientBuilder().providerFactory(provider).httpEngine(httpEngine).build();
    }

    public static void registerGzipEncoding(ResteasyProviderFactory providerFactory) {
        if (!providerFactory.isRegistered(AcceptEncodingGZIPFilter.class)) {
            providerFactory.registerProvider(AcceptEncodingGZIPFilter.class);
        }
        if (!providerFactory.isRegistered(GZIPDecodingInterceptor.class)) {
            providerFactory.registerProvider(GZIPDecodingInterceptor.class);
        }
        if (!providerFactory.isRegistered(GZIPEncodingInterceptor.class)) {
            providerFactory.registerProvider(GZIPEncodingInterceptor.class);
        }
    }

    public JobIdData submitXmlAs(String sessionId, InputStream jobXml, String user) throws Exception {
        return this.submitXml(sessionId, jobXml, null);
    }

    public JobIdData submitXml(String sessionId, InputStream jobXml) throws Exception {
        return this.submitXml(sessionId, jobXml, null);
    }

    public JobIdData submitXml(String sessionId, InputStream jobXml, Map<String, String> variables) throws Exception {
        return this.submit(sessionId, jobXml, MediaType.APPLICATION_XML_TYPE, variables, null);
    }

    public JobIdData submitXml(String sessionId, InputStream jobXml, Map<String, String> variables, Map<String, String> genericInfos) throws Exception {
        return this.submit(sessionId, jobXml, MediaType.APPLICATION_XML_TYPE, variables, genericInfos);
    }

    public JobIdData submitJobArchive(String sessionId, InputStream jobArchive) throws Exception {
        return this.submitJobArchive(sessionId, jobArchive, null, null);
    }

    public JobIdData submitJobArchive(String sessionId, InputStream jobArchive, Map<String, String> variables, Map<String, String> genericInfos) throws Exception {
        return this.submit(sessionId, jobArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE, variables, genericInfos);
    }

    public boolean pushFile(String sessionId, String space, String path, String fileName, InputStream fileContent) throws Exception {
        String uriTmpl = this.restEndpointURL + this.addSlashIfMissing(this.restEndpointURL) + "scheduler/dataspace/" + space + URLEncoder.encode(path, "UTF-8");
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl);
        MultipartFormDataOutput formData = new MultipartFormDataOutput();
        formData.addFormData("fileName", (Object)fileName, MediaType.TEXT_PLAIN_TYPE);
        formData.addFormData("fileContent", (Object)fileContent, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        GenericEntity<MultipartFormDataOutput> entity = new GenericEntity<MultipartFormDataOutput>(formData){};
        Response response = target.request().header("sessionid", (Object)sessionId).post(Entity.entity((Object)entity, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() != 200) {
            if (response.getStatus() == 401) {
                throw new NotConnectedRestException("User not authenticated or session timeout.");
            }
            this.throwException(String.format("File upload failed. Status code: %d", response.getStatus()), response);
        }
        return (Boolean)response.readEntity(Boolean.class);
    }

    public void pullFile(String sessionId, String space, String path, String outputPath) throws Exception {
        String uriTmpl = this.restEndpointURL + this.addSlashIfMissing(this.restEndpointURL) + "scheduler/dataspace/" + space + URLEncoder.encode(path, "UTF-8");
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl);
        Response response = target.request().header("sessionid", (Object)sessionId).get();
        if (response.getStatus() != 200) {
            if (response.getStatus() == 401) {
                throw new NotConnectedRestException("User not authenticated or session timeout.");
            }
            this.throwException(String.format("Cannot retrieve the file. Status code: %s", response.getStatus()), response);
        }
        try {
            File file = new File(outputPath);
            if (response.hasEntity()) {
                FileUtils.copyInputStreamToFile((InputStream)((InputStream)response.readEntity(InputStream.class)), (File)file);
            } else {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (!client.isClosed()) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String sessionId, File file, List<String> includes, List<String> excludes, String dataspacePath, String path) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspacePath).append('/').append(this.escapeUrlPathSegment(path));
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString());
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).put(Entity.entity((Object)new CompressedStreamingOutput(file, includes, excludes), (Variant)new Variant(MediaType.APPLICATION_OCTET_STREAM_TYPE, (Locale)null, SchedulerRestClient.encoding(file))));
            if (response.getStatus() != 201) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("File upload failed. Status code: %d", response.getStatus()), response);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String sessionId, StreamingOutput output, String encoding, String dataspace, String path) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspace);
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(path);
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).put(Entity.entity((Object)output, (Variant)new Variant(MediaType.APPLICATION_OCTET_STREAM_TYPE, (Locale)null, encoding)));
            if (response.getStatus() != 201) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("File upload failed. Status code: %d" + response.getStatus(), new Object[0]), response);
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean download(String sessionId, String dataspacePath, String path, List<String> includes, List<String> excludes, String outputPath) throws Exception {
        return this.download(sessionId, dataspacePath, path, includes, excludes, new File(outputPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String sessionId, String dataspacePath, String path, List<String> includes, List<String> excludes, File outputFile) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspacePath).append('/');
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(path);
        if (includes != null && !includes.isEmpty()) {
            target = target.queryParam("includes", includes.toArray(new Object[includes.size()]));
        }
        if (excludes != null && !excludes.isEmpty()) {
            target = target.queryParam("excludes", excludes.toArray(new Object[excludes.size()]));
        }
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).acceptEncoding(new String[]{"*", "gzip", "zip"}).get();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("Cannot retrieve the file. Status code: %d", response.getStatus()), response);
            }
            if (response.hasEntity()) {
                InputStream is = (InputStream)response.readEntity(InputStream.class);
                if (this.isGZipEncoded(response)) {
                    if (outputFile.exists() && outputFile.isDirectory()) {
                        outputFile = new File(outputFile, response.getHeaderString("x-pds-pathname"));
                    }
                    Zipper.GZIP.unzip(is, outputFile);
                } else if (this.isZipEncoded(response)) {
                    Zipper.ZIP.unzip(is, outputFile);
                } else {
                    File container = outputFile.getParentFile();
                    if (!container.exists()) {
                        container.mkdirs();
                    }
                    Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom(is);
                }
            } else {
                outputFile.createNewFile();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String sessionId, String dataspacePath, String path, List<String> includes, List<String> excludes) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspacePath).append('/');
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(path);
        if (includes != null && !includes.isEmpty()) {
            target = target.queryParam("includes", includes.toArray(new Object[includes.size()]));
        }
        if (excludes != null && !excludes.isEmpty()) {
            target = target.queryParam("excludes", excludes.toArray(new Object[excludes.size()]));
        }
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).delete();
            if (response.getStatus() != 204) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("Cannot delete file(s). Status code: %s", response.getStatus()), response);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListFile list(String sessionId, String dataspacePath, String pathname) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspacePath).append('/');
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(pathname).queryParam("comp", new Object[]{"list"});
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).get();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("Cannot list the specified location: %s", pathname), response);
            }
            ListFile listFile = (ListFile)response.readEntity(ListFile.class);
            return listFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> metadata(String sessionId, String dataspacePath, String pathname) throws Exception {
        StringBuffer uriTmpl = new StringBuffer().append(this.restEndpointURL).append(this.addSlashIfMissing(this.restEndpointURL)).append("data/").append(dataspacePath).append(this.escapeUrlPathSegment(pathname));
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl.toString());
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)sessionId).head();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedRestException("User not authenticated or session timeout.");
                }
                this.throwException(String.format("Cannot get metadata from %s in %s.", pathname, dataspacePath), response);
            }
            MultivaluedMap headers = response.getHeaders();
            HashMap metaMap = Maps.newHashMap();
            if (headers.containsKey((Object)"Last-Modified")) {
                metaMap.put("Last-Modified", headers.getFirst((Object)"Last-Modified"));
            }
            HashMap hashMap = metaMap;
            return hashMap;
        }
    }

    private JobIdData submit(String sessionId, InputStream job, MediaType mediaType, Map<String, String> variables, Map<String, String> genericInfos) throws NotConnectedRestException {
        String uriTmpl = this.restEndpointURL + this.addSlashIfMissing(this.restEndpointURL) + "scheduler/submit";
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl);
        if (variables != null) {
            for (String key : variables.keySet()) {
                target = target.matrixParam(key, new Object[]{variables.get(key)});
            }
        }
        if (genericInfos != null) {
            for (String key : genericInfos.keySet()) {
                target = target.queryParamNoTemplate(key, new Object[]{genericInfos.get(key)});
            }
        }
        MultipartFormDataOutput formData = new MultipartFormDataOutput();
        formData.addFormData("file", (Object)job, mediaType);
        GenericEntity<MultipartFormDataOutput> entity = new GenericEntity<MultipartFormDataOutput>(formData){};
        Response response = target.request().header("sessionid", (Object)sessionId).post(Entity.entity((Object)entity, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() != 200) {
            if (response.getStatus() == 401) {
                throw new NotConnectedRestException("User not authenticated or session timeout.");
            }
            this.throwException(String.format("Job submission failed status code: %d", response.getStatus()), response);
        }
        return (JobIdData)response.readEntity(JobIdData.class);
    }

    public JobIdData reSubmit(String sessionId, String jobId, Map<String, String> variables, Map<String, String> genericInfos) throws NotConnectedRestException {
        Response response;
        String uriTmpl = this.restEndpointURL + this.addSlashIfMissing(this.restEndpointURL) + "scheduler/jobs/" + jobId + "/resubmit";
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(this.providerFactory);
        ResteasyWebTarget target = client.target(uriTmpl);
        if (variables != null) {
            for (String key : variables.keySet()) {
                target = target.matrixParam(key, new Object[]{variables.get(key)});
            }
        }
        if (genericInfos != null) {
            for (String key : genericInfos.keySet()) {
                target = target.queryParam(key, new Object[]{genericInfos.get(key)});
            }
        }
        if ((response = target.request().header("sessionid", (Object)sessionId).get()).getStatus() != 200) {
            if (response.getStatus() == 401) {
                throw new NotConnectedRestException("User not authenticated or session timeout.");
            }
            this.throwException(String.format("Job submission failed status code: %d", response.getStatus()), response);
        }
        return (JobIdData)response.readEntity(JobIdData.class);
    }

    private String addSlashIfMissing(String url) {
        return url.endsWith("/") ? "" : "/";
    }

    private boolean isGZipEncoded(Response response) {
        return "gzip".equals(response.getHeaderString("Content-Encoding"));
    }

    private boolean isZipEncoded(Response response) {
        return "zip".equals(response.getHeaderString("Content-Encoding"));
    }

    private String escapeUrlPathSegment(String unescaped) {
        return UrlEscapers.urlPathSegmentEscaper().escape(unescaped);
    }

    public SchedulerRestInterface getScheduler() {
        return this.scheduler;
    }

    private void throwException(String errorMessage, Response response) {
        Exception serverException = null;
        try {
            serverException = SchedulerRestClient.rebuildServerSideException((ExceptionToJson)response.readEntity(ExceptionToJson.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException(errorMessage, serverException);
    }

    private static SchedulerRestInterface createRestProxy(ResteasyProviderFactory provider, String restEndpointURL, ClientHttpEngine httpEngine) {
        ResteasyClient client = SchedulerRestClient.buildResteasyClient(provider);
        ResteasyWebTarget target = client.target(restEndpointURL);
        SchedulerRestInterface schedulerRestClient = (SchedulerRestInterface)target.proxy(SchedulerRestInterface.class);
        return SchedulerRestClient.createExceptionProxy(schedulerRestClient);
    }

    private static SchedulerRestInterface createExceptionProxy(SchedulerRestInterface scheduler) {
        return (SchedulerRestInterface)Proxy.newProxyInstance(SchedulerRestInterface.class.getClassLoader(), new Class[]{SchedulerRestInterface.class}, (InvocationHandler)new RestClientExceptionHandler(scheduler));
    }

    private static Exception rebuildServerSideException(ExceptionToJson json) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> exceptionClass;
        Throwable serverException = json.getException();
        String exceptionClassName = json.getExceptionClass();
        String errMsg = json.getErrorMessage();
        if (errMsg == null) {
            errMsg = "An error has occurred.";
        }
        if (serverException != null && exceptionClassName != null && (exceptionClass = SchedulerRestClient.toClass(exceptionClassName)) != null) {
            Constructor<?> constructor = SchedulerRestClient.getConstructor(exceptionClass, Throwable.class);
            if (constructor != null) {
                return (Exception)constructor.newInstance(serverException);
            }
            constructor = SchedulerRestClient.getConstructor(exceptionClass, String.class);
            if (constructor != null) {
                Exception built = (Exception)constructor.newInstance(errMsg);
                built.setStackTrace(serverException.getStackTrace());
                return built;
            }
        }
        Exception built = new Exception(errMsg);
        if (serverException != null) {
            built.setStackTrace(serverException.getStackTrace());
        }
        return built;
    }

    private static Class<?> toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String encoding(File file) throws FileNotFoundException {
        return file.isDirectory() ? "zip" : (Zipper.isZipFile(file) ? null : "gzip");
    }

    private static class CompressedStreamingOutput
    implements StreamingOutput {
        private File file;
        private List<String> includes;
        private List<String> excludes;

        public CompressedStreamingOutput(File file, List<String> includes, List<String> excludes) {
            this.file = file;
            this.includes = includes;
            this.excludes = excludes;
        }

        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
            if (this.file.isFile()) {
                if (Zipper.isZipFile(this.file)) {
                    Files.asByteSource((File)this.file).copyTo(outputStream);
                } else {
                    Zipper.GZIP.zip(this.file, outputStream);
                }
            } else {
                Zipper.ZIP.zip(this.file, this.includes, this.excludes, outputStream);
            }
        }
    }

    @Provider
    @Consumes(value={"application/json", "text/json"})
    @Produces(value={"application/json", "text/json"})
    public static class JacksonContextResolver
    implements ContextResolver<ObjectMapper> {
        public ObjectMapper getContext(Class<?> objectType) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper;
        }
    }

    private static class RestClientExceptionHandler
    implements InvocationHandler {
        private final SchedulerRestInterface scheduler;

        public RestClientExceptionHandler(SchedulerRestInterface scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.scheduler, args);
            }
            catch (InvocationTargetException targetException) {
                if (targetException.getTargetException() instanceof WebApplicationException) {
                    WebApplicationException clientException = (WebApplicationException)targetException.getTargetException();
                    try {
                        ExceptionToJson json = (ExceptionToJson)clientException.getResponse().readEntity(ExceptionToJson.class);
                        throw SchedulerRestClient.rebuildServerSideException(json);
                    }
                    catch (ProcessingException couldNotReadJsonException) {
                        throw clientException;
                    }
                    catch (IllegalStateException couldNotReadJsonException) {
                        throw clientException;
                    }
                }
                throw new RuntimeException(targetException.getTargetException());
            }
        }
    }
}

