/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamWriter {
    static final String MAGIC_HEADER = new String(new byte[]{67, 68, 70, 83, -20, -50, -83, -96});
    static final String MAGIC = MAGIC_HEADER.substring(0, 4);
    static final String HEADER = MAGIC_HEADER.substring(4);
    static final String MAGIC_DATA = new String(new byte[]{67, 68, 70, 83, -95, 26, -83, -96});
    static final String DATA = MAGIC_DATA.substring(4);
    static final String MAGIC_ATTS = "Atts";
    static final String MAGIC_DIMS = "Dims";
    static final String MAGIC_VARS = "Vars";
    private NetcdfFile ncfile;
    private DataOutputStream out;
    private boolean debug = false;

    public StreamWriter(NetcdfFile ncfile, DataOutputStream out, boolean useRecord) throws IOException, InvalidRangeException {
        this.ncfile = ncfile;
        this.out = out;
        if (useRecord) {
            ncfile.sendIospMessage("AddRecordStructure");
        }
        this.writeHeader(useRecord);
        List<Variable> vars = ncfile.getVariables();
        for (Variable v : vars) {
            if (useRecord && v.isUnlimited()) continue;
            this.writeData(v);
        }
        if (useRecord) {
            this.writeRecordData();
        }
        out.flush();
    }

    int writeHeader(boolean useRecord) throws IOException {
        int count;
        block10: {
            block9: {
                List<Variable> members;
                List<Attribute> atts;
                count = this.writeMagic(MAGIC_HEADER);
                List<Dimension> dims = this.ncfile.getDimensions();
                int ndims = dims.size();
                if (ndims > 0) {
                    count += this.writeMagic(MAGIC_DIMS);
                    this.writeDims(dims);
                }
                if ((atts = this.ncfile.getGlobalAttributes()).size() > 0) {
                    count += this.writeMagic(MAGIC_ATTS);
                    count += this.writeAtts(atts);
                }
                if (!useRecord) break block9;
                Structure record = (Structure)this.ncfile.findVariable("record");
                assert (record != null);
                ArrayList<Variable> vars = new ArrayList<Variable>(this.ncfile.getVariables());
                Iterator iter = vars.iterator();
                while (iter.hasNext()) {
                    Variable v = (Variable)iter.next();
                    if (!v.isUnlimited() || v == record) continue;
                    iter.remove();
                }
                int nvars = vars.size();
                if (nvars > 0) {
                    count += this.writeMagic(MAGIC_VARS);
                    count += this.writeVInt(nvars);
                    for (Variable v : vars) {
                        count += this.writeVar(v);
                    }
                }
                if ((nvars = (members = record.getVariables()).size()) <= 0) break block10;
                count += this.writeMagic(MAGIC_VARS);
                count += this.writeVInt(nvars);
                for (Variable v : members) {
                    count += this.writeVar(v);
                }
                break block10;
            }
            List<Variable> vars = this.ncfile.getVariables();
            int nvars = vars.size();
            if (nvars > 0) {
                count += this.writeMagic(MAGIC_VARS);
                count += this.writeVInt(nvars);
                for (Variable v : vars) {
                    count += this.writeVar(v);
                }
            }
        }
        return count;
    }

    int writeMagic(String magic) throws IOException {
        return this.writeBytes(magic.getBytes());
    }

    private int writeDims(List<Dimension> dims) throws IOException {
        int ndims = dims.size();
        int count = this.writeVInt(ndims);
        for (int i = 0; i < ndims; ++i) {
            int flags;
            Dimension dim = dims.get(i);
            count += this.writeString(dim.getName());
            count += this.writeVInt(dim.getLength());
            int n = flags = dim.isShared() ? 1 : 0;
            if (dim.isUnlimited()) {
                flags += 2;
            }
            if (dim.isVariableLength()) {
                flags += 4;
            }
            count += this.writeByte((byte)flags);
        }
        return count;
    }

    private int writeVar(Variable var) throws IOException {
        int count = 0;
        count += this.writeString(var.getName());
        int type = StreamWriter.getType(var.getDataType());
        count += this.writeVInt(type);
        count += this.writeDims(var.getDimensions());
        return count += this.writeAtts(var.getAttributes());
    }

    private int writeAtts(List<Attribute> atts) throws IOException {
        int natts = atts.size();
        int count = this.writeVInt(natts);
        for (int i = 0; i < natts; ++i) {
            int j;
            Attribute att = atts.get(i);
            count += this.writeString(att.getName());
            int type = StreamWriter.getType(att.getDataType());
            if (type == 2) {
                type = 8;
            }
            count += this.writeVInt(type);
            int nelems = att.getLength();
            count += this.writeVInt(nelems);
            if (type == 8) {
                for (j = 0; j < nelems; ++j) {
                    count += this.writeString(att.getStringValue(j));
                }
                continue;
            }
            for (j = 0; j < nelems; ++j) {
                count += this.writeAttributeValue(att.getNumericValue(j));
            }
        }
        return count;
    }

    private int writeAttributeValue(Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            this.out.write(numValue.byteValue());
            return 1;
        }
        if (numValue instanceof Short) {
            this.out.writeShort(numValue.shortValue());
            return 2;
        }
        if (numValue instanceof Integer) {
            this.out.writeInt(numValue.intValue());
            return 4;
        }
        if (numValue instanceof Float) {
            this.out.writeFloat(numValue.floatValue());
            return 4;
        }
        if (numValue instanceof Double) {
            this.out.writeDouble(numValue.doubleValue());
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    static int getType(DataType dt) {
        if (dt == DataType.BYTE) {
            return 1;
        }
        if (dt == DataType.CHAR) {
            return 2;
        }
        if (dt == DataType.SHORT) {
            return 3;
        }
        if (dt == DataType.INT) {
            return 4;
        }
        if (dt == DataType.FLOAT) {
            return 5;
        }
        if (dt == DataType.DOUBLE) {
            return 6;
        }
        if (dt == DataType.LONG) {
            return 7;
        }
        if (dt == DataType.STRING) {
            return 8;
        }
        if (dt == DataType.STRUCTURE) {
            return 9;
        }
        throw new IllegalStateException("unknown DataType == " + dt);
    }

    static DataType getDataType(int code) {
        if (code == 1) {
            return DataType.BYTE;
        }
        if (code == 2) {
            return DataType.CHAR;
        }
        if (code == 3) {
            return DataType.SHORT;
        }
        if (code == 4) {
            return DataType.INT;
        }
        if (code == 5) {
            return DataType.FLOAT;
        }
        if (code == 6) {
            return DataType.DOUBLE;
        }
        if (code == 7) {
            return DataType.LONG;
        }
        if (code == 8) {
            return DataType.STRING;
        }
        if (code == 9) {
            return DataType.STRUCTURE;
        }
        throw new IllegalStateException("unknown DataType == " + code);
    }

    public int writeData(Variable v) throws IOException {
        int count = this.writeMagic(MAGIC_DATA);
        if (this.debug) {
            System.out.println("  var= " + v.getNameAndDimensions() + " section = " + v.getShapeAsSection());
        }
        count += this.writeString(v.getName());
        count += this.writeVInt(v.getElementSize());
        count += this.writeSection(v.getShapeAsSection());
        return count += this.writeData(v.getDataType(), v.read());
    }

    public int writeSection(Section s) throws IOException {
        int count = this.writeVInt(s.getRank());
        for (Range r : s.getRanges()) {
            count += this.writeVInt(r.first());
            count += this.writeVInt(r.length());
        }
        return count;
    }

    private int writeData(DataType dataType, Array values) throws IOException {
        if (dataType == DataType.BYTE) {
            byte[] pa;
            for (byte b : pa = (byte[])values.get1DJavaArray(Byte.TYPE)) {
                this.out.write(b);
            }
            return pa.length;
        }
        if (dataType == DataType.CHAR) {
            char[] pa;
            for (char c : pa = (char[])values.get1DJavaArray(Character.TYPE)) {
                this.out.write((byte)c);
            }
            return pa.length;
        }
        if (dataType == DataType.SHORT) {
            short[] pa;
            for (short s : pa = (short[])values.get1DJavaArray(Short.TYPE)) {
                this.out.writeShort(s);
            }
            return 2 * pa.length;
        }
        if (dataType == DataType.INT) {
            int[] pa;
            for (int i : pa = (int[])values.get1DJavaArray(Integer.TYPE)) {
                this.out.writeInt(i);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa;
            for (float f : pa = (float[])values.get1DJavaArray(Float.TYPE)) {
                this.out.writeFloat(f);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa;
            for (double d : pa = (double[])values.get1DJavaArray(Double.TYPE)) {
                this.out.writeDouble(d);
            }
            return 8 * pa.length;
        }
        if (dataType == DataType.STRING) {
            String[] pa;
            for (String s : pa = (String[])values.get1DJavaArray(String.class)) {
                this.writeString(s);
            }
            return 8 * pa.length;
        }
        if (dataType == DataType.STRUCTURE) {
            int count = 0;
            ArrayStructure as = (ArrayStructure)values;
            StructureMembers sm = as.getStructureMembers();
            IndexIterator ii = values.getIndexIterator();
            while (ii.hasNext()) {
                StructureData sdata = (StructureData)ii.getObjectNext();
                for (StructureMembers.Member m : sm.getMembers()) {
                    Array data = sdata.getArray(m);
                    count += this.writeData(m.getDataType(), data);
                }
            }
            return count;
        }
        throw new IllegalStateException("dataType= " + dataType);
    }

    private int writeRecordData() throws IOException, InvalidRangeException {
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        int recno = 0;
        int count = 0;
        StructureMembers sm = record.makeStructureMembers();
        int size = sm.getStructureSize();
        int nrecsPerSection = Math.max(1, 1000000 / size);
        int total_nrecs = (int)record.getSize();
        Structure.Iterator iter = record.getStructureIterator();
        while (iter.hasNext()) {
            if (recno % nrecsPerSection == 0) {
                int need = Math.min(nrecsPerSection, total_nrecs - recno);
                if (this.debug) {
                    System.out.println("  var= " + record.getNameAndDimensions() + " start = " + recno + " nrecs=" + need);
                }
                count += this.writeMagic(MAGIC_DATA);
                count += this.writeString(record.getName());
                count += this.writeVInt(record.getElementSize());
                count += this.writeVInt(1);
                count += this.writeVInt(recno);
                count += this.writeVInt(need);
            }
            StructureData sdata = iter.next();
            for (StructureMembers.Member m : sdata.getMembers()) {
                Array data = sdata.getArray(m.getName());
                count += this.writeData(m.getDataType(), data);
            }
            ++recno;
        }
        return count;
    }

    private int writeByte(byte b) throws IOException {
        this.out.write(b);
        return 1;
    }

    private int writeBytes(byte[] b, int offset, int length) throws IOException {
        this.out.write(b, offset, length);
        return length;
    }

    private int writeBytes(byte[] b) throws IOException {
        return this.writeBytes(b, 0, b.length);
    }

    private int writeVInt(int i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
            ++count;
        }
        this.writeByte((byte)i);
        return count + 1;
    }

    private int writeVLong(long i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
            ++count;
        }
        this.writeByte((byte)i);
        return count + 1;
    }

    private int writeString(String s) throws IOException {
        int length = s.length();
        int count = this.writeVInt(length);
        return count += this.writeChars(s, 0, length);
    }

    private int writeChars(String s, int start, int length) throws IOException {
        int end = start + length;
        int count = 0;
        for (int i = start; i < end; ++i) {
            char code = s.charAt(i);
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                ++count;
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                count += 2;
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
            count += 3;
        }
        return count;
    }
}

