/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.IOException;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml4.Aggregation;
import ucar.nc2.ncml4.AggregationOuterDimension;
import ucar.nc2.util.CancelTask;

public class AggregationNew
extends AggregationOuterDimension {
    public AggregationNew(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.JOIN_NEW, recheckS);
    }

    protected void buildDataset(CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        DataType coordType = this.getCoordinateType();
        VariableDS joinAggCoord = new VariableDS(this.ncDataset, null, null, dimName, coordType, dimName, null, null);
        this.ncDataset.addVariable(null, joinAggCoord);
        joinAggCoord.setProxyReader(this);
        if (this.isDate) {
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        }
        AggregationOuterDimension.CoordValueVar cv = new AggregationOuterDimension.CoordValueVar((AggregationOuterDimension)this, joinAggCoord);
        joinAggCoord.setSPobject(cv);
        this.cacheList.add(cv);
        for (String varname : this.getAggVariableNames()) {
            Variable aggVar = this.ncDataset.getRootGroup().findVariable(varname);
            if (aggVar == null) {
                logger.error(this.ncDataset.getLocation() + " aggNewDimension cant find variable " + varname);
                continue;
            }
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, aggVar.getShortName(), aggVar.getDataType(), dimName + " " + aggVar.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(aggVar, vagg);
            Attribute att = vagg.findAttribute("_CoordinateAxes");
            if (att != null) {
                String axes = dimName + " " + att.getStringValue();
                vagg.addAttribute(new Attribute("_CoordinateAxes", axes));
            }
            this.ncDataset.removeVariable(null, aggVar.getShortName());
            this.ncDataset.addVariable(null, vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
    }

    private DataType getCoordinateType() {
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        AggregationOuterDimension.DatasetOuterDimension first = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(0);
        return first.isStringValued ? DataType.STRING : DataType.DOUBLE;
    }
}

