/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetFactory;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfDatasetCache {
    private static Logger logger = LoggerFactory.getLogger(NetcdfDatasetCache.class);
    private static List<CacheElement> cache;
    private static final Object lock;
    private static int maxElements;
    private static int minElements;
    private static boolean disabled;
    private static Timer timer;

    public static void init() {
        NetcdfDatasetCache.init(10, 20, 1200L);
    }

    public static void init(int minElementsInMemory, int maxElementsInMemory, long period) {
        minElements = minElementsInMemory;
        maxElements = maxElementsInMemory;
        cache = new ArrayList<CacheElement>(2 * maxElements - minElements);
        disabled = false;
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        timer.schedule((TimerTask)new CleanupTask(), 1000L * period, 1000L * period);
    }

    public static void disable() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        if (cache != null && cache.size() > 0) {
            NetcdfDatasetCache.clearCache(true);
        }
    }

    public static void exit() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        if (cache != null && cache.size() > 0) {
            NetcdfDatasetCache.clearCache(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfDataset acquireCacheOnly(String cacheName) throws IOException {
        if (disabled) {
            return null;
        }
        if (cache == null) {
            NetcdfDatasetCache.init();
        }
        CacheElement wantElem = null;
        Object object = lock;
        synchronized (object) {
            for (CacheElement testElem : cache) {
                if (!testElem.cacheName.equals(cacheName) || testElem.isLocked) continue;
                testElem.isLocked = true;
                wantElem = testElem;
                break;
            }
        }
        if (wantElem == null) {
            return null;
        }
        NetcdfDataset ncd = wantElem.ncd;
        if (ncd != null) {
            try {
                ncd.sync();
                if (logger.isDebugEnabled()) {
                    logger.debug("NetcdfFileCache.aquire from cache {}", (Object)cacheName);
                }
            }
            catch (IOException e) {
                logger.error("NetcdfFileCache.synch failed on " + cacheName + " " + e.getMessage());
            }
        }
        return ncd;
    }

    public static NetcdfDataset acquire(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDatasetCache.acquire(location, cancelTask, null);
    }

    public static NetcdfDataset acquire(String cacheName, CancelTask cancelTask, NetcdfDatasetFactory factory) throws IOException {
        return NetcdfDatasetCache.acquire(cacheName, -1, cancelTask, null, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfDataset acquire(String cacheName, int buffer_size, CancelTask cancelTask, Object spiObject, NetcdfDatasetFactory factory) throws IOException {
        boolean needCleanup;
        NetcdfDataset ncd = NetcdfDatasetCache.acquireCacheOnly(cacheName);
        if (ncd != null) {
            return ncd;
        }
        ncd = factory != null ? factory.openDataset(cacheName, buffer_size, cancelTask, spiObject) : NetcdfDataset.openDataset(cacheName, true, buffer_size, cancelTask, spiObject);
        if (cancelTask != null && cancelTask.isCancel()) {
            ncd.close();
            return null;
        }
        if (disabled) {
            return ncd;
        }
        Object object = lock;
        synchronized (object) {
            cache.add(new CacheElement(ncd, cacheName, factory));
            needCleanup = cache.size() > maxElements;
        }
        if (needCleanup) {
            timer.schedule((TimerTask)new CleanupTask(), 10L);
        }
        return ncd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(NetcdfDataset ncd) throws IOException {
        if (ncd == null) {
            return;
        }
        if (disabled) {
            ncd.setCacheState(0);
            ncd.close();
            return;
        }
        String cacheName = ncd.getCacheName();
        Object object = lock;
        synchronized (object) {
            for (CacheElement elem : cache) {
                if (elem.ncd != ncd) continue;
                if (!elem.isLocked) {
                    logger.warn("NetcdfDatasetCache.release " + cacheName + " not locked");
                }
                elem.isLocked = false;
                elem.lastAccessed = System.currentTimeMillis();
                ++elem.countAccessed;
                if (logger.isDebugEnabled()) {
                    logger.debug("NetcdfDatasetCache release " + cacheName);
                }
                return;
            }
        }
        throw new IOException("NetcdfDatasetCache.release does not have in cache = " + cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        int size = cache.size();
        if (size <= minElements) {
            return;
        }
        int count = 0;
        int need2delete = size - minElements;
        ArrayList<CacheElement> deleteList = new ArrayList<CacheElement>();
        Object object = lock;
        synchronized (object) {
            Collections.sort(cache);
            Iterator<CacheElement> iter = cache.iterator();
            while (iter.hasNext()) {
                CacheElement elem = iter.next();
                if (!elem.isLocked) {
                    iter.remove();
                    deleteList.add(elem);
                    ++count;
                }
                if (count < need2delete) continue;
                break;
            }
        }
        long start = System.currentTimeMillis();
        for (CacheElement elem : deleteList) {
            if (elem.ncd.getCacheState() != 2) {
                logger.warn("NetcdfDatasetCache file cache flag not set " + elem.cacheName);
            }
            try {
                elem.ncd.setCacheState(0);
                elem.ncd.close();
                elem.ncd = null;
            }
            catch (IOException e) {
                logger.error("NetcdfDatasetCache.close failed on " + elem.cacheName);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug("NetcdfDatasetCache.cleanup had= " + size + " deleted= " + count + " took=" + took + " msec");
        }
        if (count < need2delete) {
            logger.warn("NetcdfDatasetCache.cleanup couldnt delete enough for minimum= " + minElements + " actual= " + cache.size());
        }
    }

    public static List<CacheElement> getCache() {
        return cache == null ? new ArrayList<CacheElement>() : new ArrayList<CacheElement>(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(boolean force) {
        ArrayList<CacheElement> oldcache;
        if (null == cache) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (force) {
                oldcache = new ArrayList<CacheElement>(cache);
                cache.clear();
            } else {
                oldcache = new ArrayList(cache.size());
                Iterator<CacheElement> iter = cache.iterator();
                while (iter.hasNext()) {
                    CacheElement elem = iter.next();
                    if (elem.isLocked) continue;
                    iter.remove();
                    oldcache.add(elem);
                }
            }
        }
        for (CacheElement elem : oldcache) {
            if (elem.isLocked) {
                logger.warn("NetcdfDatasetCache close locked file= " + elem);
            }
            if (elem.ncd.getCacheState() != 2) {
                logger.warn("NetcdfDatasetCache file cache flag not set= " + elem);
            }
            try {
                elem.ncd.setCacheState(0);
                elem.ncd.close();
                elem.ncd = null;
            }
            catch (IOException e) {
                logger.error("NetcdfDatasetCache.close failed on " + elem);
            }
        }
    }

    static {
        lock = new Object();
        disabled = true;
    }

    private static class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        public void run() {
            NetcdfDatasetCache.cleanup();
        }
    }

    static class CacheElement
    implements Comparable {
        public String cacheName;
        public NetcdfDataset ncd;
        public NetcdfDatasetFactory factory;
        public boolean isLocked = true;
        public int countAccessed = 0;
        public long lastAccessed = 0L;

        CacheElement(NetcdfDataset ncd, String cacheName, NetcdfDatasetFactory factory) {
            this.cacheName = cacheName;
            this.ncd = ncd;
            this.factory = factory;
            ncd.setCacheState(2);
            ncd.setCacheName(cacheName);
            if (logger.isDebugEnabled()) {
                logger.debug("NetcdfDatasetCache add to cache " + cacheName);
            }
        }

        public String toString() {
            return this.isLocked + " " + this.cacheName + " " + this.countAccessed + " " + new Date(this.lastAccessed);
        }

        public int compareTo(Object o) {
            CacheElement e = (CacheElement)o;
            return (int)(this.lastAccessed - e.lastAccessed);
        }
    }
}

