/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure
extends Variable {
    private static Logger log = LoggerFactory.getLogger(Structure.class);
    private static int defaultBufferSize = 500000;
    protected List<Variable> members = new ArrayList<Variable>();
    protected List<String> memberNames = new ArrayList<String>();

    public Structure(NetcdfFile ncfile, Group group, Structure parent, String shortName) {
        super(ncfile, group, parent, shortName);
        this.dataType = DataType.STRUCTURE;
        this.elementSize = -1;
    }

    protected Structure(Structure from, boolean reparent) {
        super(from);
        this.members = new ArrayList<Variable>(from.members);
        this.memberNames = new ArrayList<String>(from.memberNames);
        if (reparent) {
            for (Variable v : this.members) {
                v.setParentStructure(this);
            }
        }
    }

    @Override
    protected Variable copy() {
        return new Structure(this, false);
    }

    protected int calcStructureSize() {
        int structureSize = 0;
        for (Variable member : this.members) {
            structureSize = (int)((long)structureSize + member.getSize() * (long)member.getElementSize());
        }
        return structureSize;
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public void setCaching(boolean caching) {
        this.cache.isCaching = false;
        this.cache.cachingSet = true;
    }

    public void addMemberVariable(Variable v) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        this.members.add(v);
        this.memberNames.add(v.getShortName());
        v.setParentStructure(this);
    }

    public void setMemberVariables(List<Variable> vars) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        this.members = new ArrayList<Variable>();
        this.memberNames = new ArrayList<String>();
        for (Variable v : vars) {
            this.members.add(v);
            this.memberNames.add(v.getShortName());
        }
    }

    public boolean removeMemberVariable(Variable v) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return false;
        }
        java.util.Iterator<Variable> iter = this.members.iterator();
        while (iter.hasNext()) {
            Variable mv = iter.next();
            if (!mv.getShortName().equals(v.getShortName())) continue;
            iter.remove();
            this.memberNames.remove(v.getShortName());
            return true;
        }
        return false;
    }

    public boolean replaceMemberVariable(Variable newVar) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        boolean found = false;
        for (int i = 0; i < this.members.size(); ++i) {
            Variable v = this.members.get(i);
            if (!v.getShortName().equals(newVar.getShortName())) continue;
            this.members.set(i, newVar);
            found = true;
        }
        if (!found) {
            this.members.add(newVar);
        }
        return found;
    }

    @Override
    public void setParentGroup(Group group) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(group);
        for (Variable v : this.members) {
            v.setParentGroup(group);
        }
    }

    @Override
    public Variable setImmutable() {
        this.members = Collections.unmodifiableList(this.members);
        this.memberNames = Collections.unmodifiableList(this.memberNames);
        for (Variable m : this.members) {
            m.setImmutable();
        }
        super.setImmutable();
        return this;
    }

    public List<Variable> getVariables() {
        return this.isImmutable() ? this.members : new ArrayList<Variable>(this.members);
    }

    public List<String> getVariableNames() {
        return this.isImmutable() ? this.memberNames : new ArrayList<String>(this.memberNames);
    }

    public Variable findVariable(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (Variable v : this.members) {
            if (!shortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    public StructureMembers makeStructureMembers() {
        StructureMembers smembers = new StructureMembers(this.getName());
        for (Variable v2 : this.getVariables()) {
            StructureMembers.Member m = new StructureMembers.Member(v2.getShortName(), v2.getDescription(), v2.getUnitsString(), v2.getDataType(), v2.getShape());
            if (v2 instanceof Structure) {
                m.setStructureMembers(((Structure)v2).makeStructureMembers());
            }
            smembers.addMember(m);
        }
        return smembers;
    }

    @Override
    public int getElementSize() {
        if (this.elementSize == -1) {
            this.calcElementSize();
        }
        return this.elementSize;
    }

    protected void calcElementSize() {
        int total = 0;
        for (Variable v : this.members) {
            total = (int)((long)total + (long)v.getElementSize() * v.getSize());
        }
        this.elementSize = total;
    }

    public StructureData readStructure() throws IOException {
        if (this.getRank() != 0) {
            throw new UnsupportedOperationException("not a scalar structure");
        }
        Array dataArray = this.read();
        ArrayStructure data = (ArrayStructure)dataArray;
        return data.getStructureData(0);
    }

    public StructureData readStructure(int index) throws IOException, InvalidRangeException {
        if (this.getRank() > 1) {
            throw new UnsupportedOperationException("not a vector structure");
        }
        int[] origin = new int[]{index};
        int[] shape = new int[]{1};
        Array dataArray = this.read(origin, shape);
        ArrayStructure data = (ArrayStructure)dataArray;
        return data.getStructureData(0);
    }

    public ArrayStructure readStructure(int start, int count) throws IOException, InvalidRangeException {
        if (this.getRank() != 1) {
            throw new UnsupportedOperationException("not a vector structure");
        }
        int[] origin = new int[]{start};
        int[] shape = new int[]{count};
        if (NetcdfFile.debugStructureIterator) {
            System.out.println("readStructure " + start + " " + count);
        }
        return (ArrayStructure)this.read(origin, shape);
    }

    public Iterator getStructureIterator() {
        return new Iterator(defaultBufferSize);
    }

    public Iterator getStructureIterator(int bufferSize) {
        return new Iterator(bufferSize);
    }

    public String getNameAndAttributes() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Structure ");
        this.getNameAndDimensions(sbuff, false, false);
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att.toString());
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    @Override
    public String toString() {
        return this.writeCDL("   ", false, false);
    }

    @Override
    public String writeCDL(String space, boolean useFullName, boolean strict) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        buf.append(space);
        buf.append(this.dataType.toString());
        buf.append(" {\n");
        String nestedSpace = "  " + space;
        for (Variable v : this.members) {
            buf.append(v.writeCDL(nestedSpace, useFullName, strict));
        }
        buf.append(space);
        buf.append("} ");
        this.getNameAndDimensions(buf, useFullName, false);
        buf.append(";");
        buf.append(this.extraInfo());
        buf.append("\n");
        for (Attribute att : this.getAttributes()) {
            buf.append(nestedSpace);
            if (strict) {
                buf.append(this.getShortName());
            }
            buf.append("  :");
            buf.append(att.toString());
            buf.append(";");
            if (!strict && att.getDataType() != DataType.STRING) {
                buf.append(" // ").append(att.getDataType());
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public class Iterator {
        private int count = 0;
        private int recnum = (int)Structure.this.getSize();
        private int readStart = 0;
        private int readAtaTime = 100;
        private int readCount = 0;
        private ArrayStructure as = null;

        protected Iterator(int bufferSize) {
            int structureSize = Structure.this.calcStructureSize();
            if (bufferSize <= 0) {
                bufferSize = defaultBufferSize;
            }
            this.readAtaTime = Math.max(10, bufferSize / structureSize);
            if (NetcdfFile.debugStructureIterator) {
                System.out.println("Iterator structureSize= " + structureSize + " readAtaTime= " + this.readAtaTime);
            }
        }

        public boolean hasNext() {
            return this.count < this.recnum;
        }

        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                this.readNext();
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        private void readNext() throws IOException {
            int left = Math.min(this.recnum, this.readStart + this.readAtaTime);
            int need = left - this.readStart;
            try {
                this.as = Structure.this.readStructure(this.readStart, need);
                if (NetcdfFile.debugStructureIterator) {
                    System.out.println("readNext " + this.count + " " + this.readStart);
                }
            }
            catch (InvalidRangeException e) {
                log.error("Structure.Iterator.readNext() ", e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart += need;
            this.readCount = 0;
        }
    }
}

