/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfFileCache {
    private static Logger log = LoggerFactory.getLogger(NetcdfFileCache.class);
    private static ArrayList<CacheElement> cache;
    private static final Object lock;
    private static int maxElements;
    private static int minElements;
    private static boolean disabled;
    private static Timer timer;

    public static void init() {
        NetcdfFileCache.init(10, 20, 1200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(int minElementsInMemory, int maxElementsInMemory, long period) {
        minElements = minElementsInMemory;
        maxElements = maxElementsInMemory;
        Object object = lock;
        synchronized (object) {
            cache = new ArrayList(2 * maxElements - minElements);
        }
        disabled = false;
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        timer.schedule((TimerTask)new CleanupTask(), 1000L * period, 1000L * period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disable() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        Object object = lock;
        synchronized (object) {
            if (cache != null && cache.size() > 0) {
                NetcdfFileCache.clearCache(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit() {
        disabled = true;
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        Object object = lock;
        synchronized (object) {
            if (cache != null && cache.size() > 0) {
                NetcdfFileCache.clearCache(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfFile acquireCacheOnly(String cacheName) {
        if (disabled) {
            return null;
        }
        if (cache == null) {
            NetcdfFileCache.init();
        }
        NetcdfFile ncfile = null;
        Object object = lock;
        synchronized (object) {
            for (CacheElement elem : cache) {
                if (!elem.cacheName.equals(cacheName) || elem.isLocked) continue;
                elem.isLocked = true;
                ncfile = elem.ncfile;
                break;
            }
        }
        if (ncfile != null) {
            try {
                ncfile.sync();
                if (log.isDebugEnabled()) {
                    log.debug("NetcdfFileCache.aquire from cache " + cacheName);
                }
            }
            catch (IOException e) {
                log.error("NetcdfFileCache.synch failed on " + cacheName + " " + e.getMessage());
            }
        }
        return ncfile;
    }

    public static NetcdfFile acquire(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFileCache.acquire(location, -1, cancelTask, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfFile acquire(String location, int buffer_size, CancelTask cancelTask, Object spiObject, NetcdfFileFactory factory) throws IOException {
        boolean needCleanup;
        NetcdfFile ncfile = NetcdfFileCache.acquireCacheOnly(location);
        if (ncfile != null) {
            return ncfile;
        }
        ncfile = factory == null ? NetcdfFile.open(location, buffer_size, cancelTask, spiObject) : factory.open(location, buffer_size, cancelTask, spiObject);
        if (cancelTask != null && cancelTask.isCancel()) {
            if (ncfile != null) {
                ncfile.close();
            }
            return null;
        }
        if (disabled) {
            return ncfile;
        }
        Object object = lock;
        synchronized (object) {
            cache.add(new CacheElement(ncfile, location));
            needCleanup = cache.size() > maxElements;
        }
        if (needCleanup) {
            timer.schedule((TimerTask)new CleanupTask(), 10L);
        }
        return ncfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(NetcdfFile ncfile) throws IOException {
        if (ncfile == null) {
            return;
        }
        if (disabled) {
            ncfile.setCacheState(0);
            ncfile.close();
            return;
        }
        String cacheName = ncfile.getCacheName();
        Object object = lock;
        synchronized (object) {
            for (CacheElement elem : cache) {
                if (elem.ncfile != ncfile) continue;
                if (!elem.isLocked) {
                    log.warn("NetcdfFileCache.release " + cacheName + " not locked");
                }
                elem.isLocked = false;
                elem.lastAccessed = System.currentTimeMillis();
                ++elem.countAccessed;
                if (log.isDebugEnabled()) {
                    log.debug("NetcdfFileCache.release " + cacheName);
                }
                return;
            }
        }
        throw new IOException("NetcdfFileCache.release does not have in cache = " + cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        int need2delete;
        int size;
        ArrayList<CacheElement> deleteList = new ArrayList<CacheElement>();
        int count = 0;
        Object object = lock;
        synchronized (object) {
            size = cache.size();
            if (size <= minElements) {
                return;
            }
            need2delete = size - minElements;
            Collections.sort(cache);
            Iterator<CacheElement> iter = cache.iterator();
            while (iter.hasNext()) {
                CacheElement elem = iter.next();
                if (!elem.isLocked) {
                    iter.remove();
                    deleteList.add(elem);
                    ++count;
                }
                if (count < need2delete) continue;
                break;
            }
        }
        long start = System.currentTimeMillis();
        for (CacheElement elem : deleteList) {
            if (elem.ncfile.getCacheState() != 1) {
                log.warn("NetcdfFileCache file cache flag not set " + elem.cacheName);
            }
            try {
                elem.ncfile.setCacheState(0);
                elem.ncfile.close();
                elem.ncfile = null;
            }
            catch (IOException e) {
                log.error("NetcdfFileCache.close failed on " + elem.cacheName);
            }
        }
        long took = System.currentTimeMillis() - start;
        log.debug("NetcdfFileCache.cleanup had= " + size + " deleted= " + count + " took=" + took + " msec");
        if (count < need2delete) {
            log.warn("NetcdfFileCache.cleanup couldnt delete enough for minimum= " + minElements + " actual= " + cache.size());
        }
    }

    public static List<CacheElement> getCache() {
        return cache == null ? new ArrayList<CacheElement>() : new ArrayList<CacheElement>(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(boolean force) {
        ArrayList<CacheElement> oldcache;
        if (null == cache) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (force) {
                oldcache = new ArrayList<CacheElement>(cache);
                cache.clear();
            } else {
                oldcache = new ArrayList(cache.size());
                Iterator<CacheElement> iter = cache.iterator();
                while (iter.hasNext()) {
                    CacheElement elem = iter.next();
                    if (elem.isLocked) continue;
                    iter.remove();
                    oldcache.add(elem);
                }
            }
        }
        for (CacheElement elem : oldcache) {
            if (elem.isLocked) {
                log.warn("NetcdfFileCache close locked file= " + elem);
            }
            if (elem.ncfile.getCacheState() != 1) {
                log.warn("NetcdfFileCache file cache flag not set= " + elem);
            }
            try {
                elem.ncfile.setCacheState(0);
                elem.ncfile.close();
                elem.ncfile = null;
            }
            catch (IOException e) {
                log.error("NetcdfFileCache.close failed on " + elem);
            }
        }
    }

    static {
        lock = new Object();
        disabled = true;
    }

    private static class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        public void run() {
            NetcdfFileCache.cleanup();
        }
    }

    static class CacheElement
    implements Comparable {
        public String cacheName;
        public NetcdfFile ncfile;
        public boolean isLocked = true;
        public int countAccessed = 0;
        public long lastAccessed = 0L;

        CacheElement(NetcdfFile ncfile, String cacheName) {
            this.cacheName = cacheName;
            this.ncfile = ncfile;
            ncfile.setCacheState(1);
            ncfile.setCacheName(cacheName);
            if (log.isDebugEnabled()) {
                log.debug("NetcdfFileCache add to cache " + cacheName);
            }
        }

        public String toString() {
            return this.isLocked + " " + this.cacheName + " " + this.countAccessed + " " + new Date(this.lastAccessed);
        }

        public int compareTo(Object o) {
            CacheElement e = (CacheElement)o;
            return (int)(this.lastAccessed - e.lastAccessed);
        }
    }
}

