/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.cataloggen.CatalogGen;
import thredds.cataloggen.CatalogRefInfo;
import thredds.cataloggen.config.DatasetSource;

public class CatalogGenMain {
    private static Logger log = LoggerFactory.getLogger(CatalogGen.class);

    public static void main(String[] args) {
        org.apache.log4j.Logger catGenLogger = null;
        Level logLevel = null;
        WriterAppender appender = null;
        PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss.SSS} [%10r] %-5p - %c - %m%n");
        boolean genCatalogRefs = false;
        String configFileName = null;
        File configFile = null;
        URL configDocURL = null;
        String outFileName = null;
        StringBuffer msgLog = new StringBuffer();
        if (args.length == 0) {
            CatalogGenMain.usage(System.out);
            System.exit(0);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            arguments.add(args[i]);
        }
        int argIndex = arguments.indexOf("-help");
        if (argIndex != -1) {
            CatalogGenMain.usage(System.out);
            System.exit(0);
        }
        String logFileName = null;
        File logFile = null;
        String logLevelName = null;
        argIndex = arguments.indexOf("-log");
        if (argIndex != -1) {
            try {
                arguments.remove(argIndex);
                logFileName = (String)arguments.get(argIndex);
                arguments.remove(argIndex);
                logLevelName = (String)arguments.get(argIndex);
                arguments.remove(argIndex);
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("CatalogGen: not enough information for -log option.");
                CatalogGenMain.usage(System.err);
                System.exit(1);
            }
            logLevel = Level.toLevel(logLevelName);
            logFile = new File(logFileName);
            if (!logFile.canWrite()) {
                System.err.println("CatalogGen: cannot write log file.");
                CatalogGenMain.usage(System.err);
                System.exit(1);
            }
            try {
                appender = new RollingFileAppender(layout, logFile.toString(), false);
            }
            catch (IOException e) {
                System.err.println("CatalogGen: Error - log file creation got IOException (" + logFile.toString() + ")");
                System.err.println("    " + e.getMessage());
                System.exit(1);
            }
        }
        if ((argIndex = arguments.indexOf("-genCatalogRefs")) != -1) {
            genCatalogRefs = true;
            arguments.remove(argIndex);
        }
        if (arguments.size() > 0) {
            configFileName = (String)arguments.get(0);
            arguments.remove(0);
            if (arguments.size() > 0) {
                outFileName = (String)arguments.get(0);
                arguments.remove(0);
            }
            if (arguments.size() > 0) {
                System.err.println("CatalogGen: Extra info on command-line <\"" + ((Object)arguments).toString() + "\">.");
                CatalogGenMain.usage(System.err);
                System.exit(1);
            }
        } else {
            System.err.println("CatalogGen: No configuration file name given.");
            CatalogGenMain.usage(System.err);
            System.exit(1);
        }
        if (appender == null) {
            appender = new ConsoleAppender(layout);
            logLevel = Level.toLevel("OFF");
        }
        catGenLogger = org.apache.log4j.Logger.getLogger("thredds.cataloggen");
        catGenLogger.setLevel(logLevel);
        catGenLogger.addAppender(appender);
        try {
            URI tmpURI;
            if (!configFileName.startsWith("http:") && !configFileName.startsWith("file:")) {
                configFile = new File(configFileName);
                if (!configFile.canRead()) {
                    log.error("CatalogGen: config file is not readable (" + configFile.toString() + ")");
                    System.exit(1);
                }
                tmpURI = configFile.toURI();
            } else {
                tmpURI = new URI(configFileName);
            }
            configDocURL = tmpURI.toURL();
        }
        catch (MalformedURLException e) {
            log.error("CatalogGen: The config doc path is not a valid URL (" + e.getMessage() + ").");
            CatalogGenMain.usage(System.err);
            System.exit(1);
        }
        catch (URISyntaxException e) {
            log.error("CatalogGen: The config doc path is not a valid URI (" + e.getMessage() + ").");
            System.err.println("CatalogGen: The config doc path is not a valid URI.");
            CatalogGenMain.usage(System.err);
            System.exit(1);
        }
        CatalogGen catGen = new CatalogGen(configDocURL);
        if (catGen.isValid(msgLog)) {
            catGen.expand();
            try {
                catGen.writeCatalog(outFileName);
            }
            catch (IOException e) {
                log.error("CatalogGen: could not write catalog: " + e.getMessage());
                System.exit(1);
            }
            log.debug("CatalogGen: wrote catalog <" + outFileName + ">.");
            if (genCatalogRefs) {
                List allCatRefInfos = catGen.getCatalogRefInfoList();
                while (allCatRefInfos.size() > 0) {
                    String tmpMsg;
                    CatalogRefInfo curCatRefInfo = (CatalogRefInfo)allCatRefInfos.remove(0);
                    DatasetSource curDss = curCatRefInfo.getDatasetSource();
                    InvCatalog catalog = null;
                    try {
                        catalog = curDss.fullExpand();
                    }
                    catch (IOException e) {
                        tmpMsg = "CatalogGen: failed to expand the catalogRef catalog <" + curCatRefInfo.getAccessPointDataset() + ">: " + e.getMessage();
                        log.error(tmpMsg);
                    }
                    try {
                        catGen.catFactory.writeXML((InvCatalogImpl)catalog, curCatRefInfo.getFileName());
                    }
                    catch (IOException e) {
                        tmpMsg = "CatalogGen: IOException, failed to write catalogRef catalog <" + curCatRefInfo.getFileName() + ">: " + e.getMessage();
                        log.error(tmpMsg);
                    }
                    String tmpMsg2 = "CatalogGen: wrote catalogRef catalog <" + curCatRefInfo.getFileName() + ">.";
                    log.debug(tmpMsg2);
                    ((ArrayList)allCatRefInfos).ensureCapacity(allCatRefInfos.size() + curDss.getCatalogRefInfoList().size());
                    allCatRefInfos.addAll(curDss.getCatalogRefInfoList());
                }
            }
        } else {
            log.error("CatalogGen: Invalid config file (" + configFileName + "):\n" + msgLog.toString());
            System.exit(1);
        }
    }

    private static void usage(PrintStream ps) {
        ps.println("Usage:");
        ps.println("  CatalogGen [options] <configDocName> [<outFileName>]\n    Given a CatalogGenConfig 0.5 document, produce a completed\n    InvCatalog 0.6 document. NOTE: the configuration document may\n    be specified as a local file name or as a URL.");
        ps.println("Options:\n  -help\n      Print this usage message.\n  -log <logFileName> <logLevel>\n      Write a log file at the given log level (OFF, FATAL, WARN, INFO, DEBUG, ALL).\n  -genCatalogRefs\n      Use this option if your config document generates catalogRefs and\n      you want to generate the catalogs those catalogRefs reference.");
    }
}

