/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmersionEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmersionEnumHandler.class);
    private static final Hashtable<String, String> patterns = ImmersionEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Oil\\s*", "Oil");
        p.put("^\\s*Water\\s*", "Water");
        p.put("^\\s*WaterDipping\\s*", "WaterDipping");
        p.put("^\\s*Air\\s*", "Air");
        p.put("^\\s*Multi\\s*", "Multi");
        p.put("^\\s*Glycerol\\s*", "Glycerol");
        p.put("^\\s*Other\\s*", "Other");
        p.put("^\\s*Dry\\s*", "Air");
        p.put("^\\s*OI\\s*", "Oil");
        p.put(".*Oil.*", "Oil");
        p.put(".*Oel.*", "Oil");
        p.put(".*Wasser.*", "Water");
        p.put(".*Gly.*", "Glycerol");
        p.put("^\\s*Wl\\s*", "Water");
        p.put("^\\s*W\\s*", "Water");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return Immersion.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"Immersion", (Object)value);
        return Immersion.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return Immersion.class;
    }
}

