/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reagent;
import ome.xml.model.ReagentRef;
import ome.xml.model.Reference;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Well
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Well.class);
    private String status;
    private String externalIdentifier;
    private NonNegativeInteger column;
    private String externalDescription;
    private Integer color;
    private String id;
    private NonNegativeInteger row;
    private List<WellSample> wellSampleList = new ArrayList<WellSample>();
    private Reagent reagent;
    private List<Annotation> annotationList = new ArrayList<Annotation>();

    public Well() {
    }

    public Well(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Well".equals(tagName)) {
            LOGGER.debug("Expecting node name of Well got {}", (Object)tagName);
        }
        if (element.hasAttribute("Status")) {
            this.setStatus(String.valueOf(element.getAttribute("Status")));
        }
        if (element.hasAttribute("ExternalIdentifier")) {
            this.setExternalIdentifier(String.valueOf(element.getAttribute("ExternalIdentifier")));
        }
        if (element.hasAttribute("Column")) {
            this.setColumn(NonNegativeInteger.valueOf(element.getAttribute("Column")));
        }
        if (element.hasAttribute("ExternalDescription")) {
            this.setExternalDescription(String.valueOf(element.getAttribute("ExternalDescription")));
        }
        if (element.hasAttribute("Color")) {
            this.setColor(Integer.valueOf(element.getAttribute("Color")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Well missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Row")) {
            this.setRow(NonNegativeInteger.valueOf(element.getAttribute("Row")));
        }
        List<Element> WellSample_nodeList = Well.getChildrenByTagName(element, "WellSample");
        for (Element WellSample_element : WellSample_nodeList) {
            this.addWellSample(new WellSample(WellSample_element, model));
        }
        List<Element> ReagentRef_nodeList = Well.getChildrenByTagName(element, "ReagentRef");
        for (Element ReagentRef_element : ReagentRef_nodeList) {
            ReagentRef reagent_reference = new ReagentRef();
            reagent_reference.setID(ReagentRef_element.getAttribute("ID"));
            model.addReference(this, reagent_reference);
        }
        List<Element> AnnotationRef_nodeList = Well.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ReagentRef) {
            Reagent o_casted = (Reagent)o;
            o_casted.linkWell(this);
            this.reagent = o_casted;
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkWell(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public NonNegativeInteger getColumn() {
        return this.column;
    }

    public void setColumn(NonNegativeInteger column) {
        this.column = column;
    }

    public String getExternalDescription() {
        return this.externalDescription;
    }

    public void setExternalDescription(String externalDescription) {
        this.externalDescription = externalDescription;
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public NonNegativeInteger getRow() {
        return this.row;
    }

    public void setRow(NonNegativeInteger row) {
        this.row = row;
    }

    public int sizeOfWellSampleList() {
        return this.wellSampleList.size();
    }

    public List<WellSample> copyWellSampleList() {
        return new ArrayList<WellSample>(this.wellSampleList);
    }

    public WellSample getWellSample(int index) {
        return this.wellSampleList.get(index);
    }

    public WellSample setWellSample(int index, WellSample wellSample) {
        return this.wellSampleList.set(index, wellSample);
    }

    public void addWellSample(WellSample wellSample) {
        this.wellSampleList.add(wellSample);
    }

    public void removeWellSample(WellSample wellSample) {
        this.wellSampleList.remove(wellSample);
    }

    public Reagent getLinkedReagent() {
        return this.reagent;
    }

    public void linkReagent(Reagent o) {
        this.reagent = o;
    }

    public void unlinkReagent(Reagent o) {
        if (this.reagent == o) {
            this.reagent = null;
        }
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkWell(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkWell(this);
        return this.annotationList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Well_element) {
        if (Well_element == null) {
            Well_element = document.createElementNS(NAMESPACE, "Well");
        }
        if (this.status != null) {
            Well_element.setAttribute("Status", this.status.toString());
        }
        if (this.externalIdentifier != null) {
            Well_element.setAttribute("ExternalIdentifier", this.externalIdentifier.toString());
        }
        if (this.column != null) {
            Well_element.setAttribute("Column", this.column.toString());
        }
        if (this.externalDescription != null) {
            Well_element.setAttribute("ExternalDescription", this.externalDescription.toString());
        }
        if (this.color != null) {
            Well_element.setAttribute("Color", this.color.toString());
        }
        if (this.id != null) {
            Well_element.setAttribute("ID", this.id.toString());
        }
        if (this.row != null) {
            Well_element.setAttribute("Row", this.row.toString());
        }
        if (this.wellSampleList != null) {
            for (WellSample wellSampleList_value : this.wellSampleList) {
                Well_element.appendChild(wellSampleList_value.asXMLElement(document));
            }
        }
        if (this.reagent != null) {
            ReagentRef o = new ReagentRef();
            o.setID(this.reagent.getID());
            Well_element.appendChild(o.asXMLElement(document));
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationList_value.getID());
                Well_element.appendChild(o.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Well_element);
    }
}

