/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rectangle
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Rectangle.class);
    private Double y;
    private Double x;
    private Double height;
    private Double width;

    public Rectangle() {
    }

    public Rectangle(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Rectangle".equals(tagName)) {
            LOGGER.debug("Expecting node name of Rectangle got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
        if (element.hasAttribute("Height")) {
            this.setHeight(Double.valueOf(element.getAttribute("Height")));
        }
        if (element.hasAttribute("Width")) {
            this.setWidth(Double.valueOf(element.getAttribute("Width")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Rectangle_element) {
        if (Rectangle_element == null) {
            Rectangle_element = document.createElementNS(NAMESPACE, "Rectangle");
        }
        if (this.y != null) {
            Rectangle_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Rectangle_element.setAttribute("X", this.x.toString());
        }
        if (this.height != null) {
            Rectangle_element.setAttribute("Height", this.height.toString());
        }
        if (this.width != null) {
            Rectangle_element.setAttribute("Width", this.width.toString());
        }
        return super.asXMLElement(document, Rectangle_element);
    }
}

