/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Polyline
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Polyline.class);
    private String points;
    private Boolean closed;

    public Polyline() {
    }

    public Polyline(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Polyline".equals(tagName)) {
            LOGGER.debug("Expecting node name of Polyline got {}", (Object)tagName);
        }
        if (element.hasAttribute("Points")) {
            this.setPoints(String.valueOf(element.getAttribute("Points")));
        }
        if (element.hasAttribute("Closed")) {
            this.setClosed(Boolean.valueOf(element.getAttribute("Closed")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Polyline_element) {
        if (Polyline_element == null) {
            Polyline_element = document.createElementNS(NAMESPACE, "Polyline");
        }
        if (this.points != null) {
            Polyline_element.setAttribute("Points", this.points.toString());
        }
        if (this.closed != null) {
            Polyline_element.setAttribute("Closed", this.closed.toString());
        }
        return super.asXMLElement(document, Polyline_element);
    }
}

