/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plane
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Plane.class);
    private Double exposureTime;
    private Double positionZ;
    private Double positionX;
    private Double positionY;
    private Double deltaT;
    private NonNegativeInteger theC;
    private NonNegativeInteger theZ;
    private NonNegativeInteger theT;
    private String hashSHA1;
    private List<Annotation> annotationList = new ArrayList<Annotation>();

    public Plane() {
    }

    public Plane(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> HashSHA1_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Plane".equals(tagName)) {
            LOGGER.debug("Expecting node name of Plane got {}", (Object)tagName);
        }
        if (element.hasAttribute("ExposureTime")) {
            this.setExposureTime(Double.valueOf(element.getAttribute("ExposureTime")));
        }
        if (element.hasAttribute("PositionZ")) {
            this.setPositionZ(Double.valueOf(element.getAttribute("PositionZ")));
        }
        if (element.hasAttribute("PositionX")) {
            this.setPositionX(Double.valueOf(element.getAttribute("PositionX")));
        }
        if (element.hasAttribute("PositionY")) {
            this.setPositionY(Double.valueOf(element.getAttribute("PositionY")));
        }
        if (element.hasAttribute("DeltaT")) {
            this.setDeltaT(Double.valueOf(element.getAttribute("DeltaT")));
        }
        if (element.hasAttribute("TheC")) {
            this.setTheC(NonNegativeInteger.valueOf(element.getAttribute("TheC")));
        }
        if (element.hasAttribute("TheZ")) {
            this.setTheZ(NonNegativeInteger.valueOf(element.getAttribute("TheZ")));
        }
        if (element.hasAttribute("TheT")) {
            this.setTheT(NonNegativeInteger.valueOf(element.getAttribute("TheT")));
        }
        if ((HashSHA1_nodeList = Plane.getChildrenByTagName(element, "HashSHA1")).size() > 1) {
            throw new RuntimeException(String.format("HashSHA1 node list size %d != 1", HashSHA1_nodeList.size()));
        }
        if (HashSHA1_nodeList.size() != 0) {
            this.setHashSHA1(String.valueOf(HashSHA1_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Plane.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlane(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getExposureTime() {
        return this.exposureTime;
    }

    public void setExposureTime(Double exposureTime) {
        this.exposureTime = exposureTime;
    }

    public Double getPositionZ() {
        return this.positionZ;
    }

    public void setPositionZ(Double positionZ) {
        this.positionZ = positionZ;
    }

    public Double getPositionX() {
        return this.positionX;
    }

    public void setPositionX(Double positionX) {
        this.positionX = positionX;
    }

    public Double getPositionY() {
        return this.positionY;
    }

    public void setPositionY(Double positionY) {
        this.positionY = positionY;
    }

    public Double getDeltaT() {
        return this.deltaT;
    }

    public void setDeltaT(Double deltaT) {
        this.deltaT = deltaT;
    }

    public NonNegativeInteger getTheC() {
        return this.theC;
    }

    public void setTheC(NonNegativeInteger theC) {
        this.theC = theC;
    }

    public NonNegativeInteger getTheZ() {
        return this.theZ;
    }

    public void setTheZ(NonNegativeInteger theZ) {
        this.theZ = theZ;
    }

    public NonNegativeInteger getTheT() {
        return this.theT;
    }

    public void setTheT(NonNegativeInteger theT) {
        this.theT = theT;
    }

    public String getHashSHA1() {
        return this.hashSHA1;
    }

    public void setHashSHA1(String hashSHA1) {
        this.hashSHA1 = hashSHA1;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlane(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlane(this);
        return this.annotationList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Plane_element) {
        if (Plane_element == null) {
            Plane_element = document.createElementNS(NAMESPACE, "Plane");
        }
        if (this.exposureTime != null) {
            Plane_element.setAttribute("ExposureTime", this.exposureTime.toString());
        }
        if (this.positionZ != null) {
            Plane_element.setAttribute("PositionZ", this.positionZ.toString());
        }
        if (this.positionX != null) {
            Plane_element.setAttribute("PositionX", this.positionX.toString());
        }
        if (this.positionY != null) {
            Plane_element.setAttribute("PositionY", this.positionY.toString());
        }
        if (this.deltaT != null) {
            Plane_element.setAttribute("DeltaT", this.deltaT.toString());
        }
        if (this.theC != null) {
            Plane_element.setAttribute("TheC", this.theC.toString());
        }
        if (this.theZ != null) {
            Plane_element.setAttribute("TheZ", this.theZ.toString());
        }
        if (this.theT != null) {
            Plane_element.setAttribute("TheT", this.theT.toString());
        }
        if (this.hashSHA1 != null) {
            Element hashSHA1_element = document.createElementNS(NAMESPACE, "HashSHA1");
            hashSHA1_element.setTextContent(this.hashSHA1.toString());
            Plane_element.appendChild(hashSHA1_element);
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationList_value.getID());
                Plane_element.appendChild(o.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Plane_element);
    }
}

