/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinaryOnly;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.Group;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reference;
import ome.xml.model.Screen;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OME
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(OME.class);
    private String uuid;
    private String creator;
    private List<Project> projectList = new ArrayList<Project>();
    private List<Dataset> datasetList = new ArrayList<Dataset>();
    private List<Experiment> experimentList = new ArrayList<Experiment>();
    private List<Plate> plateList = new ArrayList<Plate>();
    private List<Screen> screenList = new ArrayList<Screen>();
    private List<Experimenter> experimenterList = new ArrayList<Experimenter>();
    private List<Group> groupList = new ArrayList<Group>();
    private List<Instrument> instrumentList = new ArrayList<Instrument>();
    private List<Image> imageList = new ArrayList<Image>();
    private StructuredAnnotations structuredAnnotations;
    private List<ROI> roiList = new ArrayList<ROI>();
    private BinaryOnly binaryOnly;

    public OME() {
    }

    public OME(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"OME".equals(tagName)) {
            LOGGER.debug("Expecting node name of OME got {}", (Object)tagName);
        }
        if (element.hasAttribute("UUID")) {
            this.setUUID(String.valueOf(element.getAttribute("UUID")));
        }
        if (element.hasAttribute("Creator")) {
            this.setCreator(String.valueOf(element.getAttribute("Creator")));
        }
        List<Element> Project_nodeList = OME.getChildrenByTagName(element, "Project");
        for (Element Project_element : Project_nodeList) {
            this.addProject(new Project(Project_element, model));
        }
        List<Element> Dataset_nodeList = OME.getChildrenByTagName(element, "Dataset");
        for (Element Dataset_element : Dataset_nodeList) {
            this.addDataset(new Dataset(Dataset_element, model));
        }
        List<Element> Experiment_nodeList = OME.getChildrenByTagName(element, "Experiment");
        for (Element Experiment_element : Experiment_nodeList) {
            this.addExperiment(new Experiment(Experiment_element, model));
        }
        List<Element> Plate_nodeList = OME.getChildrenByTagName(element, "Plate");
        for (Element Plate_element : Plate_nodeList) {
            this.addPlate(new Plate(Plate_element, model));
        }
        List<Element> Screen_nodeList = OME.getChildrenByTagName(element, "Screen");
        for (Element Screen_element : Screen_nodeList) {
            this.addScreen(new Screen(Screen_element, model));
        }
        List<Element> Experimenter_nodeList = OME.getChildrenByTagName(element, "Experimenter");
        for (Element Experimenter_element : Experimenter_nodeList) {
            this.addExperimenter(new Experimenter(Experimenter_element, model));
        }
        List<Element> Group_nodeList = OME.getChildrenByTagName(element, "Group");
        for (Element Group_element : Group_nodeList) {
            this.addGroup(new Group(Group_element, model));
        }
        List<Element> Instrument_nodeList = OME.getChildrenByTagName(element, "Instrument");
        for (Element Instrument_element : Instrument_nodeList) {
            this.addInstrument(new Instrument(Instrument_element, model));
        }
        List<Element> Image_nodeList = OME.getChildrenByTagName(element, "Image");
        for (Element Image_element : Image_nodeList) {
            this.addImage(new Image(Image_element, model));
        }
        List<Element> StructuredAnnotations_nodeList = OME.getChildrenByTagName(element, "StructuredAnnotations");
        if (StructuredAnnotations_nodeList.size() > 1) {
            throw new RuntimeException(String.format("StructuredAnnotations node list size %d != 1", StructuredAnnotations_nodeList.size()));
        }
        if (StructuredAnnotations_nodeList.size() != 0) {
            this.setStructuredAnnotations(new StructuredAnnotations(StructuredAnnotations_nodeList.get(0), model));
        }
        List<Element> ROI_nodeList = OME.getChildrenByTagName(element, "ROI");
        for (Element ROI_element : ROI_nodeList) {
            this.addROI(new ROI(ROI_element, model));
        }
        List<Element> BinaryOnly_nodeList = OME.getChildrenByTagName(element, "BinaryOnly");
        if (BinaryOnly_nodeList.size() > 1) {
            throw new RuntimeException(String.format("BinaryOnly node list size %d != 1", BinaryOnly_nodeList.size()));
        }
        if (BinaryOnly_nodeList.size() != 0) {
            this.setBinaryOnly(new BinaryOnly(BinaryOnly_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public int sizeOfProjectList() {
        return this.projectList.size();
    }

    public List<Project> copyProjectList() {
        return new ArrayList<Project>(this.projectList);
    }

    public Project getProject(int index) {
        return this.projectList.get(index);
    }

    public Project setProject(int index, Project project) {
        return this.projectList.set(index, project);
    }

    public void addProject(Project project) {
        this.projectList.add(project);
    }

    public void removeProject(Project project) {
        this.projectList.remove(project);
    }

    public int sizeOfDatasetList() {
        return this.datasetList.size();
    }

    public List<Dataset> copyDatasetList() {
        return new ArrayList<Dataset>(this.datasetList);
    }

    public Dataset getDataset(int index) {
        return this.datasetList.get(index);
    }

    public Dataset setDataset(int index, Dataset dataset) {
        return this.datasetList.set(index, dataset);
    }

    public void addDataset(Dataset dataset) {
        this.datasetList.add(dataset);
    }

    public void removeDataset(Dataset dataset) {
        this.datasetList.remove(dataset);
    }

    public int sizeOfExperimentList() {
        return this.experimentList.size();
    }

    public List<Experiment> copyExperimentList() {
        return new ArrayList<Experiment>(this.experimentList);
    }

    public Experiment getExperiment(int index) {
        return this.experimentList.get(index);
    }

    public Experiment setExperiment(int index, Experiment experiment) {
        return this.experimentList.set(index, experiment);
    }

    public void addExperiment(Experiment experiment) {
        this.experimentList.add(experiment);
    }

    public void removeExperiment(Experiment experiment) {
        this.experimentList.remove(experiment);
    }

    public int sizeOfPlateList() {
        return this.plateList.size();
    }

    public List<Plate> copyPlateList() {
        return new ArrayList<Plate>(this.plateList);
    }

    public Plate getPlate(int index) {
        return this.plateList.get(index);
    }

    public Plate setPlate(int index, Plate plate) {
        return this.plateList.set(index, plate);
    }

    public void addPlate(Plate plate) {
        this.plateList.add(plate);
    }

    public void removePlate(Plate plate) {
        this.plateList.remove(plate);
    }

    public int sizeOfScreenList() {
        return this.screenList.size();
    }

    public List<Screen> copyScreenList() {
        return new ArrayList<Screen>(this.screenList);
    }

    public Screen getScreen(int index) {
        return this.screenList.get(index);
    }

    public Screen setScreen(int index, Screen screen) {
        return this.screenList.set(index, screen);
    }

    public void addScreen(Screen screen) {
        this.screenList.add(screen);
    }

    public void removeScreen(Screen screen) {
        this.screenList.remove(screen);
    }

    public int sizeOfExperimenterList() {
        return this.experimenterList.size();
    }

    public List<Experimenter> copyExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenterList);
    }

    public Experimenter getExperimenter(int index) {
        return this.experimenterList.get(index);
    }

    public Experimenter setExperimenter(int index, Experimenter experimenter) {
        return this.experimenterList.set(index, experimenter);
    }

    public void addExperimenter(Experimenter experimenter) {
        this.experimenterList.add(experimenter);
    }

    public void removeExperimenter(Experimenter experimenter) {
        this.experimenterList.remove(experimenter);
    }

    public int sizeOfGroupList() {
        return this.groupList.size();
    }

    public List<Group> copyGroupList() {
        return new ArrayList<Group>(this.groupList);
    }

    public Group getGroup(int index) {
        return this.groupList.get(index);
    }

    public Group setGroup(int index, Group group) {
        return this.groupList.set(index, group);
    }

    public void addGroup(Group group) {
        this.groupList.add(group);
    }

    public void removeGroup(Group group) {
        this.groupList.remove(group);
    }

    public int sizeOfInstrumentList() {
        return this.instrumentList.size();
    }

    public List<Instrument> copyInstrumentList() {
        return new ArrayList<Instrument>(this.instrumentList);
    }

    public Instrument getInstrument(int index) {
        return this.instrumentList.get(index);
    }

    public Instrument setInstrument(int index, Instrument instrument) {
        return this.instrumentList.set(index, instrument);
    }

    public void addInstrument(Instrument instrument) {
        this.instrumentList.add(instrument);
    }

    public void removeInstrument(Instrument instrument) {
        this.instrumentList.remove(instrument);
    }

    public int sizeOfImageList() {
        return this.imageList.size();
    }

    public List<Image> copyImageList() {
        return new ArrayList<Image>(this.imageList);
    }

    public Image getImage(int index) {
        return this.imageList.get(index);
    }

    public Image setImage(int index, Image image) {
        return this.imageList.set(index, image);
    }

    public void addImage(Image image) {
        this.imageList.add(image);
    }

    public void removeImage(Image image) {
        this.imageList.remove(image);
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations) {
        this.structuredAnnotations = structuredAnnotations;
    }

    public int sizeOfROIList() {
        return this.roiList.size();
    }

    public List<ROI> copyROIList() {
        return new ArrayList<ROI>(this.roiList);
    }

    public ROI getROI(int index) {
        return this.roiList.get(index);
    }

    public ROI setROI(int index, ROI roi) {
        return this.roiList.set(index, roi);
    }

    public void addROI(ROI roi) {
        this.roiList.add(roi);
    }

    public void removeROI(ROI roi) {
        this.roiList.remove(roi);
    }

    public BinaryOnly getBinaryOnly() {
        return this.binaryOnly;
    }

    public void setBinaryOnly(BinaryOnly binaryOnly) {
        this.binaryOnly = binaryOnly;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element OME_element) {
        if (OME_element == null) {
            OME_element = document.createElementNS(NAMESPACE, "OME");
        }
        if (this.uuid != null) {
            OME_element.setAttribute("UUID", this.uuid.toString());
        }
        if (this.creator != null) {
            OME_element.setAttribute("Creator", this.creator.toString());
        }
        if (this.projectList != null) {
            for (Project projectList_value : this.projectList) {
                OME_element.appendChild(projectList_value.asXMLElement(document));
            }
        }
        if (this.datasetList != null) {
            for (Dataset datasetList_value : this.datasetList) {
                OME_element.appendChild(datasetList_value.asXMLElement(document));
            }
        }
        if (this.experimentList != null) {
            for (Experiment experimentList_value : this.experimentList) {
                OME_element.appendChild(experimentList_value.asXMLElement(document));
            }
        }
        if (this.plateList != null) {
            for (Plate plateList_value : this.plateList) {
                OME_element.appendChild(plateList_value.asXMLElement(document));
            }
        }
        if (this.screenList != null) {
            for (Screen screenList_value : this.screenList) {
                OME_element.appendChild(screenList_value.asXMLElement(document));
            }
        }
        if (this.experimenterList != null) {
            for (Experimenter experimenterList_value : this.experimenterList) {
                OME_element.appendChild(experimenterList_value.asXMLElement(document));
            }
        }
        if (this.groupList != null) {
            for (Group groupList_value : this.groupList) {
                OME_element.appendChild(groupList_value.asXMLElement(document));
            }
        }
        if (this.instrumentList != null) {
            for (Instrument instrumentList_value : this.instrumentList) {
                OME_element.appendChild(instrumentList_value.asXMLElement(document));
            }
        }
        if (this.imageList != null) {
            for (Image imageList_value : this.imageList) {
                OME_element.appendChild(imageList_value.asXMLElement(document));
            }
        }
        if (this.structuredAnnotations != null) {
            OME_element.appendChild(this.structuredAnnotations.asXMLElement(document));
        }
        if (this.roiList != null) {
            for (ROI roiList_value : this.roiList) {
                OME_element.appendChild(roiList_value.asXMLElement(document));
            }
        }
        if (this.binaryOnly != null) {
            OME_element.appendChild(this.binaryOnly.asXMLElement(document));
        }
        return super.asXMLElement(document, OME_element);
    }
}

