/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Contact;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.Image;
import ome.xml.model.Leader;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Project;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Group.class);
    private String name;
    private String id;
    private String description;
    private Experimenter leader;
    private Experimenter contact;
    private List<Image> image_BackReferenceList = new ArrayList<Image>();
    private List<Project> project_BackReferenceList = new ArrayList<Project>();
    private List<Dataset> dataset_BackReferenceList = new ArrayList<Dataset>();
    private List<Experimenter> experimenter_BackReferenceList = new ArrayList<Experimenter>();

    public Group() {
    }

    public Group(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Group".equals(tagName)) {
            LOGGER.debug("Expecting node name of Group got {}", (Object)tagName);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Group missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Group.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> Leader_nodeList = Group.getChildrenByTagName(element, "Leader");
        for (Element Leader_element : Leader_nodeList) {
            Leader leader_reference = new Leader();
            leader_reference.setID(Leader_element.getAttribute("ID"));
            model.addReference(this, leader_reference);
        }
        List<Element> Contact_nodeList = Group.getChildrenByTagName(element, "Contact");
        for (Element Contact_element : Contact_nodeList) {
            Contact contact_reference = new Contact();
            contact_reference.setID(Contact_element.getAttribute("ID"));
            model.addReference(this, contact_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof Leader) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkGroup(this);
            this.leader = o_casted;
            return true;
        }
        if (reference instanceof Contact) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkGroup(this);
            this.contact = o_casted;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experimenter getLinkedLeader() {
        return this.leader;
    }

    public void linkLeader(Experimenter o) {
        this.leader = o;
    }

    public void unlinkLeader(Experimenter o) {
        if (this.leader == o) {
            this.leader = null;
        }
    }

    public Experimenter getLinkedContact() {
        return this.contact;
    }

    public void linkContact(Experimenter o) {
        this.contact = o;
    }

    public void unlinkContact(Experimenter o) {
        if (this.contact == o) {
            this.contact = null;
        }
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.project_BackReferenceList.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.project_BackReferenceList);
    }

    public Project getLinkedProject(int index) {
        return this.project_BackReferenceList.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.project_BackReferenceList.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.project_BackReferenceList.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.project_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.dataset_BackReferenceList.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.dataset_BackReferenceList);
    }

    public Dataset getLinkedDataset(int index) {
        return this.dataset_BackReferenceList.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.dataset_BackReferenceList.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.dataset_BackReferenceList.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.dataset_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedExperimenterList() {
        return this.experimenter_BackReferenceList.size();
    }

    public List<Experimenter> copyLinkedExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenter_BackReferenceList);
    }

    public Experimenter getLinkedExperimenter(int index) {
        return this.experimenter_BackReferenceList.get(index);
    }

    public Experimenter setLinkedExperimenter(int index, Experimenter o) {
        return this.experimenter_BackReferenceList.set(index, o);
    }

    public boolean linkExperimenter(Experimenter o) {
        return this.experimenter_BackReferenceList.add(o);
    }

    public boolean unlinkExperimenter(Experimenter o) {
        return this.experimenter_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Group_element) {
        Reference o;
        if (Group_element == null) {
            Group_element = document.createElementNS(NAMESPACE, "Group");
        }
        if (this.name != null) {
            Group_element.setAttribute("Name", this.name.toString());
        }
        if (this.id != null) {
            Group_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Group_element.appendChild(description_element);
        }
        if (this.leader != null) {
            o = new Leader();
            ((Leader)o).setID(this.leader.getID());
            Group_element.appendChild(((Leader)o).asXMLElement(document));
        }
        if (this.contact != null) {
            o = new Contact();
            ((Contact)o).setID(this.contact.getID());
            Group_element.appendChild(((Contact)o).asXMLElement(document));
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        if (this.project_BackReferenceList != null) {
            // empty if block
        }
        if (this.dataset_BackReferenceList != null) {
            // empty if block
        }
        if (this.experimenter_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Group_element);
    }
}

