/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class External
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/BinaryFile/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(External.class);
    private String href;
    private Compression compression;
    private String sha1;

    public External() {
    }

    public External(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"External".equals(tagName)) {
            LOGGER.debug("Expecting node name of External got {}", (Object)tagName);
        }
        if (element.hasAttribute("href")) {
            this.sethref(String.valueOf(element.getAttribute("href")));
        }
        if (element.hasAttribute("Compression")) {
            this.setCompression(Compression.fromString(element.getAttribute("Compression")));
        }
        if (element.hasAttribute("SHA1")) {
            this.setSHA1(String.valueOf(element.getAttribute("SHA1")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String gethref() {
        return this.href;
    }

    public void sethref(String href) {
        this.href = href;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public String getSHA1() {
        return this.sha1;
    }

    public void setSHA1(String sha1) {
        this.sha1 = sha1;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element External_element) {
        if (External_element == null) {
            External_element = document.createElementNS(NAMESPACE, "External");
        }
        if (this.href != null) {
            External_element.setAttribute("href", this.href.toString());
        }
        if (this.compression != null) {
            External_element.setAttribute("Compression", this.compression.toString());
        }
        if (this.sha1 != null) {
            External_element.setAttribute("SHA1", this.sha1.toString());
        }
        return super.asXMLElement(document, External_element);
    }
}

