/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Arc
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Arc.class);
    private ArcType type;

    public Arc() {
    }

    public Arc(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Arc".equals(tagName)) {
            LOGGER.debug("Expecting node name of Arc got {}", (Object)tagName);
        }
        if (element.hasAttribute("Type")) {
            this.setType(ArcType.fromString(element.getAttribute("Type")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public ArcType getType() {
        return this.type;
    }

    public void setType(ArcType type) {
        this.type = type;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Arc_element) {
        if (Arc_element == null) {
            Arc_element = document.createElementNS(NAMESPACE, "Arc");
        }
        if (this.type != null) {
            Arc_element.setAttribute("Type", this.type.toString());
        }
        return super.asXMLElement(document, Arc_element);
    }
}

